/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTypeCompletionProposal;

public class OverrideCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private IJavaScriptProject fJavaProject;
    private String fMethodName;
    private String[] fParamTypes;

    public OverrideCompletionProposal(IJavaScriptProject jproject, IJavaScriptUnit cu, String methodName, String[] paramTypes, int start, int length, String displayName, String completionProposal) {
        super(completionProposal, cu, start, length, null, displayName, 0);
        Assert.isNotNull((Object)jproject);
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)paramTypes);
        Assert.isNotNull((Object)cu);
        this.fParamTypes = paramTypes;
        this.fMethodName = methodName;
        this.fJavaProject = jproject;
        StringBuffer buffer = new StringBuffer();
        buffer.append(completionProposal);
        buffer.append(" {};");
        this.setReplacementString(buffer.toString());
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fMethodName;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite importRewrite) throws CoreException, BadLocationException {
        ASTRewrite rewrite;
        IFunctionBinding[] bindings;
        Document buffer = new Document(document.get());
        int index = offset - 1;
        while (index >= 0 && Character.isJavaIdentifierPart(buffer.getChar(index))) {
            --index;
        }
        int length = offset - index - 1;
        buffer.replace(index + 1, length, " ");
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setSource(buffer.get().toCharArray());
        parser.setUnitName(this.fCompilationUnit.getResource().getFullPath().toString());
        parser.setProject(this.fCompilationUnit.getJavaScriptProject());
        JavaScriptUnit unit = (JavaScriptUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        ITypeBinding binding = null;
        ChildListPropertyDescriptor descriptor = null;
        ASTNode node = NodeFinder.perform((ASTNode)unit, index + 1, 0);
        if (node instanceof AnonymousClassDeclaration) {
            switch (node.getParent().getNodeType()) {
                case 14: {
                    binding = ((ClassInstanceCreation)node.getParent()).resolveTypeBinding();
                }
            }
            descriptor = AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        } else if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)node;
            descriptor = declaration.getBodyDeclarationsProperty();
            binding = declaration.resolveBinding();
        }
        if (binding != null && (bindings = StubUtility2.getOverridableMethods((rewrite = ASTRewrite.create((AST)unit.getAST())).getAST(), binding, true)) != null && bindings.length > 0) {
            ArrayList<IFunctionBinding> candidates = new ArrayList<IFunctionBinding>(bindings.length);
            IFunctionBinding method = null;
            index = 0;
            while (index < bindings.length) {
                if (bindings[index].getName().equals(this.fMethodName) && bindings[index].getParameterTypes().length == this.fParamTypes.length) {
                    candidates.add(bindings[index]);
                }
                ++index;
            }
            if (candidates.size() > 1) {
                method = Bindings.findMethodInHierarchy(binding, this.fMethodName, this.fParamTypes);
                if (method == null) {
                    ITypeBinding objectType = rewrite.getAST().resolveWellKnownType("java.lang.Object");
                    method = Bindings.findMethodInType(objectType, this.fMethodName, this.fParamTypes);
                }
            } else if (candidates.size() == 1) {
                method = (IFunctionBinding)candidates.get(0);
            }
            if (method != null) {
                CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fJavaProject);
                ListRewrite rewriter = rewrite.getListRewrite(node, descriptor);
                String key = method.getKey();
                FunctionDeclaration stub = null;
                index = 0;
                while (index < bindings.length) {
                    if (key.equals(bindings[index].getKey())) {
                        stub = StubUtility2.createImplementationStub(this.fCompilationUnit, rewrite, importRewrite, bindings[index], binding.getName(), false, settings);
                        if (stub == null) break;
                        rewriter.insertFirst((ASTNode)stub, null);
                        break;
                    }
                    ++index;
                }
                if (stub != null) {
                    Document contents = new Document(this.fCompilationUnit.getBuffer().getContents());
                    IRegion region = contents.getLineInformationOfOffset(this.getReplacementOffset());
                    ITrackedNodePosition position = rewrite.track(stub);
                    String indent = IndentManipulation.extractIndentString((String)contents.get(region.getOffset(), region.getLength()), (int)settings.tabWidth, (int)settings.indentWidth);
                    try {
                        rewrite.rewriteAST((IDocument)contents, this.fJavaProject.getOptions(true)).apply((IDocument)contents, 2);
                    }
                    catch (MalformedTreeException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                    catch (BadLocationException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                    this.setReplacementString(IndentManipulation.changeIndent((String)Strings.trimIndentation(contents.get(position.getStartPosition(), position.getLength()), settings.tabWidth, settings.indentWidth, false), (int)0, (int)settings.tabWidth, (int)settings.indentWidth, (String)indent, (String)TextUtilities.getDefaultLineDelimiter((IDocument)contents)));
                }
            }
        }
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

