/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.jsdi.ArrayReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.BooleanValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.FunctionReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.NullValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.NumberValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.ObjectReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.Property;
import org.eclipse.wst.jsdt.debug.core.jsdi.StringValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.UndefinedValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugElement;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptPrimitiveValue;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptProperty;
import org.eclipse.wst.jsdt.debug.internal.core.model.ModelMessages;

public class JavaScriptValue
extends JavaScriptDebugElement
implements IJavaScriptValue {
    public static final String PROTO = "[proto]";
    public static final String THIS = "this";
    private Value value;
    private List properties;

    public JavaScriptValue(JavaScriptDebugTarget target, Value value) {
        super(target);
        this.value = value;
    }

    protected Value getUnderlyingValue() {
        return this.value;
    }

    public String getDetailString() {
        if (this.value instanceof ArrayReference) {
            ArrayReference array = (ArrayReference)this.value;
            List values = array.getValues();
            Iterator iterator = values.iterator();
            if (!iterator.hasNext()) {
                return "[]";
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            while (true) {
                Value jsValue = (Value)iterator.next();
                buffer.append(JavaScriptValue.getValueString(jsValue));
                if (!iterator.hasNext()) {
                    return buffer.append(']').toString();
                }
                buffer.append(", ");
            }
        }
        if (this.value instanceof JavaScriptPrimitiveValue) {
            JavaScriptPrimitiveValue nvalue = (JavaScriptPrimitiveValue)((Object)this.value);
            return nvalue.stringValue();
        }
        return this.value.valueString();
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.value != null) {
            if (this.value instanceof ObjectReference) {
                if (this.value instanceof NullValue) {
                    return "null";
                }
                if (this.value instanceof ArrayReference) {
                    return "array";
                }
                if (this.value instanceof FunctionReference) {
                    return "function";
                }
                return "object";
            }
            if (this.value instanceof BooleanValue) {
                return "boolean";
            }
            if (this.value instanceof UndefinedValue) {
                return "undefined";
            }
            if (this.value instanceof NumberValue) {
                return "number";
            }
            if (this.value instanceof StringValue) {
                return "string";
            }
        }
        return "unknown";
    }

    public String getValueString() throws DebugException {
        return JavaScriptValue.getValueString(this.value);
    }

    private static String getValueString(Value jsValue) {
        NumberValue nvalue;
        if (jsValue instanceof ObjectReference) {
            ObjectReference ref = (ObjectReference)jsValue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(NLS.bind((String)ModelMessages.JavaScriptValue_object_value_label, (Object[])new String[]{jsValue.valueString(), ref.id().toString()}));
            return buffer.toString();
        }
        if (jsValue instanceof NumberValue && !(nvalue = (NumberValue)jsValue).isNaN()) {
            return JavaScriptDebugModel.numberToString(nvalue.value());
        }
        if (jsValue instanceof StringValue) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('\"');
            buffer.append(jsValue.valueString().replaceAll("\"", "\\\\\""));
            buffer.append('\"');
            return buffer.toString();
        }
        return jsValue.valueString();
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (!this.hasVariables()) {
            return null;
        }
        if (this.properties == null) {
            final ObjectReference reference = (ObjectReference)this.value;
            List underlyingProperties = reference.properties();
            this.properties = new ArrayList(underlyingProperties.size() + 1);
            Iterator iterator = underlyingProperties.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                JavaScriptProperty jsdiProperty = new JavaScriptProperty(this, property);
                this.properties.add(jsdiProperty);
            }
            Collections.sort(this.properties, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    String name1;
                    String name0;
                    block6: {
                        block5: {
                            try {
                                name0 = ((IVariable)arg0).getName();
                                name1 = ((IVariable)arg1).getName();
                                if (!Character.isDigit(name0.charAt(0))) break block5;
                                if (Character.isDigit(name1.charAt(0))) {
                                    return Integer.valueOf(name0).compareTo(Integer.valueOf(name1));
                                }
                                return -1;
                            }
                            catch (DebugException debugException) {
                                return 0;
                            }
                        }
                        if (!Character.isDigit(name1.charAt(0))) break block6;
                        return 1;
                    }
                    return name0.compareToIgnoreCase(name1);
                }
            });
            Property prototype = new Property(){

                public VirtualMachine virtualMachine() {
                    return reference.virtualMachine();
                }

                public String name() {
                    return JavaScriptValue.PROTO;
                }

                public Value value() {
                    return reference.prototype();
                }
            };
            this.properties.add(0, new JavaScriptProperty(this, prototype));
        }
        return this.properties.toArray(new IVariable[this.properties.size()]);
    }

    public boolean hasVariables() throws DebugException {
        if (this.value instanceof ObjectReference) {
            return !(this.value instanceof NullValue);
        }
        return false;
    }

    public boolean isAllocated() throws DebugException {
        return this.properties != null;
    }

    public boolean isNull() {
        return this.value instanceof NullValue;
    }

    public static IJavaScriptValue createValue(JavaScriptDebugTarget target, Value value) {
        if (value instanceof BooleanValue || value instanceof NullValue || value instanceof NumberValue) {
            return new JavaScriptPrimitiveValue(target, value);
        }
        return new JavaScriptValue(target, value);
    }
}

