/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.war.ui.util.WebServletGroupItemProvider;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupServletItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.WebAppProvider;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.MultiSelectFilteredFileSelectionDialog;
import org.eclipse.jst.servlet.ui.internal.wizard.NewWebClassWizardPage;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewServletClassWizardPage
extends NewWebClassWizardPage {
    private static final String[] JSPEXTENSIONS = new String[]{"jsp"};

    public NewServletClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    protected String getUseExistingCheckboxText() {
        return IWebWizardConstants.USE_EXISTING_SERVLET_CLASS;
    }

    protected String getUseExistingProperty() {
        return "NewServletClassDataModel.USE_EXISTING_CLASS";
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        if (selection instanceof WebServletGroupItemProvider) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)((WebServletGroupItemProvider)selection).getParent();
            return ProjectUtilities.getProject((EObject)webApp);
        }
        if (selection instanceof WebAppProvider) {
            return ((WebAppProvider)selection).getProject();
        }
        if (selection instanceof GroupServletItemProvider) {
            WebApp webApp = (WebApp)((GroupServletItemProvider)selection).getJavaEEObject();
            return ProjectUtilities.getProject((Object)webApp);
        }
        return super.getExtendedSelectedProject(selection);
    }

    protected void handleClassButtonSelected() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        try {
            IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
            if (project == null) {
                return;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            MultiSelectFilteredFileSelectionDialog ms = new MultiSelectFilteredFileSelectionDialog(this.getShell(), IWebWizardConstants.NEW_SERVLET_WIZARD_WINDOW_TITLE, IWebWizardConstants.CHOOSE_SERVLET_CLASS, JSPEXTENSIONS, false, project);
            IContainer root = component.getRootFolder().getUnderlyingFolder();
            ms.setInput(root);
            ms.open();
            if (ms.getReturnCode() == 0) {
                String qualifiedClassName = "";
                if (ms.getSelectedItem() == 0) {
                    Object obj = ms.getFirstResult();
                    if (obj != null && obj instanceof IFile) {
                        IFile file = (IFile)obj;
                        IPath pFull = file.getFullPath();
                        IPath pBase = root.getFullPath();
                        IPath path = pFull.removeFirstSegments(pBase.segmentCount());
                        qualifiedClassName = path.makeAbsolute().toString();
                        this.model.setProperty("NewServletClassDataModel.IS_SERVLET_TYPE", (Object)new Boolean(false));
                    }
                } else {
                    IType type = (IType)ms.getFirstResult();
                    if (type != null) {
                        qualifiedClassName = type.getFullyQualifiedName();
                        this.model.setProperty("NewServletClassDataModel.IS_SERVLET_TYPE", (Object)new Boolean(true));
                    }
                }
                this.existingClassText.setText(qualifiedClassName);
            }
        }
        finally {
            this.getControl().setCursor(null);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        Object obj = this.getSelectedObject();
        if (this.isServlet(obj)) {
            this.checkExistingButton(true);
            if (this.isServletJSP(obj)) {
                this.existingClassText.setText(this.getServletJSPFile(obj));
                this.model.setBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE", false);
            } else {
                this.existingClassText.setText(this.getServletClass(obj));
                this.model.setBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE", true);
            }
        } else if (this.isJSP(obj)) {
            this.checkExistingButton(true);
            this.existingClassText.setText(this.getWebResourcePath((IResource)obj));
            this.model.setBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE", false);
        }
        return composite;
    }
}

