/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationOperation;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.SimpleValidateEdit;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class J2EEProjectUtilities
extends ProjectUtilities
implements IJ2EEFacetConstants {
    public static IPath getRuntimeLocation(IProject aProject) {
        if (JemProjectUtilities.isBinaryProject((IProject)aProject)) {
            return J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        }
        return JemProjectUtilities.getJavaProjectOutputAbsoluteLocation((IProject)aProject);
    }

    public static IPath getBinaryProjectJARLocation(IProject aProject) {
        List sources = JemProjectUtilities.getLocalJARPathsFromClasspath((IProject)aProject);
        if (!sources.isEmpty()) {
            IPath path = (IPath)sources.get(0);
            return aProject.getFile(path).getLocation();
        }
        return null;
    }

    public static Archive getClientJAR(EJBJarFile file, EARFile earFile) {
        EJBJar jar = null;
        try {
            jar = file.getDeploymentDescriptor();
        }
        catch (DeploymentDescriptorLoadException deploymentDescriptorLoadException) {
            return null;
        }
        if (jar == null) {
            return null;
        }
        String clientJAR = jar.getEjbClientJar();
        if (clientJAR == null || clientJAR.length() == 0) {
            return null;
        }
        String normalized = ArchiveUtil.deriveEARRelativeURI((String)clientJAR, (String)file.getURI());
        if (normalized != null) {
            try {
                File aFile = earFile.getFile(normalized);
                if (aFile.isArchive() && !aFile.isModuleFile()) {
                    return (Archive)aFile;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendJavaClassPath(IProject p, IClasspathEntry newEntry) throws JavaModelException {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (Platform.getOS().equals("win32")) {
                if (entry.getPath().toString().equalsIgnoreCase(newEntry.getPath().toString())) return;
                newPathList.add(entry);
            } else {
                if (entry.getPath().equals((Object)newEntry.getPath())) return;
                newPathList.add(entry);
            }
            ++i;
        }
        newPathList.add(newEntry);
        IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Archive asArchiveFromBinary(String jarUri, IProject aProject) throws OpenFailureException {
        IPath path = J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        if (path != null) {
            String location = path.toOSString();
            Archive anArchive = CommonarchiveFactory.eINSTANCE.primOpenArchive(location);
            anArchive.setURI(jarUri);
            return anArchive;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static ArchiveManifest readManifest(IFile aFile) {
        ArchiveManifestImpl archiveManifestImpl;
        InputStream in;
        block16: {
            block14: {
                block15: {
                    in = null;
                    if (aFile != null && aFile.exists()) break block14;
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            in = aFile.getContents();
            archiveManifestImpl = new ArchiveManifestImpl(in);
            if (in == null) break block16;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return archiveManifestImpl;
        catch (Exception ex) {
            block17: {
                try {
                    J2EEPlugin.logError(ex);
                    if (in == null) break block17;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static ArchiveManifest readManifest(IProject p) {
        ArchiveManifestImpl archiveManifestImpl;
        InputStream in;
        block16: {
            IFile aFile;
            block14: {
                block15: {
                    in = null;
                    aFile = J2EEProjectUtilities.getManifestFile(p);
                    if (aFile != null && aFile.exists()) break block14;
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            in = aFile.getContents();
            archiveManifestImpl = new ArchiveManifestImpl(in);
            if (in == null) break block16;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return archiveManifestImpl;
        catch (Exception ex) {
            block17: {
                try {
                    J2EEPlugin.logError(ex);
                    if (in == null) break block17;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static IFile getManifestFile(IProject project) {
        return J2EEProjectUtilities.getManifestFile(project, true);
    }

    public static IFile getManifestFile(IProject p, boolean createIfNecessary) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)p);
        try {
            IFile file = ComponentUtilities.findFile((IVirtualComponent)component, (IPath)new Path("META-INF/MANIFEST.MF"));
            if (createIfNecessary && file == null) {
                IVirtualFolder virtualFolder = component.getRootFolder();
                file = virtualFolder.getUnderlyingFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
                try {
                    ManifestFileCreationAction.createManifestFile(file, p);
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(e);
                }
                catch (IOException e) {
                    J2EEPlugin.logError(e);
                }
            }
            return file;
        }
        catch (CoreException ce) {
            J2EEPlugin.logError(ce);
            return null;
        }
    }

    public static void writeManifest(IProject aProject, ArchiveManifest manifest) throws IOException {
        J2EEProjectUtilities.writeManifest(aProject, J2EEProjectUtilities.getManifestFile(aProject), manifest);
    }

    public static void writeManifest(IFile aFile, ArchiveManifest manifest) throws IOException {
        J2EEProjectUtilities.writeManifest(aFile.getProject(), aFile, manifest);
    }

    private static void writeManifest(IProject aProject, IFile aFile, ArchiveManifest manifest) throws IOException {
        if (aFile != null && SimpleValidateEdit.validateEdit((IFile[])new IFile[]{aFile})) {
            ManifestUtilities.writeManifest((IFile)aFile, (org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest)manifest);
            J2EEComponentClasspathUpdater.getInstance().queueUpdateModule(aProject);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest readManifest(IVirtualComponent component) {
        if (!component.isBinary()) {
            IVirtualFile vManifest = component.getRootFolder().getFile("META-INF/MANIFEST.MF");
            if (!vManifest.exists()) return null;
            IFile manifestFile = vManifest.getUnderlyingFile();
            InputStream in = null;
            try {
                in = manifestFile.getContents();
                ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl(in);
                return archiveManifestImpl;
            }
            catch (IOException e) {
                J2EEPlugin.logError(e);
                return null;
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
                return null;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        J2EEPlugin.logError(e);
                    }
                }
            }
        }
        JavaEEBinaryComponentHelper helper = null;
        try {
            helper = new JavaEEBinaryComponentHelper(component);
            IArchive archive = null;
            InputStream in = null;
            try {
                archive = helper.accessArchive();
                if (archive == null) {
                }
                Path manifestPath = new Path("META-INF/MANIFEST.MF");
                if (!archive.containsArchiveResource((IPath)manifestPath)) {
                }
                IArchiveResource manifestResource = archive.getArchiveResource((IPath)manifestPath);
                if (manifestResource != null) {
                    ArchiveManifestImpl manifest;
                    in = manifestResource.getInputStream();
                    ArchiveManifestImpl archiveManifestImpl = manifest = new ArchiveManifestImpl(in);
                    return archiveManifestImpl;
                }
            }
            catch (FileNotFoundException e) {
                J2EEPlugin.logError(e);
                return null;
            }
            catch (IOException e) {
                J2EEPlugin.logError(e);
                return null;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        J2EEPlugin.logError(e);
                    }
                }
                if (archive != null) {
                    helper.releaseArchive(archive);
                }
            }
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    public static Map collectEJBClientJARs(EARFile earFile) {
        if (earFile == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<EJBJarFile, Archive> ejbClientJARs = null;
        List ejbJARFiles = earFile.getEJBJarFiles();
        Archive clientJAR = null;
        int i = 0;
        while (i < ejbJARFiles.size()) {
            EJBJarFile ejbJarFile = (EJBJarFile)ejbJARFiles.get(i);
            clientJAR = J2EEProjectUtilities.getClientJAR(ejbJarFile, earFile);
            if (clientJAR != null) {
                if (ejbClientJARs == null) {
                    ejbClientJARs = new HashMap<EJBJarFile, Archive>();
                }
                ejbClientJARs.put(ejbJarFile, clientJAR);
            }
            ++i;
        }
        return ejbClientJARs == null ? Collections.EMPTY_MAP : ejbClientJARs;
    }

    public static String computeRelativeText(String referencingURI, String referencedURI, EnterpriseBean bean) {
        if (bean == null) {
            return null;
        }
        String beanName = bean.getName();
        if (beanName == null) {
            return null;
        }
        String relativeUri = J2EEProjectUtilities.computeRelativeText(referencingURI, referencedURI);
        if (relativeUri == null) {
            return beanName;
        }
        return String.valueOf(relativeUri) + "#" + beanName;
    }

    public static String computeRelativeText(String referencingURI, String referencedURI) {
        if (referencingURI == null || referencedURI == null) {
            return null;
        }
        Path pPre = new Path(referencingURI);
        Path pDep = new Path(referencedURI);
        if (pPre.getDevice() != null || pDep.getDevice() != null) {
            return null;
        }
        pPre = pPre.makeRelative();
        pDep = pDep.makeRelative();
        while (pPre.segmentCount() > 1 && pDep.segmentCount() > 1 && pPre.segment(0).equals(pDep.segment(0))) {
            pPre = pPre.removeFirstSegments(1);
            pDep = pDep.removeFirstSegments(1);
        }
        Object result = null;
        StringBuffer buf = new StringBuffer();
        String segment = null;
        do {
            segment = pDep.lastSegment();
            pPre = pPre.removeLastSegments(1);
            pDep = pDep.removeLastSegments(1);
            if (segment != null) {
                result = result == null ? new Path(segment) : new Path(segment).append((IPath)result);
            }
            if (pPre.equals((Object)pDep) || pPre.isEmpty()) continue;
            buf.append("../");
        } while (!pPre.equals((Object)pDep));
        if (result != null) {
            buf.append(result.makeRelative().toString());
        }
        return buf.toString();
    }

    public static IProject getEJBProjectFromEJBClientProject(IProject ejbClientProject) {
        try {
            if (ejbClientProject != null && ejbClientProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IProject[] allProjects = J2EEProjectUtilities.getAllProjects();
                int i = 0;
                while (i < allProjects.length) {
                    if (EarModuleManager.getEJBModuleExtension().getEJBJar(allProjects[i]) != null && ejbClientProject == EarModuleManager.getEJBModuleExtension().getDefinedEJBClientJARProject(allProjects[i])) {
                        return allProjects[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static EnterpriseBean getEnterpriseBean(ICompilationUnit cu) {
        IProject proj = cu.getJavaProject().getProject();
        EJBJar jar = EarModuleManager.getEJBModuleExtension().getEJBJar(proj);
        if (jar == null) {
            jar = EarModuleManager.getEJBModuleExtension().getEJBJar(J2EEProjectUtilities.getEJBProjectFromEJBClientProject(proj));
        }
        if (jar != null) {
            int index = cu.getElementName().indexOf(46);
            String className = cu.getElementName();
            if (index > 0) {
                className = className.substring(0, index);
            }
            JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(cu.getParent().getElementName(), className, jar.eResource().getResourceSet());
            return jar.getEnterpriseBeanWithReference(javaClass);
        }
        return null;
    }

    public static IContainer getSourceFolderOrFirst(IProject p, String defaultSourceName) {
        IPath sourcePath;
        block4: {
            try {
                sourcePath = J2EEProjectUtilities.getSourcePathOrFirst(p, defaultSourceName);
                if (sourcePath != null) break block4;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (sourcePath.isEmpty()) {
            return p;
        }
        return p.getFolder(sourcePath);
    }

    public static void removeBuilders(IProject project, List builderids) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] oldSpec = desc.getBuildSpec();
        int oldLength = oldSpec.length;
        if (oldLength == 0) {
            return;
        }
        int remaining = 0;
        int i = 0;
        while (i < oldSpec.length) {
            if (builderids.contains(oldSpec[i].getBuilderName())) {
                oldSpec[i] = null;
            } else {
                ++remaining;
            }
            ++i;
        }
        if (remaining == oldSpec.length) {
            return;
        }
        ICommand[] newSpec = new ICommand[remaining];
        int i2 = 0;
        int newIndex = 0;
        while (i2 < oldLength) {
            if (oldSpec[i2] != null) {
                newSpec[newIndex++] = oldSpec[i2];
            }
            ++i2;
        }
        desc.setBuildSpec(newSpec);
        project.setDescription(desc, 0, null);
    }

    public static IPath getSourcePathOrFirst(IProject p, String defaultSourceName) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            J2EEPlugin.logError((CoreException)((Object)ex));
            return null;
        }
        IClasspathEntry firstSource = null;
        IPath defaultSourcePath = null;
        if (defaultSourceName != null) {
            defaultSourcePath = J2EEProjectUtilities.createPath((IProject)p, (String)defaultSourceName);
        }
        boolean found = false;
        int i = 0;
        while (i < cp.length) {
            IPath sourceFolderPath;
            IFolder sourceFolder;
            if (cp[i].getEntryKind() == 3 && J2EEProjectUtilities.isSourceFolderAnInputContainer(sourceFolder = p.getFolder(sourceFolderPath = cp[i].getPath().removeFirstSegments(1)))) {
                found = true;
                if (firstSource == null) {
                    firstSource = cp[i];
                    if (defaultSourcePath == null) break;
                }
                if (cp[i].getPath().equals((Object)defaultSourcePath) && defaultSourcePath != null) {
                    return defaultSourcePath.removeFirstSegments(1);
                }
            }
            ++i;
        }
        if (!found) {
            i = 0;
            while (i < cp.length) {
                if (cp[i].getEntryKind() == 3) {
                    if (firstSource == null) {
                        firstSource = cp[i];
                        if (defaultSourcePath == null) break;
                    }
                    if (cp[i].getPath().equals((Object)defaultSourcePath) && defaultSourcePath != null) {
                        return defaultSourcePath.removeFirstSegments(1);
                    }
                }
                ++i;
            }
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(p.getName())) {
            return firstSource.getPath().removeFirstSegments(1);
        }
        return null;
    }

    public static boolean isSourceFolderAnInputContainer(IFolder sourceFolder) {
        IProject project;
        block8: {
            IFolder parent = sourceFolder;
            do {
                if ((parent = parent.getParent()) != null) continue;
                return false;
            } while (!(parent instanceof IProject));
            project = (IProject)parent;
            if (project.isAccessible()) break block8;
            return false;
        }
        try {
            if (JavaEEProjectUtilities.isEJBProject(project)) {
                return sourceFolder.findMember("META-INF/ejb-jar.xml") != null;
            }
            if (JavaEEProjectUtilities.isApplicationClientProject(project)) {
                return sourceFolder.findMember("META-INF/application-client.xml") != null;
            }
            if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
                return sourceFolder.findMember("WEB-INF/web.xml") != null;
            }
            if (JavaEEProjectUtilities.isJCAProject(project)) {
                return sourceFolder.findMember("META-INF/ra.xml") != null;
            }
        }
        catch (Exception e) {
            J2EEPlugin.logError(e);
        }
        return false;
    }

    public static Archive asArchive(String jarUri, IProject project, boolean exportSource) throws OpenFailureException {
        return J2EEProjectUtilities.asArchive(jarUri, project, exportSource, true);
    }

    public static Archive asArchive(String jarUri, IProject project, boolean exportSource, boolean includeClasspathComponents) throws OpenFailureException {
        JavaComponentLoadStrategyImpl strat = new JavaComponentLoadStrategyImpl(ComponentCore.createComponent((IProject)project), includeClasspathComponents);
        strat.setExportSource(exportSource);
        return CommonarchiveFactory.eINSTANCE.primOpenArchive((LoadStrategy)strat, jarUri);
    }

    public static boolean isProjectOfType(IProject project, String typeID) {
        return JavaEEProjectUtilities.isProjectOfType(project, typeID);
    }

    public static boolean isEARProject(IProject project) {
        return JavaEEProjectUtilities.isEARProject(project);
    }

    public static boolean isDynamicWebComponent(IVirtualComponent component) {
        return JavaEEProjectUtilities.isDynamicWebComponent(component);
    }

    public static boolean isDynamicWebProject(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject(project);
    }

    public static boolean isStaticWebProject(IProject project) {
        return JavaEEProjectUtilities.isStaticWebProject(project);
    }

    public static boolean isEJBComponent(IVirtualComponent component) {
        return JavaEEProjectUtilities.isEJBComponent(component);
    }

    public static boolean isEJBProject(IProject project) {
        return JavaEEProjectUtilities.isEJBProject(project);
    }

    public static boolean isJCAComponent(IVirtualComponent component) {
        return JavaEEProjectUtilities.isJCAComponent(component);
    }

    public static boolean isJCAProject(IProject project) {
        return JavaEEProjectUtilities.isJCAProject(project);
    }

    public static boolean isApplicationClientComponent(IVirtualComponent component) {
        return JavaEEProjectUtilities.isApplicationClientComponent(component);
    }

    public static boolean isApplicationClientProject(IProject project) {
        return JavaEEProjectUtilities.isApplicationClientProject(project);
    }

    public static boolean isUtilityProject(IProject project) {
        return JavaEEProjectUtilities.isUtilityProject(project);
    }

    public static boolean isStandaloneProject(IProject project) {
        return EarUtilities.isStandaloneProject(project);
    }

    public static IProject[] getReferencingEARProjects(IProject project) {
        return EarUtilities.getReferencingEARProjects(project);
    }

    public static IProject[] getReferencingWebProjects(IProject project) {
        if (project != null && JavaEEProjectUtilities.isDynamicWebProject(project)) {
            return new IProject[]{project};
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualComponent[] refComponents = component.getReferencingComponents();
            int i = 0;
            while (i < refComponents.length) {
                if (JavaEEProjectUtilities.isDynamicWebProject(refComponents[i].getProject())) {
                    result.add(refComponents[i].getProject());
                }
                ++i;
            }
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static IProject[] getAllProjectsInWorkspaceOfType(String type) {
        return JavaEEProjectUtilities.getAllProjectsInWorkspaceOfType(type);
    }

    public static String getJ2EEComponentType(IVirtualComponent component) {
        return JavaEEProjectUtilities.getJ2EEComponentType(component);
    }

    public static String getJ2EEProjectType(IProject project) {
        return JavaEEProjectUtilities.getJ2EEProjectType(project);
    }

    public static String getJ2EEDDProjectVersion(IProject project) {
        return JavaEEProjectUtilities.getJ2EEDDProjectVersion(project);
    }

    public static IRuntime getServerRuntime(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject == null) {
            return null;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getRuntime();
        if (runtime == null) {
            return null;
        }
        return FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
    }

    public static String getJ2EEProjectVersion(IProject project) {
        String type = J2EEProjectUtilities.getJ2EEProjectType(project);
        IFacetedProject facetedProject = null;
        IProjectFacet facet = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            facet = ProjectFacetsManager.getProjectFacet((String)type);
        }
        catch (Exception exception) {}
        if (facet != null && facetedProject != null && facetedProject.hasProjectFacet(facet)) {
            return facetedProject.getInstalledVersion(facet).getVersionString();
        }
        return null;
    }

    public static JavaProjectMigrationOperation createFlexJavaProjectForProjectOperation(IProject project) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
        model.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)project.getName());
        return new JavaProjectMigrationOperation(model);
    }

    public static JavaProjectMigrationOperation createFlexJavaProjectForProjectOperation(IProject project, boolean addToEAR) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
        model.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)project.getName());
        model.setBooleanProperty("IJavaProjectMigrationDataModelProperties.ADD_TO_EAR", addToEAR);
        return new JavaProjectMigrationOperation(model);
    }

    public static IPackageFragmentRoot[] getSourceContainers(IProject project) {
        IJavaProject jProject = JemProjectUtilities.getJavaProject((IProject)project);
        if (jProject == null) {
            return new IPackageFragmentRoot[0];
        }
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IResource resource;
                if (roots[i].getKind() == 1 && (resource = roots[i].getResource()) != null) {
                    IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
                    boolean found = false;
                    int j = 0;
                    while (!found && j < vResources.length) {
                        if (vResources[j].getComponent().equals(vc)) {
                            if (!list.contains(roots[i])) {
                                list.add(roots[i]);
                            }
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            J2EEPlugin.logError((CoreException)((Object)e));
        }
        return list.toArray(new IPackageFragmentRoot[list.size()]);
    }

    public static IContainer[] getOutputContainers(IProject project) {
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)project);
        List containers = JavaLiteUtilities.getJavaOutputContainers((IVirtualComponent)virtualComponent);
        return containers.toArray(new IContainer[containers.size()]);
    }

    public static IContainer getOutputContainer(IProject project, IPackageFragmentRoot sourceContainer) {
        try {
            return JavaLiteUtilities.getJavaOutputContainer((IJavaProjectLite)JavaCoreLite.create((IProject)project), (IClasspathEntry)sourceContainer.getRawClasspathEntry());
        }
        catch (JavaModelException e) {
            J2EEPlugin.logError((CoreException)((Object)e));
            return null;
        }
    }

    public static IContainer[] getAllOutputContainers(IProject project) {
        return J2EEProjectUtilities.getOutputContainers(project);
    }

    public static IPath getResolvedPathForArchiveComponent(String name) {
        URI uri = URI.createURI((String)name);
        String resourceType = uri.segment(0);
        URI contenturi = ModuleURIUtil.trimToRelativePath((URI)uri, (int)1);
        String contentName = contenturi.toString();
        if (resourceType.equals("lib")) {
            return Path.fromOSString((String)contentName);
        }
        if (resourceType.equals("var")) {
            IPath path;
            String classpathVar = contenturi.segment(0);
            URI remainingPathuri = ModuleURIUtil.trimToRelativePath((URI)contenturi, (int)1);
            String remainingPath = remainingPathuri.toString();
            String[] classpathvars = JavaCore.getClasspathVariableNames();
            boolean found = false;
            int i = 0;
            while (i < classpathvars.length) {
                if (classpathVar.equals(classpathvars[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found && (path = JavaCore.getClasspathVariable((String)classpathVar)) != null) {
                URI finaluri = URI.createURI((String)(String.valueOf(path.toOSString()) + '/' + remainingPath));
                return Path.fromOSString((String)finaluri.toString());
            }
        }
        return null;
    }

    public static List getAllJavaNonFlexProjects() throws CoreException {
        ArrayList<IProject> nonFlexJavaProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible() && projects[i].hasNature("org.eclipse.jdt.core.javanature") && !projects[i].hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                nonFlexJavaProjects.add(projects[i]);
            }
            ++i;
        }
        return nonFlexJavaProjects;
    }

    public static String getServerContextRoot(IProject project) {
        return ComponentUtilities.getServerContextRoot((IProject)project);
    }

    public static void setServerContextRoot(IProject project, String contextRoot) {
        ComponentUtilities.setServerContextRoot((IProject)project, (String)contextRoot);
    }

    public static boolean isJEEProject(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            return JavaEEProjectUtilities.isJEEComponent(component);
        }
        return false;
    }

    public static boolean isLegacyJ2EEProject(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            return JavaEEProjectUtilities.isLegacyJ2EEComponent(component);
        }
        return false;
    }

    public static IVirtualComponent getModule(IVirtualComponent earComponent, String moduleName) {
        return EarUtilities.getModule(earComponent, moduleName);
    }

    public static IVirtualReference[] getJ2EEModuleReferences(IVirtualComponent earComponent) {
        return EarUtilities.getJ2EEModuleReferences(earComponent);
    }

    public static IVirtualReference[] getComponentReferences(IVirtualComponent earComponent) {
        return EarUtilities.getComponentReferences(earComponent);
    }

    public static IVirtualReference getComponentReference(IVirtualComponent earComponent, String componentName) {
        return EarUtilities.getComponentReference(earComponent, componentName);
    }
}

