/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.validation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;

public final class DependencyUtil {
    private static final IProject[] EMPTY_PROJECTS = new IProject[0];
    private static final IJavaProject[] EMPTY_JAVAPROJECTS = new IJavaProject[0];
    private static Set _tempSet = null;

    private static Set getTempSet() {
        if (_tempSet == null) {
            _tempSet = new HashSet();
        } else {
            _tempSet.clear();
        }
        return _tempSet;
    }

    public static IProject[] getDependentProjects(IProject project) {
        if (project == null) {
            return EMPTY_PROJECTS;
        }
        IProject[] allProjects = project.getWorkspace().getRoot().getProjects();
        Set tempSet = DependencyUtil.getTempSet();
        int i = 0;
        while (i < allProjects.length) {
            IProject p = allProjects[i];
            IProject[] requires = DependencyUtil.getRequiredProjects(p);
            int j = 0;
            while (j < requires.length) {
                IProject r = requires[j];
                if (project.equals((Object)r)) {
                    tempSet.add(p);
                    break;
                }
                ++j;
            }
            ++i;
        }
        IProject[] dependency = new IProject[tempSet.size()];
        tempSet.toArray(dependency);
        return dependency;
    }

    public static IProject[] getRequiredProjects(IProject project) {
        if (project == null) {
            return EMPTY_PROJECTS;
        }
        try {
            IProject[] refProjects = project.getReferencedProjects();
            if (refProjects == null || refProjects.length == 0) {
                return EMPTY_PROJECTS;
            }
            IProject[] temp = new IProject[refProjects.length];
            int count = 0;
            int i = 0;
            while (i < refProjects.length) {
                IProject rProject = refProjects[i];
                if (rProject.exists() && rProject.isOpen()) {
                    temp[count++] = rProject;
                }
                ++i;
            }
            if (count == 0) {
                return EMPTY_PROJECTS;
            }
            if (count == temp.length) {
                return temp;
            }
            IProject[] result = new IProject[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }
        catch (CoreException exc) {
            J2EEPlugin.log(J2EEPlugin.createErrorStatus(0, project.getName(), exc));
            return EMPTY_PROJECTS;
        }
    }

    public static IJavaProject[] getDependentJavaProjects(IJavaProject javaproject) {
        if (javaproject == null) {
            return EMPTY_JAVAPROJECTS;
        }
        try {
            IJavaProject[] allProjects = javaproject.getJavaModel().getJavaProjects();
            Set tempSet = DependencyUtil.getTempSet();
            int i = 0;
            while (i < allProjects.length) {
                IJavaProject p = allProjects[i];
                IJavaProject[] requires = DependencyUtil.getRequiredJavaProjects(p);
                int j = 0;
                while (j < requires.length) {
                    IJavaProject r = requires[j];
                    if (javaproject.equals(r)) {
                        tempSet.add(p);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            IJavaProject[] dependency = new IJavaProject[tempSet.size()];
            tempSet.toArray(dependency);
            return dependency;
        }
        catch (JavaModelException exc) {
            J2EEPlugin.log(J2EEPlugin.createErrorStatus(0, javaproject.getProject().getName(), exc));
            return EMPTY_JAVAPROJECTS;
        }
    }

    public static IJavaProject[] getRequiredJavaProjects(IJavaProject javaproject) {
        if (javaproject == null) {
            return EMPTY_JAVAPROJECTS;
        }
        try {
            IJavaModel jm = javaproject.getJavaModel();
            if (jm == null) {
                J2EEPlugin.log(J2EEPlugin.createErrorStatus(0, "DependencyCache::getRequiredJavaProjects(" + javaproject.getProject().getName() + ") IJavaModel == null", null));
                return EMPTY_JAVAPROJECTS;
            }
            String[] requiredProjects = javaproject.getRequiredProjectNames();
            if (requiredProjects == null || requiredProjects.length == 0) {
                return EMPTY_JAVAPROJECTS;
            }
            IJavaProject[] temp = new IJavaProject[requiredProjects.length];
            int count = 0;
            int i = 0;
            while (i < requiredProjects.length) {
                String projectName = requiredProjects[i];
                IJavaProject jp = jm.getJavaProject(projectName);
                try {
                    if (jp != null && jp.getProject().exists() && jp.getProject().isAccessible() && jp.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                        temp[count++] = jp;
                    }
                }
                catch (CoreException exc) {
                    J2EEPlugin.log(J2EEPlugin.createErrorStatus(0, javaproject.getProject().getName(), exc));
                }
                ++i;
            }
            if (count == 0) {
                return EMPTY_JAVAPROJECTS;
            }
            if (count == temp.length) {
                return temp;
            }
            IJavaProject[] result = new IJavaProject[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }
        catch (JavaModelException exc) {
            J2EEPlugin.log(J2EEPlugin.createErrorStatus(0, javaproject.getProject().getName(), exc));
            return EMPTY_JAVAPROJECTS;
        }
    }
}

