/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.context.orm;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlUniqueConstraint;
import org.eclipse.jpt.core.jpa2.context.CollectionTable2_0;
import org.eclipse.jpt.core.resource.orm.XmlCollectionTable;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualXmlCollectionTable
extends XmlCollectionTable {
    protected OrmTypeMapping ormTypeMapping;
    protected CollectionTable2_0 collectionTable;

    public VirtualXmlCollectionTable(OrmTypeMapping ormTypeMapping, CollectionTable2_0 collectionTable) {
        this.ormTypeMapping = ormTypeMapping;
        this.collectionTable = collectionTable;
    }

    protected boolean isOrmMetadataComplete() {
        return this.ormTypeMapping.isMetadataComplete();
    }

    @Override
    public String getName() {
        if (this.isOrmMetadataComplete()) {
            return this.collectionTable.getDefaultName();
        }
        return this.collectionTable.getName();
    }

    @Override
    public void setName(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public String getCatalog() {
        if (this.isOrmMetadataComplete()) {
            return this.collectionTable.getDefaultCatalog();
        }
        return this.collectionTable.getCatalog();
    }

    @Override
    public void setCatalog(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public String getSchema() {
        if (this.isOrmMetadataComplete()) {
            return this.collectionTable.getDefaultSchema();
        }
        return this.collectionTable.getSchema();
    }

    @Override
    public void setSchema(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public EList<XmlJoinColumn> getJoinColumns() {
        EObjectContainmentEList joinColumns = new EObjectContainmentEList(XmlJoinColumn.class, (InternalEObject)this, 4);
        if (this.collectionTable == null || this.isOrmMetadataComplete()) {
            return joinColumns;
        }
        for (JoinColumn joinColumn : CollectionTools.iterable(this.collectionTable.specifiedJoinColumns())) {
            VirtualXmlJoinColumn xmlJoinColumn = new VirtualXmlJoinColumn(joinColumn, this.isOrmMetadataComplete());
            joinColumns.add((Object)xmlJoinColumn);
        }
        return joinColumns;
    }

    @Override
    public EList<XmlUniqueConstraint> getUniqueConstraints() {
        EObjectContainmentEList xmlUniqueConstraints = new EObjectContainmentEList(XmlUniqueConstraint.class, (InternalEObject)this, 3);
        if (this.collectionTable == null || this.isOrmMetadataComplete()) {
            return xmlUniqueConstraints;
        }
        for (UniqueConstraint uniqueConstraint : CollectionTools.iterable(this.collectionTable.uniqueConstraints())) {
            VirtualXmlUniqueConstraint xmlUniqueConstraint = new VirtualXmlUniqueConstraint(uniqueConstraint, this.isOrmMetadataComplete());
            xmlUniqueConstraints.add((Object)xmlUniqueConstraint);
        }
        return xmlUniqueConstraints;
    }

    @Override
    public TextRange getNameTextRange() {
        return null;
    }

    @Override
    public TextRange getCatalogTextRange() {
        return null;
    }

    @Override
    public TextRange getSchemaTextRange() {
        return null;
    }
}

