/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.TaglibBasedViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.w3c.dom.Element;

public class JSPViewDefnAdapter
extends TaglibBasedViewDefnAdapter {
    JSPViewDefnAdapter(ITagRegistry tldTagRegistry) {
        super(tldTagRegistry);
    }

    public IDocument getContainer(DTFacesContext context, String viewId) {
        IResource viewDefn = context.adaptContextObject();
        if (viewDefn instanceof IFile) {
            IFile viewDefnFile = (IFile)viewDefn;
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(viewDefnFile);
                if (model instanceof DOMModelForJSP) {
                    IStructuredDocument iStructuredDocument = model.getStructuredDocument();
                    return iStructuredDocument;
                }
            }
            catch (IOException e) {
                JSFCorePlugin.log(e, "Acquiring model for view root");
            }
            catch (CoreException e) {
                JSFCorePlugin.log((Exception)((Object)e), "Acquiring model for view root");
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return null;
    }

    public final String getNamespace(Element element, IDocument doc) {
        String prefix = element.getPrefix();
        TLDCMDocumentManager m = TaglibController.getTLDCMDocumentManager((IDocument)doc);
        if (prefix == null || m == null) {
            return null;
        }
        List trackers = m.getTaglibTrackers();
        for (Object name : trackers) {
            TaglibTracker tracker = (TaglibTracker)name;
            if (!prefix.equals(tracker.getPrefix())) continue;
            return tracker.getURI();
        }
        return null;
    }

    public XMLViewDefnAdapter.DTELExpression getELExpression(IModelContext genericContext) throws IDTViewHandler.ViewHandlerException {
        String regionType;
        IStructuredDocumentContext context = (IStructuredDocumentContext)genericContext.getAdapter(IStructuredDocumentContext.class);
        if (context == null) {
            throw new IDTViewHandler.ViewHandlerException(IDTViewHandler.ViewHandlerException.Cause.EL_NOT_FOUND);
        }
        ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
        String elText = null;
        if (resolver != null && (regionType = resolver.getRegionType()) != null && resolver.matchesRelative(new String[]{"XML_TAG_ATTRIBUTE_VALUE"})) {
            IStructuredDocumentContext previousContext;
            ITextRegionContextResolver prevResolver;
            if ("JSP_VBL_CONTENT".equals(regionType)) {
                elText = resolver.getRegionText();
            } else if (regionType.equals("JSP_VBL_CLOSE") && (prevResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(previousContext = resolver.getPreviousContext())) != null) {
                if ("JSP_VBL_CONTENT".equals(prevResolver.getRegionType())) {
                    resolver = prevResolver;
                    elText = prevResolver.getRegionText();
                } else if ("JSP_VBL_OPEN".equals(prevResolver.getRegionType())) {
                    elText = "";
                }
            }
        }
        if (elText != null) {
            IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), resolver.getStartOffset());
            return new XMLViewDefnAdapter.DTELExpression(elContext, elText);
        }
        return null;
    }

    public String getGeneratedIdPrefix() {
        return "_idJsp";
    }

    public String getPrefix(String namespace, IDocument doc) {
        TLDCMDocumentManager m = TaglibController.getTLDCMDocumentManager((IDocument)doc);
        if (m == null) {
            return null;
        }
        List trackers = m.getTaglibTrackers();
        for (TaglibTracker tracker : trackers) {
            if (namespace.equals(tracker.getURI())) {
                return tracker.getPrefix();
            }
            CMDocument cmdoc = tracker.getDocument();
            if (!(cmdoc instanceof TLDDocument) || !namespace.equals(((TLDDocument)cmdoc).getUri())) continue;
            return tracker.getPrefix();
        }
        return null;
    }
}

