/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.project.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.ArchiveFile;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryInternalReference;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryRegistryUtil;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.IJAXRSFacetInstallDataModelProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements IJAXRSFacetInstallDataModelProperties {
    private String errorMessage;
    private LibraryInstallDelegate libraryInstallDelegate = null;
    private IPropertyChangeListener propertyChangeListener = null;

    public Set<String> getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IJAXRSFacetInstallDataModelProperties.SHAREDLIBRARY");
        names.add("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME");
        names.add("IJAXRSFacetInstallDataModelProperties.WEBPROJECT_NAME");
        names.add("IJAXRSFacetInstallDataModelProperties.ADD_TO_EAR");
        names.add("IJAXRSFacetInstallDataModelProperties.TARGETRUNTIME");
        names.add("IJAXRSFacetInstallDataModelProperties.SERVLET_NAME");
        names.add("IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        names.add("IJAXRSFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        names.add("IJAXRSFacetInstallDataModelProperties.WEBCONTENT_DIR");
        names.add("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        names.add("IJAXRSFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION");
        names.add("IJAXRSFacetInstallDataModelProperties.CONFIGURATION_PRESET");
        names.add("IJAXRSFacetInstallDataModelProperties.SERVER_IRUNTIME");
        names.add("IJAXRSFacetInstallDataModelProperties.EARPROJECTS");
        names.add("IJAXRSFacetInstallDataModelProperties.UPDATEDD");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME")) {
            return null;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.WEBPROJECT_NAME")) {
            return null;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.ADD_TO_EAR")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.TARGETRUNTIME")) {
            return null;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.SERVLET_NAME")) {
            return "JAX-RS Servlet";
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME")) {
            return "";
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.SERVLET_URL_PATTERNS")) {
            return new String[]{"/jaxrs/*"};
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.jaxrs";
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.WEBCONTENT_DIR")) {
            return "WebContent";
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return this.libraryInstallDelegate;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.CONFIGURATION_PRESET")) {
            return null;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.SERVER_IRUNTIME")) {
            return null;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.EARPROJECTS")) {
            return null;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.SHAREDLIBRARY")) {
            return false;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION")) {
            return true;
        }
        if (propertyName.equals("IJAXRSFacetInstallDataModelProperties.UPDATEDD")) {
            return true;
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String name) {
        this.errorMessage = null;
        if (name.equals("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return ((LibraryInstallDelegate)this.getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).validate();
        }
        if (name.equals("IJAXRSFacetInstallDataModelProperties.SERVLET_NAME") || name.equals("IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME") || name.equals("IJAXRSFacetInstallDataModelProperties.UPDATEDD")) {
            if (this.getBooleanProperty("IJAXRSFacetInstallDataModelProperties.UPDATEDD")) {
                return this.validateServletInfo(this.getStringProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_NAME"), this.getStringProperty("IJAXRSFacetInstallDataModelProperties.SERVLET_CLASSNAME"));
            }
            return super.validate(name);
        }
        return super.validate(name);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY") || propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
            this.initLibraryInstallDelegate();
            if (this.libraryInstallDelegate != null && propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
                IProjectFacetVersion fv = (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
                this.libraryInstallDelegate.setProjectFacetVersion(fv);
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private void initLibraryInstallDelegate() {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        IProjectFacetVersion fv = (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
        if (this.libraryInstallDelegate == null && fpjwc != null && fv != null) {
            this.libraryInstallDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fpjwc, fv);
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChanged(String property, Object oldValue, Object newValue) {
                    IDataModel dm = JAXRSFacetInstallDataModelProvider.this.getDataModel();
                    if (dm != null) {
                        dm.notifyPropertyChange("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", 1);
                    }
                }
            };
            this.libraryInstallDelegate.addListener(this.propertyChangeListener, new String[0]);
        }
    }

    public void dispose() {
        if (this.libraryInstallDelegate != null) {
            this.libraryInstallDelegate.removeListener(this.propertyChangeListener);
            this.libraryInstallDelegate.dispose();
        }
        super.dispose();
    }

    private IStatus createErrorStatus(String msg) {
        return new Status(4, "org.eclipse.jst.ws.jaxrs.core", msg);
    }

    private IStatus validateServletInfo(String servletName, String servletClassName) {
        if (servletName == null || servletName.trim().length() == 0) {
            this.errorMessage = Messages.JAXRSFacetInstallDataModelProvider_ValidateServletName;
            return this.createErrorStatus(this.errorMessage);
        }
        if (servletClassName == null || servletClassName.trim().length() == 0) {
            this.errorMessage = Messages.JAXRSFacetInstallDataModelProvider_ValidateServletClassName;
            return this.createErrorStatus(this.errorMessage);
        }
        return OK_STATUS;
    }

    private IProject getProject() {
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        if (projName == null || "".equals(projName)) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return project;
    }

    private boolean doesProjectExist() {
        IProject project = this.getProject();
        return project != null && project.exists();
    }

    private IStatus checkForDupeArchiveFiles(Set<String> jars, JAXRSLibrary aJAXRSLib) {
        if (aJAXRSLib == null) {
            return OK_STATUS;
        }
        for (ArchiveFile jar : aJAXRSLib.getArchiveFiles()) {
            if (jars.contains(jar.getResolvedSourceLocation())) {
                return this.createErrorStatus(NLS.bind((String)Messages.JAXRSFacetInstallDataModelProvider_DupeJarValidation, (Object)jar.getResolvedSourceLocation()));
            }
            jars.add(jar.getResolvedSourceLocation());
        }
        return OK_STATUS;
    }

    private List<JAXRSLibraryInternalReference> getDefaultJAXRSImplementationLibraries() {
        JAXRSLibrary jaxrsLib;
        ArrayList<JAXRSLibraryInternalReference> list = new ArrayList<JAXRSLibraryInternalReference>();
        if (JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryRegistry() != null && (jaxrsLib = JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryRegistry().getDefaultImplementation()) != null) {
            JAXRSLibraryInternalReference prjJAXRSLib = new JAXRSLibraryInternalReference(jaxrsLib, true, true, false);
            list.add(prjJAXRSLib);
        }
        return list;
    }

    private JAXRSLibraryInternalReference getDefaultImplementationLibrary() {
        if (JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryRegistry() != null) {
            JAXRSLibrary jaxrsLib = JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryRegistry().getDefaultImplementation();
            return new JAXRSLibraryInternalReference(jaxrsLib, true, true, false);
        }
        return null;
    }
}

