/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.debugger;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.Breakpoint;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.ContextData;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.DebugSessionManager;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.FunctionSource;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.ScriptSource;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.StackFrame;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.ThreadData;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebuggerImpl
implements Debugger,
ContextFactory.Listener {
    public static final DebuggableScript[] NO_SCRIPTS = new DebuggableScript[0];
    private static final String RHINO_SCHEME = "rhino";
    private final Map threadToThreadId = new HashMap();
    private final Map threadIdToData = new HashMap();
    private final Map breakpoints = new HashMap();
    private long currentThreadId = 0L;
    private long currentBreakpointId = 0L;
    private long currentScriptId = 0L;
    private ArrayList disabledThreads = new ArrayList();
    private HashMap uriToScript = new HashMap();
    private HashMap idToScript = new HashMap();
    private final DebugSessionManager sessionManager;

    public RhinoDebuggerImpl(String configString) {
        this.sessionManager = DebugSessionManager.create(configString);
    }

    public RhinoDebuggerImpl(TransportService transportService, String address, boolean startSuspended, boolean trace) {
        this.sessionManager = new DebugSessionManager(transportService, address, startSuspended, trace);
    }

    public synchronized DebugFrame getFrame(Context context, DebuggableScript debuggableScript) {
        ScriptSource script = this.getScript(debuggableScript);
        if (script != null && !script.isStdIn()) {
            ContextData contextData = (ContextData)context.getDebuggerContextData();
            ThreadData thread = (ThreadData)this.threadIdToData.get(contextData.getThreadId());
            FunctionSource function = script.getFunction(debuggableScript);
            return thread.getFrame(context, function, script);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptSource getScript(DebuggableScript script) {
        HashMap hashMap = this.uriToScript;
        synchronized (hashMap) {
            DebuggableScript root = script;
            while (!root.isTopLevel()) {
                root = root.getParent();
            }
            URI uri = this.getSourceUri(root, this.parseSourceProperties(root.getSourceName()));
            if (uri != null) {
                return (ScriptSource)this.uriToScript.get(uri);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompilationDone(Context context, DebuggableScript script, String source) {
        if (!script.isTopLevel()) {
            return;
        }
        Map properties = this.parseSourceProperties(script.getSourceName());
        URI uri = this.getSourceUri(script, properties);
        if (uri == null) {
            return;
        }
        ScriptSource newscript = new ScriptSource(script, source, uri, script.isGeneratedScript(), properties);
        HashMap hashMap = this.uriToScript;
        synchronized (hashMap) {
            ScriptSource old = (ScriptSource)this.uriToScript.remove(uri);
            Long id = null;
            if (old != null) {
                id = old.getId();
                this.idToScript.remove(id);
                newscript.setId(id);
                old.clearBreakpoints(this);
            } else {
                id = this.scriptId();
                newscript.setId(id);
            }
            this.uriToScript.put(uri, newscript);
            this.idToScript.put(id, newscript);
        }
        ContextData contextData = (ContextData)context.getDebuggerContextData();
        contextData.scriptLoaded(newscript);
    }

    private URI getSourceUri(DebuggableScript script, Map properties) {
        String jsonName;
        String sourceName = script.getSourceName();
        if (properties != null && (jsonName = (String)properties.get("name")) != null) {
            sourceName = jsonName;
        }
        if (sourceName == null) {
            return null;
        }
        if (sourceName.equals("<stdin>")) {
            sourceName = "stdin";
        }
        if (sourceName.equals("<command>")) {
            sourceName = "command";
        } else {
            File sourceFile = new File(sourceName);
            if (sourceFile.exists()) {
                return sourceFile.toURI();
            }
            try {
                return new URI(sourceName);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        try {
            if (sourceName.charAt(0) != '/') {
                sourceName = "/" + sourceName;
            }
            return new URI(RHINO_SCHEME, null, sourceName, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    Map parseSourceProperties(String sourceName) {
        if (sourceName != null && sourceName.charAt(0) == '{') {
            try {
                Object json = JSONUtil.read(sourceName);
                if (json instanceof Map) {
                    return (Map)json;
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    synchronized Long scriptId() {
        return new Long(this.currentScriptId++);
    }

    public synchronized void contextCreated(Context context) {
        ThreadData threadData;
        Thread thread = Thread.currentThread();
        if (this.disabledThreads.contains(thread)) {
            return;
        }
        Long threadId = (Long)this.threadToThreadId.get(thread);
        if (threadId == null) {
            threadId = new Long(this.currentThreadId++);
            this.threadToThreadId.put(thread, threadId);
        }
        if ((threadData = (ThreadData)this.threadIdToData.get(threadId)) == null) {
            threadData = new ThreadData(threadId, this);
            this.threadIdToData.put(threadId, threadData);
            this.sendThreadEvent("enter", threadId);
        }
        threadData.contextCreated(context);
    }

    private void sendThreadEvent(String type, Long threadId) {
        EventPacket threadEvent = new EventPacket("thread");
        Map body = threadEvent.getBody();
        body.put("type", type);
        body.put("threadId", threadId);
        this.sendEvent(threadEvent);
    }

    public synchronized void contextReleased(Context context) {
        Thread thread = Thread.currentThread();
        if (this.disabledThreads.contains(thread)) {
            return;
        }
        Long threadId = (Long)this.threadToThreadId.get(thread);
        if (threadId == null) {
            return;
        }
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        threadData.contextReleased(context);
        if (!threadData.hasContext()) {
            this.threadToThreadId.remove(thread);
            this.threadIdToData.remove(threadId);
            this.sendThreadEvent("exit", threadId);
        }
    }

    public synchronized void resume(Long threadId, String stepType) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData != null) {
            threadData.resume(stepType);
        }
    }

    public synchronized void resumeAll() {
        Iterator it = this.threadIdToData.keySet().iterator();
        while (it.hasNext()) {
            Long threadId = (Long)it.next();
            this.resume(threadId, null);
        }
    }

    public synchronized void suspend(Long threadId) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData != null) {
            threadData.suspend();
        }
    }

    public synchronized void suspendAll() {
        Iterator it = this.threadIdToData.keySet().iterator();
        while (it.hasNext()) {
            Long threadId = (Long)it.next();
            this.suspend(threadId);
        }
    }

    public void disconnect() {
    }

    public synchronized List getFrameIds(Long threadId) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData == null) {
            return Collections.EMPTY_LIST;
        }
        return threadData.getFrameIds();
    }

    public synchronized StackFrame getFrame(Long threadId, Long frameId) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData != null) {
            return threadData.getFrame(frameId);
        }
        return null;
    }

    public synchronized List getScriptIds() {
        return new ArrayList(this.idToScript.keySet());
    }

    public synchronized ScriptSource getScript(Long scriptId) {
        return (ScriptSource)this.idToScript.get(scriptId);
    }

    public synchronized Collection getBreakpoints() {
        return this.breakpoints.keySet();
    }

    public synchronized Breakpoint setBreakpoint(Long scriptId, Integer lineNumber, String functionName, String condition, Long threadId) {
        ScriptSource script = (ScriptSource)this.idToScript.get(scriptId);
        if (script == null || !script.isValid(lineNumber, functionName)) {
            return null;
        }
        Breakpoint newbreakpoint = new Breakpoint(this.nextBreakpointId(), script, lineNumber, functionName, condition, threadId);
        Breakpoint oldbp = script.getBreakpoint(lineNumber, functionName);
        if (oldbp != null) {
            this.breakpoints.remove(oldbp.breakpointId);
        }
        this.breakpoints.put(newbreakpoint.breakpointId, newbreakpoint);
        script.addBreakpoint(newbreakpoint);
        return newbreakpoint;
    }

    private synchronized Long nextBreakpointId() {
        return new Long(this.currentBreakpointId++);
    }

    public synchronized Breakpoint clearBreakpoint(Long breakpointId) {
        Breakpoint breakpoint = (Breakpoint)this.breakpoints.remove(breakpointId);
        if (breakpoint != null) {
            breakpoint.delete();
        }
        return breakpoint;
    }

    public boolean sendEvent(EventPacket event) {
        return this.sessionManager.sendEvent(event);
    }

    public Breakpoint getBreakpoint(Long breakpointId) {
        return (Breakpoint)this.breakpoints.get(breakpointId);
    }

    public synchronized ThreadData getThreadData(Long threadId) {
        return (ThreadData)this.threadIdToData.get(threadId);
    }

    public synchronized List getThreadIds() {
        return new ArrayList(this.threadIdToData.keySet());
    }

    public synchronized void disableThread() {
        this.disabledThreads.add(Thread.currentThread());
    }

    public synchronized void enableThread() {
        this.disabledThreads.remove(Thread.currentThread());
    }

    public void start() {
        this.sessionManager.start(this);
    }

    public void stop() {
        this.sessionManager.stop();
    }

    public boolean isConnected() {
        return this.sessionManager.isConnected();
    }
}

