/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.archive.ArchiveMessages;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveSaveAdapter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class J2EEComponentArchiveSaveAdapter
extends ComponentArchiveSaveAdapter {
    protected final String DOT_CLASS = ".class";
    protected final String DOT_JAVA = ".java";
    protected final String IMPORTED_CLASSES = "ImportedClasses";
    protected boolean importedClassesFolderCreated = false;
    protected IFolder importedClassesFolder;

    public J2EEComponentArchiveSaveAdapter(IVirtualComponent vComponent) {
        super(vComponent);
    }

    public void save(IProgressMonitor monitor) throws ArchiveSaveFailureException {
        try {
            monitor.beginTask(NLS.bind((String)ArchiveMessages.ComponentArchiveSaveAdapter_Importing_0_, (Object)this.vComponent.getName()), 1110);
            super.save((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            this.linkImportedClassesFolderIfNecessary();
            monitor.worked(10);
            try {
                this.vComponent.getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            }
            catch (CoreException ex) {
                J2EEPlugin.logError(ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean endsWithClassType(String aFileName) {
        return aFileName != null && aFileName.endsWith(".class");
    }

    protected boolean shouldSave(IArchiveResource aFile) {
        if (this.endsWithClassType(aFile.getPath().lastSegment())) {
            boolean shouldSave = this.isClassWithoutSource(aFile);
            if (shouldSave && !this.importedClassesFolderCreated) {
                this.createImportedClassesFolder();
            }
            return shouldSave;
        }
        return super.shouldSave(aFile);
    }

    protected void createImportedClassesFolder() {
        this.importedClassesFolderCreated = true;
        IContainer jarParent = this.vComponent.getRootFolder().getUnderlyingFolder().getParent();
        this.importedClassesFolder = jarParent.getFolder((IPath)new Path("ImportedClasses"));
        try {
            this.importedClassesFolder.create(true, true, null);
        }
        catch (CoreException e1) {
            J2EEPlugin.logError(e1);
        }
    }

    protected void linkImportedClassesFolderIfNecessary() {
        if (this.importedClassesFolder != null) {
            try {
                this.vComponent.getRootFolder().getFolder(this.getImportedClassesRuntimePath()).createLink(this.importedClassesFolder.getProjectRelativePath(), 0, null);
                if (this.shouldAddImportedClassesToClasspath() && JemProjectUtilities.getJavaProject((IProject)this.vComponent.getProject()) != null) {
                    IJavaProject javaProject = JavaCore.create((IProject)this.vComponent.getProject());
                    IClasspathEntry[] javaClasspath = javaProject.getRawClasspath();
                    IClasspathEntry[] newJavaClasspath = new IClasspathEntry[javaClasspath.length + 1];
                    System.arraycopy(javaClasspath, 0, newJavaClasspath, 0, javaClasspath.length);
                    newJavaClasspath[newJavaClasspath.length - 1] = JavaCore.newLibraryEntry((IPath)this.importedClassesFolder.getFullPath(), null, null, (boolean)true);
                    javaProject.setRawClasspath(newJavaClasspath, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
            }
        }
    }

    protected boolean shouldAddImportedClassesToClasspath() {
        return true;
    }

    protected IPath getImportedClassesRuntimePath() {
        return new Path("/");
    }

    protected IPath getProjectRelativePath(IArchiveResource aFile) {
        if (this.endsWithClassType(aFile.getPath().lastSegment())) {
            return this.importedClassesFolder.getFile(this.getImportedClassesURI(aFile)).getProjectRelativePath();
        }
        return super.getProjectRelativePath(aFile);
    }

    protected IPath getImportedClassesURI(IArchiveResource aFile) {
        return aFile.getPath();
    }

    protected boolean isClassWithoutSource(IArchiveResource aFile) {
        String javaUri = this.classUriToJavaUri(aFile.getPath().toString());
        if (javaUri == null) {
            return false;
        }
        return !this.archive.containsArchiveResource((IPath)new Path(javaUri));
    }

    public String classUriToJavaUri(String classUri) {
        if (classUri == null || !classUri.endsWith(".class")) {
            return null;
        }
        String truncated = J2EEComponentArchiveSaveAdapter.truncateIgnoreCase(classUri, ".class");
        StringTokenizer tok = new StringTokenizer(truncated, "$");
        return tok.nextToken().concat(".java");
    }

    public static String truncateIgnoreCase(String aString, String trailingSubString) {
        int index = aString.toLowerCase().lastIndexOf(trailingSubString.toLowerCase());
        if (index != -1) {
            return aString.substring(0, index);
        }
        return aString;
    }
}

