/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.EnumType;
import org.eclipse.jpt.core.context.EnumeratedConverter;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaEnumeratedConverter;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericJavaEnumeratedConverter
extends AbstractJavaJpaContextNode
implements JavaEnumeratedConverter {
    protected EnumType specifiedEnumType;
    protected JavaResourcePersistentAttribute resourcePersistenceAttribute;

    public GenericJavaEnumeratedConverter(JavaAttributeMapping parent, JavaResourcePersistentAttribute jrpa) {
        super(parent);
        this.initialize(jrpa);
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    public String getType() {
        return "enumeratedConverter";
    }

    protected String getAnnotationName() {
        return "javax.persistence.Enumerated";
    }

    public void addToResourceModel() {
        this.resourcePersistenceAttribute.addAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistenceAttribute.removeAnnotation(this.getAnnotationName());
    }

    public EnumType getEnumType() {
        return this.getSpecifiedEnumType() == null ? this.getDefaultEnumType() : this.getSpecifiedEnumType();
    }

    public EnumType getDefaultEnumType() {
        return EnumeratedConverter.DEFAULT_ENUM_TYPE;
    }

    public EnumType getSpecifiedEnumType() {
        return this.specifiedEnumType;
    }

    public void setSpecifiedEnumType(EnumType newSpecifiedEnumType) {
        EnumType oldSpecifiedEnumType = this.specifiedEnumType;
        this.specifiedEnumType = newSpecifiedEnumType;
        this.getResourceEnumerated().setValue(EnumType.toJavaResourceModel(newSpecifiedEnumType));
        this.firePropertyChanged("specifiedEnumType", (Object)oldSpecifiedEnumType, (Object)newSpecifiedEnumType);
    }

    protected void setSpecifiedEnumType_(EnumType newSpecifiedEnumType) {
        EnumType oldSpecifiedEnumType = this.specifiedEnumType;
        this.specifiedEnumType = newSpecifiedEnumType;
        this.firePropertyChanged("specifiedEnumType", (Object)oldSpecifiedEnumType, (Object)newSpecifiedEnumType);
    }

    protected EnumeratedAnnotation getResourceEnumerated() {
        return (EnumeratedAnnotation)this.resourcePersistenceAttribute.getAnnotation(this.getAnnotationName());
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistenceAttribute = jrpa;
        this.specifiedEnumType = this.specifiedEnumType(this.getResourceEnumerated());
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistenceAttribute = jrpa;
        this.setSpecifiedEnumType_(this.specifiedEnumType(this.getResourceEnumerated()));
    }

    protected EnumType specifiedEnumType(EnumeratedAnnotation resourceEnumerated) {
        return resourceEnumerated == null ? null : EnumType.fromJavaResourceModel(resourceEnumerated.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceEnumerated().getTextRange(astRoot);
    }
}

