/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.jpa2.resource.java.StaticMetamodelAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceStaticMetamodelAnnotation
extends SourceAnnotation<Type>
implements StaticMetamodelAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.metamodel.StaticMetamodel");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceStaticMetamodelAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private String fullyQualifiedClassName;

    public SourceStaticMetamodelAnnotation(JavaResourcePersistentType parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new MemberAnnotationElementAdapter<String>(type, VALUE_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.metamodel.StaticMetamodel";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
        this.fullyQualifiedClassName = this.buildFullyQualifiedClassName(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
        this.syncFullyQualifiedClassName(this.buildFullyQualifiedClassName(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue(value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return this.valueAdapter.getValue(astRoot);
    }

    @Override
    public String getFullyQualifiedClassName() {
        return this.fullyQualifiedClassName;
    }

    private void syncFullyQualifiedClassName(String astfullyQualifiedClassName) {
        String old = this.fullyQualifiedClassName;
        this.fullyQualifiedClassName = astfullyQualifiedClassName;
        this.firePropertyChanged("fullyQualifiedClassName", old, astfullyQualifiedClassName);
    }

    private String buildFullyQualifiedClassName(CompilationUnit astRoot) {
        return this.value == null ? null : ASTTools.resolveFullyQualifiedName(this.valueAdapter.getExpression(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter<String>(DECLARATION_ANNOTATION_ADAPTER, "value", SimpleTypeStringExpressionConverter.instance());
    }
}

