/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.jpa2.resource.java.GeneratedAnnotationDefinition;
import org.eclipse.jpt.core.internal.jpa2.resource.java.StaticMetamodelAnnotationDefinition;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePersistentAttribute;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePersistentMember;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.jpa2.resource.java.GeneratedAnnotation;
import org.eclipse.jpt.core.jpa2.resource.java.JavaResourcePersistentType2_0;
import org.eclipse.jpt.core.jpa2.resource.java.StaticMetamodelAnnotation;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.IntReference;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourcePersistentType
extends SourcePersistentMember<Type>
implements JavaResourcePersistentType2_0 {
    private String name;
    private String qualifiedName;
    private String superclassQualifiedName;
    private String declaringTypeName;
    private boolean abstract_;
    private final Vector<JavaResourcePersistentType> types = new Vector();
    private final Vector<JavaResourcePersistentAttribute> fields = new Vector();
    private final Vector<JavaResourcePersistentAttribute> methods = new Vector();
    private AccessType access;
    private StaticMetamodelAnnotation staticMetamodelAnnotation;
    public static final String STATIC_METAMODEL_ANNOTATION_PROPERTY = "staticMetamodelAnnotation";
    private GeneratedAnnotation generatedAnnotation;
    public static final String GENERATED_ANNOTATION_PROPERTY = "generatedAnnotation";
    private static final StaticMetamodelAnnotationDefinition STATIC_METAMODEL_ANNOTATION_DEFINITION = StaticMetamodelAnnotationDefinition.instance();
    private static final GeneratedAnnotationDefinition GENERATED_ANNOTATION_DEFINITION = GeneratedAnnotationDefinition.instance();

    static JavaResourcePersistentType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, TypeDeclaration typeDeclaration, CompilationUnit astRoot) {
        JDTType type = new JDTType(typeDeclaration, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentType jrpt = new SourcePersistentType(javaResourceCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private static JavaResourcePersistentType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, Type declaringType, TypeDeclaration typeDeclaration, int occurrence, CompilationUnit astRoot) {
        JDTType type = new JDTType(declaringType, typeDeclaration, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentType jrpt = new SourcePersistentType(javaResourceCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private SourcePersistentType(JavaResourceCompilationUnit javaResourceCompilationUnit, Type type) {
        super(javaResourceCompilationUnit, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.name = this.buildName(astRoot);
        this.qualifiedName = this.buildQualifiedName(astRoot);
        this.superclassQualifiedName = this.buildSuperclassQualifiedName(astRoot);
        this.declaringTypeName = this.buildDeclaringTypeName(astRoot);
        this.abstract_ = this.buildAbstract(astRoot);
        this.initializeTypes(astRoot);
        this.initializeFields(astRoot);
        this.initializeMethods(astRoot);
        this.access = this.buildAccess();
    }

    @Override
    void addInitialAnnotation(String jdtAnnotationName, CompilationUnit astRoot) {
        if (jdtAnnotationName.equals(STATIC_METAMODEL_ANNOTATION_DEFINITION.getAnnotationName())) {
            if (this.staticMetamodelAnnotation == null) {
                this.staticMetamodelAnnotation = STATIC_METAMODEL_ANNOTATION_DEFINITION.buildAnnotation((JavaResourcePersistentMember)this, this.member);
                this.staticMetamodelAnnotation.initialize(astRoot);
            }
        } else if (jdtAnnotationName.equals(GENERATED_ANNOTATION_DEFINITION.getAnnotationName())) {
            if (this.generatedAnnotation == null) {
                this.generatedAnnotation = GENERATED_ANNOTATION_DEFINITION.buildAnnotation((JavaResourcePersistentMember)this, this.member);
                this.generatedAnnotation.initialize(astRoot);
            }
        } else {
            super.addInitialAnnotation(jdtAnnotationName, astRoot);
        }
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncName(this.buildName(astRoot));
        this.syncQualifiedName(this.buildQualifiedName(astRoot));
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(astRoot));
        this.syncDeclaringTypeName(this.buildDeclaringTypeName(astRoot));
        this.syncAbstract(this.buildAbstract(astRoot));
        this.syncTypes(astRoot);
        this.syncFields(astRoot);
        this.syncMethods(astRoot);
        this.syncMetamodelAnnotations(astRoot);
        this.syncAccess(this.buildAccess());
    }

    private void syncMetamodelAnnotations(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        this.syncStaticMetamodelAnnotation(astRoot, binding);
        this.syncGeneratedAnnotation(astRoot, binding);
    }

    private void syncStaticMetamodelAnnotation(CompilationUnit astRoot, ITypeBinding binding) {
        if (binding != null && this.containsStaticMetamodelAnnotation(binding)) {
            if (this.staticMetamodelAnnotation != null) {
                this.staticMetamodelAnnotation.synchronizeWith(astRoot);
            } else {
                StaticMetamodelAnnotation newStaticMetamodelAnnotation = STATIC_METAMODEL_ANNOTATION_DEFINITION.buildAnnotation((JavaResourcePersistentMember)this, this.member);
                newStaticMetamodelAnnotation.initialize(astRoot);
                this.setStaticMetamodelAnnotation(newStaticMetamodelAnnotation);
            }
        } else {
            this.setStaticMetamodelAnnotation(null);
        }
    }

    private void syncGeneratedAnnotation(CompilationUnit astRoot, ITypeBinding binding) {
        if (binding != null && this.containsGeneratedAnnotation(binding)) {
            if (this.generatedAnnotation != null) {
                this.generatedAnnotation.synchronizeWith(astRoot);
            } else {
                GeneratedAnnotation newGeneratedAnnotation = GENERATED_ANNOTATION_DEFINITION.buildAnnotation((JavaResourcePersistentMember)this, this.member);
                newGeneratedAnnotation.initialize(astRoot);
                this.setGeneratedAnnotation(newGeneratedAnnotation);
            }
        } else {
            this.setGeneratedAnnotation(null);
        }
    }

    private boolean containsStaticMetamodelAnnotation(ITypeBinding binding) {
        return this.containsAnnotation(binding, STATIC_METAMODEL_ANNOTATION_DEFINITION.getAnnotationName());
    }

    private boolean containsGeneratedAnnotation(ITypeBinding binding) {
        return this.containsAnnotation(binding, GENERATED_ANNOTATION_DEFINITION.getAnnotationName());
    }

    private boolean containsAnnotation(ITypeBinding binding, String annotationName) {
        IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
            ITypeBinding annotationTypeBinding = annotationBinding.getAnnotationType();
            if (annotationTypeBinding != null && annotationTypeBinding.getQualifiedName().equals(annotationName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    Iterator<String> validAnnotationNames() {
        return this.getAnnotationProvider().typeAnnotationNames();
    }

    @Override
    Annotation buildAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildTypeAnnotation(this, (Type)this.member, mappingAnnotationName);
    }

    @Override
    Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeAnnotation(this, annotationName);
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(astRoot));
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            field.resolveTypes(astRoot);
        }
        this.syncMethods(astRoot);
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            method.resolveTypes(astRoot);
        }
        for (JavaResourcePersistentType type : this.getTypes()) {
            type.resolveTypes(astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        return binding == null ? null : binding.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void syncQualifiedName(String astQualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = astQualifiedName;
        this.firePropertyChanged("qualifiedName", old, astQualifiedName);
    }

    private String buildQualifiedName(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        return binding == null ? null : binding.getQualifiedName();
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void syncSuperclassQualifiedName(String astSuperclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = astSuperclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, astSuperclassQualifiedName);
    }

    private String buildSuperclassQualifiedName(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        if (binding == null) {
            return null;
        }
        ITypeBinding superclass = binding.getSuperclass();
        return superclass == null ? null : superclass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private void syncDeclaringTypeName(String astDeclaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = astDeclaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, astDeclaringTypeName);
    }

    private String buildDeclaringTypeName(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        if (binding == null) {
            return null;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        return declaringClass == null ? null : declaringClass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void syncAbstract(boolean astAbstract) {
        boolean old = this.abstract_;
        this.abstract_ = astAbstract;
        this.firePropertyChanged("abstract", old, astAbstract);
    }

    private boolean buildAbstract(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.member).getBinding(astRoot);
        return binding == null ? false : Modifier.isAbstract((int)binding.getModifiers());
    }

    @Override
    public AccessType getAccess() {
        return this.access;
    }

    private void syncAccess(AccessType astAccess) {
        AccessType old = this.access;
        this.access = astAccess;
        this.firePropertyChanged("access", (Object)old, (Object)astAccess);
    }

    private AccessType buildAccess() {
        return JPTTools.buildAccess(this);
    }

    @Override
    public boolean isMapped() {
        for (Annotation each : this.getAnnotations()) {
            if (!this.annotationIsMappingAnnotation(each)) continue;
            return true;
        }
        return false;
    }

    private boolean annotationIsMappingAnnotation(Annotation annotation) {
        return CollectionTools.contains(this.mappingAnnotationNames(), (Object)annotation.getAnnotationName());
    }

    private Iterator<String> mappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    public boolean hasAnyAnnotatedAttributes() {
        Iterator<JavaResourcePersistentAttribute> stream = this.persistableAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<JavaResourcePersistentType> types() {
        return this.getTypes().iterator();
    }

    private Iterable<JavaResourcePersistentType> getTypes() {
        return new LiveCloneIterable(this.types);
    }

    @Override
    public Iterator<JavaResourcePersistentType> allTypes() {
        return new TreeIterator<JavaResourcePersistentType>((JavaResourcePersistentType)this){

            protected Iterator<? extends JavaResourcePersistentType> children(JavaResourcePersistentType type) {
                return type.types();
            }
        };
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistableTypes() {
        return this.persistableMembers(this.types());
    }

    private JavaResourcePersistentType getType(String typeName, int occurrence) {
        for (JavaResourcePersistentType type : this.getTypes()) {
            if (!type.isFor(typeName, occurrence)) continue;
            return type;
        }
        return null;
    }

    private void addType(JavaResourcePersistentType type) {
        this.addItemToCollection(type, this.types, "types");
    }

    private void removeTypes(Collection<JavaResourcePersistentType> remove) {
        this.removeItemsFromCollection(remove, this.types, "types");
    }

    private void initializeTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.member).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration td = typeDeclarationArray[n2];
            String tdName = td.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.types.add(this.buildType(td, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.member).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        HashSet<JavaResourcePersistentType> typesToRemove = new HashSet<JavaResourcePersistentType>(this.types);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
            String tdName = typeDeclaration.getName().getFullyQualifiedName();
            JavaResourcePersistentType type = this.getType(tdName, occurrence = counters.increment(tdName));
            if (type == null) {
                this.addType(this.buildType(typeDeclaration, occurrence, astRoot));
            } else {
                typesToRemove.remove(type);
                type.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeTypes(typesToRemove);
    }

    private JavaResourcePersistentType buildType(TypeDeclaration nestedTypeDeclaration, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentType.newInstance(this.getJavaResourceCompilationUnit(), (Type)this.member, nestedTypeDeclaration, occurrence, astRoot);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return this.getFields().iterator();
    }

    private Iterable<JavaResourcePersistentAttribute> getFields() {
        return new LiveCloneIterable(this.fields);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFields() {
        return this.persistableMembers(this.fields());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFieldsWithSpecifiedFieldAccess() {
        return new FilteringIterator<JavaResourcePersistentAttribute>(this.persistableFields()){

            protected boolean accept(JavaResourcePersistentAttribute resourceAttribute) {
                return resourceAttribute.getSpecifiedAccess() == AccessType.FIELD;
            }
        };
    }

    private void addField(JavaResourcePersistentAttribute field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourcePersistentAttribute getField(String fieldName, int occurrence) {
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private void initializeFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.member).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourcePersistentType.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                this.fields.add(this.buildField(fieldName, occurrence, astRoot));
            }
            ++n2;
        }
    }

    private void syncFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.member).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> fieldsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.fields);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourcePersistentType.fragments(fieldDeclaration)) {
                int occurrence;
                String fieldName = fragment.getName().getFullyQualifiedName();
                JavaResourcePersistentAttribute field = this.getField(fieldName, occurrence = counters.increment(fieldName));
                if (field == null) {
                    this.addField(this.buildField(fieldName, occurrence, astRoot));
                    continue;
                }
                fieldsToRemove.remove(field);
                field.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeFields(fieldsToRemove);
    }

    private JavaResourcePersistentAttribute buildField(String fieldName, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentAttribute.newInstance((JavaResourcePersistentType)this, (Type)this.member, fieldName, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    private static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> methods() {
        return this.getMethods().iterator();
    }

    private Iterable<JavaResourcePersistentAttribute> getMethods() {
        return new LiveCloneIterable(this.methods);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableProperties() {
        return this.persistableMembers(this.methods());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistablePropertiesWithSpecifiedPropertyAccess() {
        return new FilteringIterator<JavaResourcePersistentAttribute>(this.persistableProperties()){

            protected boolean accept(JavaResourcePersistentAttribute resourceAttribute) {
                return resourceAttribute.getSpecifiedAccess() == AccessType.PROPERTY;
            }
        };
    }

    private JavaResourcePersistentAttribute getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourcePersistentAttribute method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private void initializeMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.member).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature(methodDeclaration);
            int occurrence = counters.increment(signature);
            this.methods.add(this.buildMethod(signature, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.member).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> methodsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.methods);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature(methodDeclaration);
            JavaResourcePersistentAttribute method = this.getMethod(signature, occurrence = counters.increment(signature));
            if (method == null) {
                this.addMethod(this.buildMethod(signature, occurrence, astRoot));
            } else {
                methodsToRemove.remove(method);
                method.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeMethods(methodsToRemove);
    }

    private JavaResourcePersistentAttribute buildMethod(MethodSignature signature, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentAttribute.newInstance((JavaResourcePersistentType)this, (Type)this.member, signature, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistableProperties()});
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes(AccessType specifiedAccess) {
        if (specifiedAccess == null) {
            throw new IllegalArgumentException("specified access is null");
        }
        return specifiedAccess == AccessType.FIELD ? this.persistableAttributesForFieldAccessType() : this.persistableAttributesForPropertyAccessType();
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForFieldAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistablePropertiesWithSpecifiedPropertyAccess()});
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForPropertyAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableProperties(), this.persistableFieldsWithSpecifiedFieldAccess()});
    }

    @Override
    public GeneratedAnnotation getGeneratedAnnotation() {
        return this.generatedAnnotation;
    }

    private void setGeneratedAnnotation(GeneratedAnnotation generatedAnnotation) {
        GeneratedAnnotation old = this.generatedAnnotation;
        this.generatedAnnotation = generatedAnnotation;
        this.firePropertyChanged(GENERATED_ANNOTATION_PROPERTY, old, this.generatedAnnotation);
    }

    private void setStaticMetamodelAnnotation(StaticMetamodelAnnotation staticMetamodelAnnotation) {
        StaticMetamodelAnnotation old = this.staticMetamodelAnnotation;
        this.staticMetamodelAnnotation = staticMetamodelAnnotation;
        this.firePropertyChanged(STATIC_METAMODEL_ANNOTATION_PROPERTY, old, this.staticMetamodelAnnotation);
    }

    @Override
    public boolean isGeneratedMetamodelTopLevelType(IPackageFragmentRoot sourceFolder) {
        if (!this.getSourceFolder().equals(sourceFolder)) {
            return false;
        }
        return this.isGeneratedMetamodelTopLevelType();
    }

    @Override
    public boolean isGeneratedMetamodelTopLevelType() {
        if (!this.isGenerated()) {
            return false;
        }
        Iterator<JavaResourcePersistentType> stream = this.allTypes();
        while (stream.hasNext()) {
            JavaResourcePersistentType2_0 type = (JavaResourcePersistentType2_0)stream.next();
            if (!type.isMetamodel()) continue;
            return true;
        }
        return false;
    }

    protected boolean isGenerated() {
        if (this.generatedAnnotation == null) {
            return false;
        }
        if (this.generatedAnnotation.valuesSize() != 1) {
            return false;
        }
        if (!this.generatedAnnotation.getValue(0).equals("Dali")) {
            return false;
        }
        return !StringTools.stringIsEmpty((String)this.generatedAnnotation.getDate());
    }

    @Override
    public boolean isMetamodel() {
        return this.staticMetamodelAnnotation != null;
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getJavaResourceCompilationUnit().getCompilationUnit().getAncestor(3);
    }

    private static class CounterMap {
        private final HashMap<Object, IntReference> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            IntReference counter = this.counters.get(o);
            if (counter == null) {
                counter = new IntReference();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.getValue();
        }
    }
}

