/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTModifiedDeclaration;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public abstract class JDTMember
implements Member {
    private final Type declaringType;
    private final String name;
    private final int occurrence;
    private final ICompilationUnit compilationUnit;
    private final CommandExecutor modifySharedDocumentCommandExecutor;
    private final AnnotationEditFormatter annotationEditFormatter;

    protected JDTMember(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(declaringType, name, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, DefaultAnnotationEditFormatter.instance());
    }

    protected JDTMember(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        this.declaringType = declaringType;
        this.name = name;
        this.occurrence = occurrence;
        this.compilationUnit = compilationUnit;
        this.modifySharedDocumentCommandExecutor = modifySharedDocumentCommandExecutor;
        this.annotationEditFormatter = annotationEditFormatter;
    }

    public ModifiedDeclaration getModifiedDeclaration(CompilationUnit astRoot) {
        return new JDTModifiedDeclaration(this.getBodyDeclaration(astRoot));
    }

    public ModifiedDeclaration getModifiedDeclaration() {
        return this.getModifiedDeclaration(this.buildASTRoot());
    }

    public boolean matches(String memberName, int occur) {
        return memberName.equals(this.name) && occur == this.occurrence;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.name);
    }

    protected String getName_() {
        return this.name;
    }

    protected int getOccurrence() {
        return this.occurrence;
    }

    protected Type getDeclaringType() {
        return this.declaringType;
    }

    public void edit(Member.Editor editor) {
        try {
            this.edit_(editor);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void edit_(Member.Editor editor) throws JavaModelException, BadLocationException {
        ITextFileBuffer buffer;
        boolean createWorkingCopy;
        boolean bl = createWorkingCopy = !this.compilationUnit.isWorkingCopy();
        if (createWorkingCopy) {
            this.compilationUnit.becomeWorkingCopy(null);
        }
        boolean sharedDocument = (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.compilationUnit.getResource().getFullPath(), LocationKind.NORMALIZE)) != null;
        IDocument doc = sharedDocument ? buffer.getDocument() : new Document(this.compilationUnit.getBuffer().getContents());
        try {
            CompilationUnit astRoot = this.buildASTRoot();
            astRoot.recordModifications();
            editor.edit(this.getModifiedDeclaration(astRoot));
            TextEdit edits = astRoot.rewrite(doc, this.compilationUnit.getJavaProject().getOptions(true));
            if (sharedDocument) {
                this.modifySharedDocumentCommandExecutor.execute((Command)new ModifySharedDocumentCommand(edits, doc));
            } else {
                this.applyEdits(edits, doc);
            }
        }
        finally {
            if (createWorkingCopy) {
                this.compilationUnit.getBuffer().setContents(doc.get());
                this.compilationUnit.commitWorkingCopy(true, null);
                this.compilationUnit.discardWorkingCopy();
            }
        }
    }

    protected void applyEdits(TextEdit edits, IDocument doc) throws MalformedTreeException, BadLocationException {
        edits.apply(doc, 2);
        this.annotationEditFormatter.format(doc, edits);
    }

    protected CompilationUnit buildASTRoot() {
        return ASTTools.buildASTRoot(this.compilationUnit);
    }

    protected class ModifySharedDocumentCommand
    implements Command {
        private final TextEdit edits;
        private final IDocument doc;

        protected ModifySharedDocumentCommand(TextEdit edits, IDocument doc) {
            this.edits = edits;
            this.doc = doc;
        }

        public void execute() {
            try {
                JDTMember.this.applyEdits(this.edits, this.doc);
            }
            catch (MalformedTreeException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

