/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.AbstractNestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedIndexedDeclarationAnnotationAdapter
extends AbstractNestedDeclarationAnnotationAdapter
implements IndexedDeclarationAnnotationAdapter {
    private int index;
    private static final ExpressionProvider MEMBER_VALUE_PAIR_EXPRESSION_PROVIDER = new ExpressionProvider(){

        public Expression getExpression(ASTNode node) {
            return ((MemberValuePair)node).getValue();
        }

        public void setExpression(ASTNode node, Expression expression) {
            ((MemberValuePair)node).setValue(expression);
        }

        public String toString() {
            return "MemberValuePairExpressionProvider";
        }
    };
    private static final ExpressionProvider SINGLE_MEMBER_ANNOTATION_EXPRESSION_PROVIDER = new ExpressionProvider(){

        public Expression getExpression(ASTNode node) {
            return ((SingleMemberAnnotation)node).getValue();
        }

        public void setExpression(ASTNode node, Expression expression) {
            ((SingleMemberAnnotation)node).setValue(expression);
        }

        public String toString() {
            return "SingleMemberAnnotationExpressionProvider";
        }
    };

    public NestedIndexedDeclarationAnnotationAdapter(DeclarationAnnotationAdapter annotationAdapter, int index, String annotationName) {
        super(annotationAdapter, annotationName);
        this.index = index;
    }

    public NestedIndexedDeclarationAnnotationAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, int index, String annotationName) {
        super(annotationAdapter, elementName, annotationName);
        this.index = index;
    }

    public NestedIndexedDeclarationAnnotationAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, int index, String annotationName, boolean removeOuterAnnotationWhenEmpty) {
        super(annotationAdapter, elementName, annotationName, removeOuterAnnotationWhenEmpty);
        this.index = index;
    }

    @Override
    protected Annotation getAnnotation(Expression value) {
        if (value.getNodeType() == 4) {
            return this.annotation((ArrayInitializer)value);
        }
        return this.index == 0 ? this.annotationValue(value) : null;
    }

    @Override
    protected Expression buildNewInnerExpression(Annotation inner) {
        return this.index == 0 ? inner : this.buildNewInnerArrayInitializer(inner);
    }

    @Override
    protected boolean removeAnnotation(ModifiedDeclaration declaration, Annotation outer, Expression value) {
        if (value.getNodeType() == 4) {
            this.removeAnnotation(declaration, outer, (ArrayInitializer)value);
            return true;
        }
        return this.index != 0;
    }

    @Override
    protected void modifyAnnotationValue(SingleMemberAnnotation outer, Annotation inner) {
        this.modifyExpression((ASTNode)outer, SINGLE_MEMBER_ANNOTATION_EXPRESSION_PROVIDER, inner);
    }

    @Override
    protected void modifyMemberValuePair(MemberValuePair pair, Annotation inner) {
        this.modifyExpression((ASTNode)pair, MEMBER_VALUE_PAIR_EXPRESSION_PROVIDER, inner);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void moveAnnotation(int newIndex, ModifiedDeclaration declaration) {
        int oldIndex = this.index;
        if (newIndex == oldIndex) {
            return;
        }
        Annotation original = this.getAnnotation(declaration);
        if (original == null) {
            this.index = newIndex;
            this.removeAnnotation(declaration);
        } else {
            Annotation copy = (Annotation)ASTNode.copySubtree((AST)original.getAST(), (ASTNode)original);
            this.index = newIndex;
            this.addAnnotation(declaration, copy);
            this.index = oldIndex;
            this.removeAnnotation(declaration);
            this.index = newIndex;
        }
    }

    private Annotation annotation(ArrayInitializer value) {
        List<Expression> expressions = this.expressions(value);
        return this.index >= expressions.size() ? null : this.annotationValue(expressions.get(this.index));
    }

    private ArrayInitializer buildNewInnerArrayInitializer(Annotation inner) {
        ArrayInitializer ai = inner.getAST().newArrayInitializer();
        this.addInnerToExpressions(inner, this.expressions(ai));
        return ai;
    }

    /*
     * Unable to fully structure code
     */
    private void addInnerToExpressions(Annotation inner, List<Expression> expressions) {
        if (expressions.size() <= this.index) ** GOTO lbl5
        throw new IllegalStateException("expressions size is greater than index - size: " + expressions.size() + " - index: " + this.index);
lbl-1000:
        // 1 sources

        {
            expressions.add((Expression)inner.getAST().newNullLiteral());
lbl5:
            // 2 sources

            ** while (expressions.size() < this.index)
        }
lbl6:
        // 1 sources

        expressions.add((Expression)inner);
    }

    private void removeAnnotation(ModifiedDeclaration declaration, Annotation outer, ArrayInitializer value) {
        List<Expression> expressions = this.expressions(value);
        if (this.index >= expressions.size()) {
            return;
        }
        Annotation inner = this.annotationValue(expressions.get(this.index));
        if (inner == null) {
            return;
        }
        if (!this.nameMatches(declaration, inner)) {
            return;
        }
        if (this.index == expressions.size() - 1) {
            expressions.remove(this.index);
        } else {
            expressions.set(this.index, (Expression)value.getAST().newNullLiteral());
        }
        this.trimExpressions(declaration, outer, expressions);
    }

    private void trimExpressions(ModifiedDeclaration declaration, Annotation outer, List<Expression> expressions) {
        int i = expressions.size();
        while (i-- > 0) {
            if (expressions.get(i).getNodeType() != 33) break;
            expressions.remove(i);
        }
        switch (expressions.size()) {
            case 0: {
                this.removeElementAndNormalize(declaration, outer);
                break;
            }
            case 1: {
                this.convertArrayToLastRemainingExpression(outer, expressions.get(0));
                break;
            }
        }
    }

    private void convertArrayToLastRemainingExpression(Annotation outer, Expression lastValue) {
        lastValue = (Expression)ASTNode.copySubtree((AST)lastValue.getAST(), (ASTNode)lastValue);
        if (outer.isNormalAnnotation()) {
            this.memberValuePair((NormalAnnotation)outer).setValue(lastValue);
        } else if (outer.isSingleMemberAnnotation()) {
            ((SingleMemberAnnotation)outer).setValue(lastValue);
        } else {
            throw new IllegalArgumentException("unexpected annotation type: " + outer);
        }
    }

    private void modifyExpression(ASTNode node, ExpressionProvider expProvider, Annotation inner) {
        Expression value = expProvider.getExpression(node);
        if (value.getNodeType() == 4) {
            List<Expression> expressions = this.expressions((ArrayInitializer)value);
            if (this.index >= expressions.size()) {
                this.addInnerToExpressions(inner, expressions);
            } else {
                expressions.set(this.index, (Expression)inner);
            }
        } else if (this.index == 0) {
            expProvider.setExpression(node, (Expression)inner);
        } else {
            ArrayInitializer ai = inner.getAST().newArrayInitializer();
            List<Expression> expressions = this.expressions(ai);
            expressions.add((Expression)ASTNode.copySubtree((AST)value.getAST(), (ASTNode)value));
            this.addInnerToExpressions(inner, expressions);
            expProvider.setExpression(node, (Expression)ai);
        }
    }

    protected List<Expression> expressions(ArrayInitializer ai) {
        return ai.expressions();
    }

    private static interface ExpressionProvider {
        public Expression getExpression(ASTNode var1);

        public void setExpression(ASTNode var1, Expression var2);
    }
}

