/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseTableAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestablePrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableSecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceSecondaryTableAnnotation
extends SourceBaseTableAnnotation
implements NestableSecondaryTableAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.SecondaryTable");
    private final Vector<NestablePrimaryKeyJoinColumnAnnotation> pkJoinColumns = new Vector();
    private final PkJoinColumnsAnnotationContainer pkJoinColumnsContainer = new PkJoinColumnsAnnotationContainer();

    public SourceSecondaryTableAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.SecondaryTable";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        AnnotationContainerTools.initialize(this.pkJoinColumnsContainer, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        AnnotationContainerTools.synchronize(this.pkJoinColumnsContainer, astRoot);
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getNameAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "name");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getSchemaAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "schema");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getCatalogAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "catalog");
    }

    @Override
    protected String getUniqueConstraintsElementName() {
        return "uniqueConstraints";
    }

    @Override
    public ListIterator<PrimaryKeyJoinColumnAnnotation> pkJoinColumns() {
        return new CloneListIterator(this.pkJoinColumns);
    }

    Iterable<NestablePrimaryKeyJoinColumnAnnotation> getNestablePkJoinColumns() {
        return new LiveCloneIterable(this.pkJoinColumns);
    }

    @Override
    public int pkJoinColumnsSize() {
        return this.pkJoinColumns.size();
    }

    @Override
    public NestablePrimaryKeyJoinColumnAnnotation pkJoinColumnAt(int index) {
        return this.pkJoinColumns.get(index);
    }

    @Override
    public int indexOfPkJoinColumn(PrimaryKeyJoinColumnAnnotation joinColumn) {
        return this.pkJoinColumns.indexOf(joinColumn);
    }

    @Override
    public NestablePrimaryKeyJoinColumnAnnotation addPkJoinColumn(int index) {
        return (NestablePrimaryKeyJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.pkJoinColumnsContainer);
    }

    NestablePrimaryKeyJoinColumnAnnotation addPkJoinColumn_() {
        return this.addPkJoinColumn_(this.pkJoinColumns.size());
    }

    private NestablePrimaryKeyJoinColumnAnnotation addPkJoinColumn_(int index) {
        NestablePrimaryKeyJoinColumnAnnotation pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        this.pkJoinColumns.add(pkJoinColumn);
        return pkJoinColumn;
    }

    void syncAddPkJoinColumn(Annotation astAnnotation) {
        int index = this.pkJoinColumns.size();
        NestablePrimaryKeyJoinColumnAnnotation pkJoinColumn = this.addPkJoinColumn_(index);
        pkJoinColumn.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("pkJoinColumns", index, pkJoinColumn);
    }

    private NestablePrimaryKeyJoinColumnAnnotation buildPrimaryKeyJoinColumn(int index) {
        return SourcePrimaryKeyJoinColumnAnnotation.createSecondaryTablePrimaryKeyJoinColumn(this.daa, this, this.member, index);
    }

    void pkJoinColumnAdded(int index, NestablePrimaryKeyJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("pkJoinColumns", index, joinColumn);
    }

    @Override
    public void movePkJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.pkJoinColumnsContainer);
    }

    NestablePrimaryKeyJoinColumnAnnotation movePkJoinColumn_(int targetIndex, int sourceIndex) {
        return (NestablePrimaryKeyJoinColumnAnnotation)CollectionTools.move(this.pkJoinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removePkJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.pkJoinColumnsContainer);
    }

    NestablePrimaryKeyJoinColumnAnnotation removePkJoinColumn_(int index) {
        return this.pkJoinColumns.remove(index);
    }

    void syncRemovePkJoinColumns(int index) {
        this.removeItemsFromList(index, this.pkJoinColumns, "pkJoinColumns");
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    protected IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        SecondaryTableAnnotation oldTable = (SecondaryTableAnnotation)((Object)oldAnnotation);
        for (PrimaryKeyJoinColumnAnnotation oldPkJoinColumn : CollectionTools.iterable(oldTable.pkJoinColumns())) {
            NestablePrimaryKeyJoinColumnAnnotation newPkJoinColumn = this.addPkJoinColumn(oldTable.indexOfPkJoinColumn(oldPkJoinColumn));
            newPkJoinColumn.initializeFrom((NestableAnnotation)((Object)oldPkJoinColumn));
        }
    }

    public static SourceSecondaryTableAnnotation createSecondaryTable(JavaResourceNode parent, Member member) {
        return new SourceSecondaryTableAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceSecondaryTableAnnotation createNestedSecondaryTable(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter secondaryTablesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceSecondaryTableAnnotation.buildNestedDeclarationAnnotationAdapter(index, secondaryTablesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SourceSecondaryTableAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter secondaryTablesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(secondaryTablesAdapter, index, "javax.persistence.SecondaryTable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PkJoinColumnsAnnotationContainer
    implements AnnotationContainer<NestablePrimaryKeyJoinColumnAnnotation> {
        PkJoinColumnsAnnotationContainer() {
        }

        @Override
        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceSecondaryTableAnnotation.this.getAstAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return "pkJoinColumns";
        }

        @Override
        public String getNestedAnnotationName() {
            return "javax.persistence.PrimaryKeyJoinColumn";
        }

        @Override
        public Iterable<NestablePrimaryKeyJoinColumnAnnotation> getNestedAnnotations() {
            return SourceSecondaryTableAnnotation.this.getNestablePkJoinColumns();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceSecondaryTableAnnotation.this.pkJoinColumnsSize();
        }

        @Override
        public NestablePrimaryKeyJoinColumnAnnotation addNestedAnnotation() {
            return SourceSecondaryTableAnnotation.this.addPkJoinColumn_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceSecondaryTableAnnotation.this.syncAddPkJoinColumn(astAnnotation);
        }

        @Override
        public NestablePrimaryKeyJoinColumnAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceSecondaryTableAnnotation.this.movePkJoinColumn_(targetIndex, sourceIndex);
        }

        @Override
        public NestablePrimaryKeyJoinColumnAnnotation removeNestedAnnotation(int index) {
            return SourceSecondaryTableAnnotation.this.removePkJoinColumn_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceSecondaryTableAnnotation.this.syncRemovePkJoinColumns(index);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

