/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigDialogSettingData;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;

public class JSFLibraryConfigModel {
    private final JSFLibraryConfigDialogSettingData data;
    private final JSFLibraryRegistryUtil jsfLibReg;
    private List colJSFCompLib;

    private JSFLibraryConfigModel(JSFLibraryConfigDialogSettingData data) {
        this.data = data;
        this.jsfLibReg = JSFLibraryRegistryUtil.getInstance();
    }

    public List getJSFComponentLibraries() {
        if (this.colJSFCompLib == null) {
            this.colJSFCompLib = this.jsfLibReg.getJSFComponentLibraries();
            Iterator it = this.data.getJSFComponentLibraries().iterator();
            JSFLibraryInternalReference targetItem = null;
            JSFLibraryInternalReference srcItem = null;
            while (it.hasNext()) {
                targetItem = (JSFLibraryInternalReference)it.next();
                srcItem = this.jsfLibReg.getJSFLibraryReferencebyID(targetItem.getID());
                if (srcItem == null) continue;
                srcItem.setSelected(true);
                srcItem.setToBeDeployed(targetItem.isCheckedToBeDeployed());
            }
        }
        return this.colJSFCompLib;
    }

    public List getCurrentJSFComponentLibrarySelection() {
        ArrayList<JSFLibraryInternalReference> list = new ArrayList<JSFLibraryInternalReference>();
        Iterator it = this.getJSFComponentLibraries().iterator();
        JSFLibraryInternalReference crtItem = null;
        while (it.hasNext()) {
            crtItem = (JSFLibraryInternalReference)it.next();
            if (!crtItem.isSelected()) continue;
            list.add(crtItem);
        }
        return list;
    }

    public List getSavedJSFComponentLibraries() {
        return this.data.getJSFComponentLibraries();
    }

    public void setCurrentJSFComponentLibrarySelection(List libraries) {
        if (libraries != null) {
            this.setJSFLibrariesSelection(this.getJSFComponentLibraries(), false);
            Iterator it = libraries.iterator();
            JSFLibraryInternalReference srcItem = null;
            while (it.hasNext()) {
                JSFLibraryInternalReference crtItem = (JSFLibraryInternalReference)it.next();
                srcItem = this.jsfLibReg.getJSFLibraryReferencebyID(crtItem.getID());
                if (srcItem == null) continue;
                srcItem.setSelected(true);
                srcItem.setToBeDeployed(crtItem.isCheckedToBeDeployed());
            }
        }
    }

    private void setJSFLibrariesSelection(List libs, boolean state) {
        for (JSFLibraryInternalReference crtjsflib : libs) {
            crtjsflib.setSelected(state);
        }
    }

    /* synthetic */ JSFLibraryConfigModel(JSFLibraryConfigDialogSettingData jSFLibraryConfigDialogSettingData, JSFLibraryConfigModel jSFLibraryConfigModel) {
        this(jSFLibraryConfigDialogSettingData);
    }

    public static final class JSFLibraryConfigModelFactory {
        public static JSFLibraryConfigModel createInstance(JSFLibraryConfigDialogSettingData source) {
            if (source == null) {
                throw new NullPointerException(Messages.JSFLibraryConfigModel_Null_Data_Source);
            }
            return new JSFLibraryConfigModel(source, null);
        }
    }
}

