/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.EclipseUtil;

public abstract class AbstractServerActionDelegate
implements IActionDelegate {
    protected List<IServer> servers;

    public abstract boolean accept(IServer var1);

    public abstract void perform(Shell var1, IServer var2);

    public void run(IAction action) {
        Shell shell = EclipseUtil.getShell();
        Iterator<IServer> iterator = this.servers.iterator();
        IServer obj = iterator.next();
        if (obj instanceof IServer) {
            IServer server = obj;
            if (this.accept(server)) {
                this.perform(shell, server);
            }
            this.selectionChanged(action, (ISelection)new StructuredSelection(this.servers));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.servers = new ArrayList<IServer>();
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (Object obj : (StructuredSelection)selection) {
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                if (!this.accept(server)) continue;
                this.servers.add(server);
                enabled = true;
                continue;
            }
            action.setEnabled(false);
            return;
        }
        action.setEnabled(enabled);
    }
}

