/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.eval;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class StepIntoSelectionUtils {
    static /* synthetic */ Class class$0;

    public static ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextEditor)part.getAdapter((Class)clazz);
    }

    public static IJavaScriptElement getJavaElement(IEditorInput input) {
        IJavaScriptElement je = JavaScriptUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return JavaScriptUI.getWorkingCopyManager().getWorkingCopy(input);
    }

    public static IFunction getFunction(ITextSelection selection, IJavaScriptElement element) throws JavaScriptModelException {
        if (element != null && element instanceof ICodeAssist) {
            return StepIntoSelectionUtils.resolveFunction(selection.getOffset(), selection.getLength(), (ICodeAssist)element);
        }
        return null;
    }

    private static IFunction resolveFunction(int offset, int length, ICodeAssist codeAssist) throws JavaScriptModelException {
        IJavaScriptElement[] elements = codeAssist.codeSelect(offset, length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IFunction) {
                return (IFunction)elements[i];
            }
            ++i;
        }
        return null;
    }

    public static IFunction getFirstFunctionOnLine(int offset, IEditorPart activeEditor, IJavaScriptElement element) throws JavaScriptModelException {
        if (!(activeEditor instanceof ITextEditor) || !(element instanceof ICodeAssist)) {
            return null;
        }
        ITextEditor editor = (ITextEditor)activeEditor;
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(offset);
            String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, null, (String)"1.5");
            scanner.setSource(line.toCharArray());
            scanner.resetTo(offset - lineInfo.getOffset(), lineInfo.getLength());
            int token = scanner.getNextToken();
            while (token != 158) {
                if (token == 5) {
                    int methodStart = scanner.getCurrentTokenStartPosition();
                    token = scanner.getNextToken();
                    if (token != 7) continue;
                    return StepIntoSelectionUtils.resolveFunction(lineInfo.getOffset() + methodStart, 0, (ICodeAssist)element);
                }
                token = scanner.getNextToken();
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        return null;
    }
}

