/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.ui.details.MappingUiDefinition;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.details.MapAsComposite;
import org.eclipse.jpt.ui.internal.details.orm.UnsupportedOrmMappingUiDefinition;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentAttributeMapAsComposite
extends MapAsComposite<PersistentAttribute> {
    public PersistentAttributeMapAsComposite(Pane<? extends PersistentAttribute> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected String getMappingKey() {
        return ((PersistentAttribute)this.getSubject()).getMappingKey();
    }

    @Override
    protected MapAsComposite.MappingChangeHandler buildMappingChangeHandler() {
        return new MapAsComposite.MappingChangeHandler(){

            @Override
            public String getLabelText() {
                String mappingKey = PersistentAttributeMapAsComposite.this.getMappingKey();
                if (mappingKey != MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
                    return JptUiDetailsMessages.MapAsComposite_mappedAttributeText;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).isVirtual()) {
                    return JptUiDetailsMessages.MapAsComposite_virtualAttributeText;
                }
                return JptUiDetailsMessages.MapAsComposite_unmappedAttributeText;
            }

            @Override
            public String getMappingText() {
                String mappingKey = PersistentAttributeMapAsComposite.this.getMappingKey();
                if (mappingKey == null) {
                    return JptUiDetailsMessages.MapAsComposite_changeMappingType;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getSpecifiedMapping() == null) {
                    return PersistentAttributeMapAsComposite.this.getDefaultDefinition(((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getDefaultMappingKey()).getLinkLabel();
                }
                return PersistentAttributeMapAsComposite.this.getMappingUiDefinition(mappingKey).getLinkLabel();
            }

            public void morphMapping(MappingUiDefinition definition) {
                ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).setSpecifiedMappingKey(definition.getKey());
            }

            @Override
            public String getName() {
                return ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getName();
            }

            public Iterator<? extends MappingUiDefinition<? extends PersistentAttribute, ?>> mappingUiDefinitions() {
                return PersistentAttributeMapAsComposite.this.attributeMappingUiDefinitions();
            }
        };
    }

    protected Iterator<? extends MappingUiDefinition<? extends PersistentAttribute, ?>> attributeMappingUiDefinitions() {
        return this.getJpaPlatformUi().attributeMappingUiDefinitions(((PersistentAttribute)this.getSubject()).getResourceType());
    }

    @Override
    protected DefaultMappingUiDefinition getDefaultDefinition() {
        return this.getDefaultDefinition(((PersistentAttribute)this.getSubject()).getDefaultMappingKey());
    }

    @Override
    protected DefaultMappingUiDefinition getDefaultDefinition(String mappingKey) {
        return this.getJpaPlatformUi().getDefaultAttributeMappingUiDefinition(((PersistentAttribute)this.getSubject()).getResourceType(), mappingKey);
    }

    @Override
    protected MappingUiDefinition getMappingUiDefinition(String mappingKey) {
        MappingUiDefinition definition = super.getMappingUiDefinition(mappingKey);
        if (definition != null) {
            return definition;
        }
        return UnsupportedOrmMappingUiDefinition.instance();
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultMapping");
        propertyNames.add("specifiedMapping");
        propertyNames.add("name");
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "specifiedMapping" || propertyName == "defaultMapping" || propertyName == "name") {
            this.updateDescription();
        }
    }
}

