/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProviderFactory;
import org.eclipse.jpt.ui.navigator.JpaNavigatorProvider;

public class JpaNavigatorTreeItemContentProviderFactory
implements TreeItemContentProviderFactory {
    private Map<String, TreeItemContentProviderFactory> delegates = new HashMap<String, TreeItemContentProviderFactory>();

    public TreeItemContentProvider buildItemContentProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        TreeItemContentProviderFactory delegate = this.getDelegate(item);
        if (delegate != null) {
            return delegate.buildItemContentProvider(item, contentAndLabelProvider);
        }
        return null;
    }

    private TreeItemContentProviderFactory getDelegate(Object element) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        JpaContextNode contextNode = (JpaContextNode)((IAdaptable)element).getAdapter(JpaContextNode.class);
        if (contextNode == null) {
            return null;
        }
        JpaPlatform platform = contextNode.getJpaProject().getJpaPlatform();
        String platformId = platform.getId();
        if (this.delegates.containsKey(platformId)) {
            return this.delegates.get(platformId);
        }
        JpaNavigatorProvider navigatorProvider = JptUiPlugin.instance().getJpaNavigatorProvider(platform);
        TreeItemContentProviderFactory delegate = null;
        if (navigatorProvider != null) {
            delegate = navigatorProvider.getTreeItemContentProviderFactory();
        }
        this.delegates.put(platformId, delegate);
        return delegate;
    }
}

