/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.persistence.details;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.jface.ArchiveFileViewerFilter;
import org.eclipse.jpt.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.jpt.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ArchiveFileSelectionDialog
extends ElementTreeSelectionDialog {
    private final WritablePropertyValueModel<String> jarPathModel;
    private DeploymentPathCalculator pathCalculator;

    public ArchiveFileSelectionDialog(Shell parent) {
        this(parent, new SimpleDeploymentPathCalculator());
    }

    public ArchiveFileSelectionDialog(Shell parent, DeploymentPathCalculator pathCalculator) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.pathCalculator = pathCalculator;
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        this.addFilter(new ArchiveFileViewerFilter());
        this.setValidator(new ArchiveFileSelectionValidator());
        this.jarPathModel = new SimplePropertyValueModel();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label helpLabel = new Label(composite, 64);
        helpLabel.setText(JptUiPersistenceMessages.ArchiveFileSelectionDialog_jarPathHelpLabel);
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        helpLabel.setLayoutData((Object)gd);
        Composite subComposite = new Composite(composite, 0);
        subComposite.setLayout((Layout)new GridLayout(2, false));
        subComposite.setLayoutData((Object)new GridData(768));
        Label jarPathLabel = new Label(subComposite, 0);
        jarPathLabel.setFont(composite.getFont());
        jarPathLabel.setText(JptUiPersistenceMessages.ArchiveFileSelectionDialog_jarPathLabel);
        Text jarPathText = new Text(subComposite, 2048);
        jarPathText.setLayoutData((Object)new GridData(768));
        SWTTools.bind(this.jarPathModel, jarPathText);
        return composite;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer treeViewer = super.doCreateTreeViewer(parent, style);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArchiveFileSelectionDialog.this.updateJarPathModel(event.getSelection());
            }
        });
        return treeViewer;
    }

    protected void updateJarPathModel(ISelection selection) {
        Object selectedObj = ((IStructuredSelection)selection).getFirstElement();
        if (selectedObj instanceof IFile) {
            this.jarPathModel.setValue((Object)this.calculateDeployPath((IFile)selectedObj));
        } else {
            this.jarPathModel.setValue((Object)"");
        }
    }

    protected String calculateDeployPath(IFile archiveFile) {
        return this.pathCalculator.calculateDeploymentPath(archiveFile);
    }

    protected void computeResult() {
        this.setResult(Collections.singletonList((String)this.jarPathModel.getValue()));
    }

    private static class ArchiveFileSelectionValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected == 0 || nSelected > 1) {
                return new Status(4, "org.eclipse.jpt.ui", "");
            }
            int i = 0;
            while (i < selection.length) {
                Object curr = selection[i];
                if (curr instanceof IFile) {
                    return new Status(0, "org.eclipse.jpt.ui", "");
                }
                ++i;
            }
            return new Status(4, "org.eclipse.jpt.ui", "");
        }
    }

    public static interface DeploymentPathCalculator {
        public String calculateDeploymentPath(IFile var1);
    }

    public static class ModuleDeploymentPathCalculator
    extends SimpleDeploymentPathCalculator {
        public String calculateDeploymentPath(IFile file) {
            IVirtualFolder vFolder;
            IVirtualFile vFile;
            IVirtualComponent vComponent = ComponentCore.createComponent((IProject)file.getProject());
            if (vComponent != null && (vFile = this.findVirtualFile((IVirtualContainer)(vFolder = vComponent.getRootFolder()), file)) != null) {
                return this.calculatePersistenceRootRelativePath(vFile);
            }
            return super.calculateDeploymentPath(file);
        }

        protected IVirtualFile findVirtualFile(IVirtualContainer vContainer, IFile realFile) {
            try {
                IVirtualResource[] iVirtualResourceArray = vContainer.members();
                int n = iVirtualResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualFile vFile;
                    IVirtualResource vResource = iVirtualResourceArray[n2];
                    if (vResource.getType() == 16 ? realFile.equals((Object)(vFile = (IVirtualFile)vResource).getUnderlyingFile()) : (vFile = this.findVirtualFile((IVirtualContainer)vResource, realFile)) != null) {
                        return vFile;
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                JptUiPlugin.log(ce);
            }
            return null;
        }

        protected String calculatePersistenceRootRelativePath(IVirtualFile vFile) {
            IProject project = vFile.getProject();
            IPath puRootPath = JptCorePlugin.getJarDeploymentRootPath((IProject)project);
            IPath path = vFile.getRuntimePath().makeRelativeTo(puRootPath);
            return path.toString();
        }
    }

    public static class SimpleDeploymentPathCalculator
    implements DeploymentPathCalculator {
        public String calculateDeploymentPath(IFile file) {
            return file.getName();
        }
    }
}

