/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.utility.swt;

import java.util.Arrays;
import org.eclipse.jpt.ui.internal.utility.swt.BooleanButtonModelBinding;
import org.eclipse.jpt.ui.internal.utility.swt.BooleanStateController;
import org.eclipse.jpt.ui.internal.utility.swt.DropDownListBoxSelectionBinding;
import org.eclipse.jpt.ui.internal.utility.swt.ListBoxSelectionBinding;
import org.eclipse.jpt.ui.internal.utility.swt.ListWidgetModelBinding;
import org.eclipse.jpt.ui.internal.utility.swt.MultiControlBooleanStateController;
import org.eclipse.jpt.ui.internal.utility.swt.SWTComboAdapter;
import org.eclipse.jpt.ui.internal.utility.swt.SWTListAdapter;
import org.eclipse.jpt.ui.internal.utility.swt.SimpleBooleanStateController;
import org.eclipse.jpt.ui.internal.utility.swt.TextFieldModelBinding;
import org.eclipse.jpt.utility.internal.BitTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.WritablePropertyCollectionValueModelAdapter;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritableCollectionValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SWTTools {
    private static final BooleanStateController.Adapter ENABLED_ADAPTER = new BooleanStateController.Adapter(){

        public void setState(Control control, boolean b) {
            control.setEnabled(b);
        }
    };
    private static final BooleanStateController.Adapter VISIBLE_ADAPTER = new BooleanStateController.Adapter(){

        public void setState(Control control, boolean b) {
            control.setVisible(b);
        }
    };

    public static void bind(WritablePropertyValueModel<Boolean> booleanModel, Button button) {
        SWTTools.bind(booleanModel, button, false);
    }

    public static void bind(WritablePropertyValueModel<Boolean> booleanModel, Button button, boolean defaultValue) {
        new BooleanButtonModelBinding(booleanModel, button, defaultValue);
    }

    public static <E> void bind(WritablePropertyValueModel<String> textModel, Text textField) {
        new TextFieldModelBinding(textModel, textField);
    }

    public static <E> void bind(ListValueModel<E> listModel, List listBox) {
        SWTTools.bind(listModel, listBox, StringConverter.Default.instance());
    }

    public static <E> void bind(ListValueModel<E> listModel, List listBox, StringConverter<E> stringConverter) {
        SWTTools.bind(listModel, new SWTListAdapter(listBox), stringConverter);
    }

    public static <E> void bind(ListValueModel<E> listModel, WritablePropertyValueModel<E> selectedItemModel, List listBox) {
        SWTTools.bind(listModel, selectedItemModel, listBox, StringConverter.Default.instance());
    }

    public static <E> void bind(ListValueModel<E> listModel, WritablePropertyValueModel<E> selectedItemModel, List listBox, StringConverter<E> stringConverter) {
        SWTTools.checkForSingleSelectionStyle(listBox);
        SWTTools.bind(listModel, new WritablePropertyCollectionValueModelAdapter(selectedItemModel), listBox, stringConverter);
    }

    public static <E> void bind(ListValueModel<E> listModel, WritableCollectionValueModel<E> selectedItemsModel, List listBox) {
        SWTTools.bind(listModel, selectedItemsModel, listBox, StringConverter.Default.instance());
    }

    public static <E> void bind(ListValueModel<E> listModel, WritableCollectionValueModel<E> selectedItemsModel, List listBox, StringConverter<E> stringConverter) {
        SWTTools.bind(listModel, new SWTListAdapter(listBox), stringConverter, new ListBoxSelectionBinding<E>(listModel, selectedItemsModel, listBox));
    }

    private static void checkForSingleSelectionStyle(List listBox) {
        if (!BitTools.flagIsSet((int)listBox.getStyle(), (int)4)) {
            throw new IllegalStateException("list box must be single-selection: " + listBox);
        }
    }

    public static <E> void bind(ListValueModel<E> listModel, WritablePropertyValueModel<E> selectedItemModel, Combo dropDownListBox) {
        SWTTools.bind(listModel, selectedItemModel, dropDownListBox, StringConverter.Default.instance());
    }

    public static <E> void bind(ListValueModel<E> listModel, WritablePropertyValueModel<E> selectedItemModel, Combo dropDownListBox, StringConverter<E> stringConverter) {
        SWTTools.checkForReadOnlyStyle((Widget)dropDownListBox);
        SWTComboAdapter comboAdapter = new SWTComboAdapter(dropDownListBox);
        SWTTools.bind(listModel, comboAdapter, stringConverter, new DropDownListBoxSelectionBinding<E>(listModel, selectedItemModel, comboAdapter));
    }

    private static void checkForReadOnlyStyle(Widget comboBox) {
        if (!BitTools.flagIsSet((int)comboBox.getStyle(), (int)8)) {
            throw new IllegalStateException("combo-box must be read-only: " + comboBox);
        }
    }

    private static <E> void bind(ListValueModel<E> listModel, ListWidgetModelBinding.ListWidget listWidget, StringConverter<E> stringConverter) {
        SWTTools.bind(listModel, listWidget, stringConverter, ListWidgetModelBinding.SelectionBinding.Null.instance());
    }

    private static <E> void bind(ListValueModel<E> listModel, ListWidgetModelBinding.ListWidget listWidget, StringConverter<E> stringConverter, ListWidgetModelBinding.SelectionBinding selectionBinding) {
        new ListWidgetModelBinding<E>(listModel, listWidget, stringConverter, selectionBinding);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        SWTTools.controlEnabledState(booleanModel, controls, false);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Control[] controls, boolean defaultValue) {
        switch (controls.length) {
            case 0: {
                throw new IllegalArgumentException("empty controls array: " + Arrays.toString(controls));
            }
            case 1: {
                SWTTools.controlEnabledState(booleanModel, controls[0], defaultValue);
                break;
            }
            default: {
                SWTTools.controlEnabledState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel((Object[])controls), defaultValue);
            }
        }
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls) {
        SWTTools.controlEnabledState(booleanModel, controls, false);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls, boolean defaultValue) {
        SWTTools.controlEnabledState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel(controls), defaultValue);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel) {
        SWTTools.controlEnabledState(booleanModel, controlsModel, false);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel, boolean defaultValue) {
        SWTTools.control(booleanModel, controlsModel, defaultValue, ENABLED_ADAPTER);
    }

    public static void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue) {
        SWTTools.control(booleanModel, control, defaultValue, ENABLED_ADAPTER);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        SWTTools.controlVisibleState(booleanModel, controls, false);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Control[] controls, boolean defaultValue) {
        switch (controls.length) {
            case 0: {
                throw new IllegalArgumentException("empty controls array: " + Arrays.toString(controls));
            }
            case 1: {
                SWTTools.controlVisibleState(booleanModel, controls[0], defaultValue);
                break;
            }
            default: {
                SWTTools.controlVisibleState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel((Object[])controls), defaultValue);
            }
        }
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls) {
        SWTTools.controlVisibleState(booleanModel, controls, false);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Iterable<? extends Control> controls, boolean defaultValue) {
        SWTTools.controlVisibleState(booleanModel, (CollectionValueModel<? extends Control>)new StaticCollectionValueModel(controls), defaultValue);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel) {
        SWTTools.controlVisibleState(booleanModel, controlsModel, false);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel, boolean defaultValue) {
        SWTTools.control(booleanModel, controlsModel, defaultValue, VISIBLE_ADAPTER);
    }

    public static void controlVisibleState(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue) {
        SWTTools.control(booleanModel, control, defaultValue, VISIBLE_ADAPTER);
    }

    private static void control(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel, boolean defaultValue, BooleanStateController.Adapter adapter) {
        new MultiControlBooleanStateController(booleanModel, controlsModel, defaultValue, adapter);
    }

    private static void control(PropertyValueModel<Boolean> booleanModel, Control control, boolean defaultValue, BooleanStateController.Adapter adapter) {
        new SimpleBooleanStateController(booleanModel, control, defaultValue, adapter);
    }

    private SWTTools() {
        throw new UnsupportedOperationException();
    }
}

