/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.util.Comparator;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.MirrorImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ScriptReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;

public class LocationImpl
extends MirrorImpl
implements Location {
    private static LocationComparator comparator = new LocationComparator();
    private String functionName;
    private int lineNumber;
    private ScriptReferenceImpl scriptReference;

    public LocationImpl(VirtualMachineImpl vm, String functionName, int lineNumber, ScriptReferenceImpl scriptReference) {
        super(vm);
        this.functionName = functionName;
        this.lineNumber = lineNumber;
        this.scriptReference = scriptReference;
    }

    static LocationComparator getLocationComparator() {
        return comparator;
    }

    public String functionName() {
        return this.functionName;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public ScriptReference scriptReference() {
        return this.scriptReference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("LocationImpl: ");
        buffer.append("[script - ").append(this.scriptReference.sourceURI()).append("] ");
        buffer.append("[function - ").append(this.functionName).append("] ");
        buffer.append("[line - ").append(this.lineNumber).append("]");
        return buffer.toString();
    }

    static class LocationComparator
    implements Comparator {
        LocationComparator() {
        }

        public int compare(Object o1, Object o2) {
            int value = -1;
            if (o1 instanceof Location && o2 instanceof Location) {
                int second;
                int first = ((Location)o1).lineNumber();
                if (first == (second = ((Location)o2).lineNumber())) {
                    value = 0;
                } else if (first > second) {
                    value = 1;
                }
            }
            return value;
        }
    }
}

