/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.db.ConnectionAdapter;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.ImageRepository;
import org.eclipse.jpt.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseGroup {
    private final JpaProject jpaProject;
    private final Set<Listener> listeners = Collections.synchronizedSet(new HashSet());
    ConnectionProfile selectedConnectionProfile;
    private Schema selectedSchema;
    private final Combo connectionComboBox;
    private final Combo schemaComboBox;
    private final Button reconnectButton;
    private final ConnectionListener connectionListener;
    private IWizardContainer wizardContainer;
    protected final ResourceManager resourceManager;

    DatabaseGroup(IWizardContainer wizardContainer, JpaProject jpaProject, Composite parent, ResourceManager resourceManager, int widthHint) {
        this.wizardContainer = wizardContainer;
        this.jpaProject = jpaProject;
        this.resourceManager = resourceManager;
        this.buildLabel(parent, 1, JptUiEntityGenMessages.connection);
        this.connectionComboBox = this.buildComboBox(parent, widthHint, this.buildConnectionComboBoxSelectionListener());
        Button addConnectionButton = this.buildButton(parent, JptUiEntityGenMessages.addConnectionLink, ImageRepository.getAddConnectionButtonImage(this.resourceManager), this.buildAddConnectionLinkSelectionListener());
        GridData data = new GridData();
        addConnectionButton.setLayoutData((Object)data);
        this.buildLabel(parent, 1, "");
        Composite comp = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = -5;
        comp.setLayout((Layout)gl);
        this.reconnectButton = this.buildButton(comp, JptUiEntityGenMessages.connectLink, ImageRepository.getReconnectButtonImage(this.resourceManager), this.buildReconnectLinkSelectionListener());
        this.buildLabel(comp, 1, JptUiEntityGenMessages.schemaInfo);
        this.buildLabel(parent, 1, JptUiEntityGenMessages.schema);
        this.schemaComboBox = new Combo(parent, 2056);
        data = new GridData(1, 0x1000000, true, false);
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.schemaComboBox.setLayoutData((Object)data);
        this.schemaComboBox.addSelectionListener(this.buildSchemaComboBoxSelectionListener());
        new Label(parent, 0);
        this.connectionListener = this.buildConnectionListener();
    }

    public void init() {
        this.selectedConnectionProfile = this.getJpaProjectConnectionProfile();
        this.selectedSchema = this.getDefaultSchema();
        if (this.selectedSchema != null) {
            this.fireSchemaChanged(this.selectedSchema);
        }
        if (this.selectedConnectionProfile != null) {
            this.selectedConnectionProfile.addConnectionListener(this.connectionListener);
            this.fireConnectionProfileChanged(this.selectedConnectionProfile);
        }
        this.updateConnectionComboBox();
        this.updateSchemaComboBox();
        this.updateReconnectLink();
    }

    Schema getSelectedSchema() {
        return this.selectedSchema;
    }

    void dispose() {
        if (this.selectedConnectionProfile != null) {
            this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
        }
    }

    private ConnectionProfile getJpaProjectConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    private Schema getDefaultSchema() {
        return this.selectedConnectionProfile == this.getJpaProjectConnectionProfile() ? this.jpaProject.getDefaultDbSchema() : null;
    }

    private void updateConnectionComboBox() {
        this.connectionComboBox.removeAll();
        for (String cpName : this.buildSortedConnectionProfileNames()) {
            this.connectionComboBox.add(cpName);
        }
        if (this.selectedConnectionProfile != null) {
            this.connectionComboBox.select(this.connectionComboBox.indexOf(this.selectedConnectionProfile.getName()));
        }
    }

    private SortedSet<String> buildSortedConnectionProfileNames() {
        return CollectionTools.sortedSet((Iterable)JptDbPlugin.instance().getConnectionProfileFactory().getConnectionProfileNames());
    }

    private void updateReconnectLink() {
        this.reconnectButton.setEnabled(this.reconnectLinkCanBeEnabled());
    }

    private boolean reconnectLinkCanBeEnabled() {
        return this.selectedConnectionProfile != null && !this.selectedConnectionProfile.isActive();
    }

    private void updateSchemaComboBox() {
        this.schemaComboBox.removeAll();
        for (String name : this.getSchemaNames()) {
            this.schemaComboBox.add(name);
        }
        if (this.selectedSchema != null) {
            this.schemaComboBox.select(this.schemaComboBox.indexOf(this.selectedSchema.getName()));
        }
    }

    private Iterable<String> getSchemaNames() {
        SchemaContainer sc = this.jpaProject.getDefaultDbSchemaContainer();
        return sc != null ? sc.getSortedSchemaNames() : EmptyIterable.instance();
    }

    private ConnectionProfile checkJpaProjectConnectionProfile(String cpName) {
        ConnectionProfile cp = this.getJpaProjectConnectionProfile();
        if (cp != null && cp.getName().equals(cpName)) {
            return cp;
        }
        return this.buildConnectionProfile(cpName);
    }

    private ConnectionProfile buildConnectionProfile(String name) {
        return JptDbPlugin.instance().getConnectionProfileFactory().buildConnectionProfile(name);
    }

    void selectedConnectionChanged() {
        String text = this.connectionComboBox.getText();
        if (text.length() == 0) {
            if (this.selectedConnectionProfile == null) {
                return;
            }
            this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
            this.selectedConnectionProfile = null;
        } else {
            if (this.selectedConnectionProfile == null) {
                this.selectedConnectionProfile = this.checkJpaProjectConnectionProfile(text);
            } else {
                if (text.equals(this.selectedConnectionProfile.getName())) {
                    return;
                }
                this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
                this.selectedConnectionProfile = this.checkJpaProjectConnectionProfile(text);
            }
            this.selectedConnectionProfile.addConnectionListener(this.connectionListener);
        }
        this.fireConnectionProfileChanged(this.selectedConnectionProfile);
        this.connectionChanged();
    }

    void selectedSchemaChanged() {
        Schema old = this.selectedSchema;
        this.selectedSchema = this.jpaProject.getDefaultDbSchemaContainer().getSchemaNamed(this.schemaComboBox.getText());
        if (this.selectedSchema != old) {
            this.fireSchemaChanged(this.selectedSchema);
        }
    }

    void addConnection() {
        String addedProfileName = DTPUiTools.createNewConnectionProfile();
        if (addedProfileName == null) {
            return;
        }
        if (this.selectedConnectionProfile != null) {
            this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
        }
        this.selectedConnectionProfile = this.buildConnectionProfile(addedProfileName);
        this.selectedConnectionProfile.addConnectionListener(this.connectionListener);
        this.updateConnectionComboBox();
        this.selectedConnectionProfile.connect();
        this.fireConnectionProfileChanged(this.selectedConnectionProfile);
        this.updateSchemaComboBox();
    }

    void reconnect() {
        try {
            this.wizardContainer.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(JptUiEntityGenMessages.connectingToDatabase, 10);
                    final SynchronizedBoolean finished = new SynchronizedBoolean(false);
                    Thread t = new Thread(){

                        public void run() {
                            try {
                                try {
                                    (this).DatabaseGroup.this.selectedConnectionProfile.connect();
                                }
                                catch (Exception ex) {
                                    JptUiPlugin.log(ex);
                                    finished.setTrue();
                                }
                            }
                            finally {
                                finished.setTrue();
                            }
                        }
                    };
                    t.start();
                    while (finished.isFalse()) {
                        Thread.sleep(1000L);
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            JptUiPlugin.log(e);
        }
        this.wizardContainer.updateButtons();
    }

    void connectionChanged() {
        Schema old = this.selectedSchema;
        this.selectedSchema = this.getDefaultSchema();
        if (this.selectedSchema != old) {
            this.fireSchemaChanged(this.selectedSchema);
        }
        this.updateSchemaComboBox();
        this.updateReconnectLink();
    }

    private SelectionListener buildConnectionComboBoxSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                DatabaseGroup.this.selectedConnectionChanged();
            }

            public String toString() {
                return "DatabaseConnectionWizardPage connection combo-box selection listener";
            }
        };
    }

    private SelectionListener buildSchemaComboBoxSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                DatabaseGroup.this.selectedSchemaChanged();
            }

            public String toString() {
                return "DatabaseConnectionWizardPage schema combo-box selection listener";
            }
        };
    }

    private SelectionListener buildAddConnectionLinkSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DatabaseGroup.this.addConnection();
            }

            public String toString() {
                return "DatabaseConnectionWizardPage add connection link selection listener";
            }
        };
    }

    private SelectionListener buildReconnectLinkSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DatabaseGroup.this.reconnect();
            }

            public String toString() {
                return "DatabaseConnectionWizardPage reconnect link selection listener";
            }
        };
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionAdapter(){

            public void opened(ConnectionProfile cp) {
                this.connectionChanged();
            }

            public void closed(ConnectionProfile cp) {
                this.connectionChanged();
            }

            private void connectionChanged() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        DatabaseGroup.this.connectionChanged();
                    }
                });
            }

            public String toString() {
                return "DatabaseConnectionWizardPage connection listener";
            }
        };
    }

    public void addListener(Listener listener) {
        if (!this.listeners.add(listener)) {
            throw new IllegalArgumentException("duplicate listener: " + listener);
        }
    }

    public void removeListener(Listener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("missing listener: " + listener);
        }
    }

    private Iterator<Listener> listeners() {
        return new CloneIterator(this.listeners);
    }

    void fireConnectionProfileChanged(ConnectionProfile connectionProfile) {
        Iterator<Listener> stream = this.listeners();
        while (stream.hasNext()) {
            stream.next().selectedConnectionProfileChanged(connectionProfile);
        }
    }

    void fireSchemaChanged(Schema schema) {
        Iterator<Listener> stream = this.listeners();
        while (stream.hasNext()) {
            stream.next().selectedSchemaChanged(schema);
        }
    }

    private Label buildLabel(Composite parent, int span, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Combo buildComboBox(Composite parent, int widthHint, SelectionListener listener) {
        Combo combo = new Combo(parent, 2056);
        combo.addSelectionListener(listener);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = widthHint;
        combo.setLayoutData((Object)data);
        return combo;
    }

    private Button buildButton(Composite parent, String toolTipText, Image image, SelectionListener listener) {
        Button button = new Button(parent, 0);
        GridData data = new GridData(3, 2, false, false);
        data.horizontalSpan = 1;
        button.setLayoutData((Object)data);
        button.setImage(image);
        button.setToolTipText(toolTipText);
        button.addSelectionListener(listener);
        return button;
    }

    public static interface Listener
    extends EventListener {
        public void selectedConnectionProfileChanged(ConnectionProfile var1);

        public void selectedSchemaChanged(Schema var1);
    }
}

