/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.BreakpointLocationFinder;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class JavaScriptBreakpointUpdater
implements IMarkerUpdater {
    public String getMarkerType() {
        return "org.eclipse.wst.jsdt.debug.core.breakpoint.marker";
    }

    public String[] getAttribute() {
        return new String[]{"lineNumber"};
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        int line;
        block15: {
            IBreakpoint breakpoint;
            block14: {
                block13: {
                    BreakpointLocationFinder finder;
                    block12: {
                        if (position.isDeleted()) {
                            return false;
                        }
                        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                        breakpoint = manager.getBreakpoint(marker);
                        if (breakpoint == null) {
                            return false;
                        }
                        IJavaScriptUnit unit = JavaScriptCore.createCompilationUnitFrom((IFile)((IFile)marker.getResource()));
                        if (unit == null) {
                            return false;
                        }
                        JavaScriptUnit jsunit = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)unit, ASTProvider.WAIT_YES, null);
                        finder = new BreakpointLocationFinder(jsunit, document.getLineOfOffset(position.getOffset()) + 1, true);
                        jsunit.accept((ASTVisitor)finder);
                        if (finder.getLocation() != -1) break block12;
                        return false;
                    }
                    line = finder.getLineNumber();
                    if (MarkerUtilities.getLineNumber((IMarker)marker) != line) break block13;
                    if (this.isLineBreakpoint(marker)) {
                        this.ensureRanges(document, marker, line);
                        return this.lineBreakpointExists(marker.getResource(), ((IJavaScriptLineBreakpoint)breakpoint).getScriptPath(), line, marker, true) == null;
                    }
                    return true;
                }
                if (!(this.isLineBreakpoint(marker) & line == -1)) break block14;
                return false;
            }
            if (this.lineBreakpointExists(marker.getResource(), ((IJavaScriptLineBreakpoint)breakpoint).getScriptPath(), line, marker, false) == null) break block15;
            return false;
        }
        try {
            MarkerUtilities.setLineNumber((IMarker)marker, (int)line);
            if (this.isLineBreakpoint(marker)) {
                this.ensureRanges(document, marker, line);
            }
            return true;
        }
        catch (BadLocationException ble) {
            JavaScriptDebugUIPlugin.log(ble);
        }
        catch (CoreException e) {
            JavaScriptDebugUIPlugin.log(e);
        }
        return false;
    }

    boolean isLineBreakpoint(IMarker marker) {
        return MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.wst.jsdt.debug.core.line.breakpoint.marker");
    }

    void ensureRanges(IDocument document, IMarker marker, int line) throws BadLocationException {
        if (line < 0 || line > document.getNumberOfLines()) {
            return;
        }
        IRegion region = document.getLineInformation(line - 1);
        int charstart = region.getOffset();
        int charend = charstart + region.getLength();
        MarkerUtilities.setCharStart((IMarker)marker, (int)charstart);
        MarkerUtilities.setCharEnd((IMarker)marker, (int)charend);
    }

    IJavaScriptLineBreakpoint lineBreakpointExists(IResource resource, String typeName, int lineNumber, IMarker currentmarker, boolean useid) throws CoreException {
        String modelId = "org.eclipse.wst.jsdt.debug.model";
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            IMarker marker;
            IJavaScriptLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof IJavaScriptLineBreakpoint && (breakpoint = (IJavaScriptLineBreakpoint)breakpoints[i]).getLineNumber() == lineNumber && (marker = breakpoint.getMarker()) != null && marker.exists() && marker.getType().equals("org.eclipse.wst.jsdt.debug.core.line.breakpoint.marker") && this.pathsEqual(breakpoint.getScriptPath(), typeName) && resource.equals((Object)marker.getResource())) {
                if (useid) {
                    if (currentmarker.getId() != marker.getId()) {
                        return breakpoint;
                    }
                    return null;
                }
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    boolean pathsEqual(String n1, String n2) {
        if (n1 == null) {
            return n2 == null;
        }
        return n1.equals(n2);
    }
}

