/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.IdClassReference;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.context.PrimaryKeyTextRangeResolver;
import org.eclipse.jpt.core.internal.context.PrimaryKeyValidator;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPrimaryKeyValidator
implements PrimaryKeyValidator {
    private TypeMapping typeMapping;
    private PrimaryKeyTextRangeResolver textRangeResolver;

    protected AbstractPrimaryKeyValidator(TypeMapping typeMapping, PrimaryKeyTextRangeResolver textRangeResolver) {
        this.typeMapping = typeMapping;
        this.textRangeResolver = textRangeResolver;
    }

    protected TypeMapping typeMapping() {
        return this.typeMapping;
    }

    protected abstract IdClassReference idClassReference();

    protected PrimaryKeyTextRangeResolver textRangeResolver() {
        return this.textRangeResolver;
    }

    protected void validatePrimaryKeyIsNotRedefined(List<IMessage> messages, IReporter reporter) {
        if (this.definesPrimaryKeyOnAncestor(this.typeMapping())) {
            if (this.idClassReference().isSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_PK_REDEFINED_ID_CLASS", new String[0], this.typeMapping(), this.textRangeResolver().getIdClassTextRange()));
            }
            for (AttributeMapping each : this.getPrimaryKeyMappingsDefinedLocally(this.typeMapping())) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_PK_REDEFINED_ID_ATTRIBUTE", new String[0], each, this.textRangeResolver().getAttributeMappingTextRange(each.getName())));
            }
            return;
        }
    }

    protected void validateIdClassIsUsedIfNecessary(List<IMessage> messages, IReporter reporter) {
        if (!this.specifiesIdClass() && this.idClassIsRequired()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_REQUIRED", new String[0], this.typeMapping(), this.textRangeResolver().getTypeMappingTextRange()));
        }
    }

    protected void validateOneOfIdClassOrEmbeddedIdIsUsed(List<IMessage> messages, IReporter reporter) {
        if (this.idClassReference().isSpecified() && CollectionTools.size(this.typeMapping().getAllAttributeMappings("embeddedId")) > 0) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_AND_EMBEDDED_ID_BOTH_USED", new String[0], this.typeMapping(), this.textRangeResolver().getTypeMappingTextRange()));
        }
    }

    protected void validateOneEmbeddedId(List<IMessage> messages, IReporter reporter) {
        if (CollectionTools.size(this.getEmbeddedIdMappings(this.typeMapping())) > 1) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_MULTIPLE_EMBEDDED_ID", new String[0], this.typeMapping(), this.textRangeResolver().getTypeMappingTextRange()));
        }
    }

    protected void validateMapsIdMappings(List<IMessage> messages, IReporter reporter) {
        for (SingleRelationshipMapping2_0 mapsIdRelationshipMapping : this.getMapsIdMappingsDefinedLocally(this.typeMapping())) {
            AttributeMapping resolvedAttributeMapping;
            if (this.definesIdClass(this.typeMapping())) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_WITH_MAPS_ID", new String[]{mapsIdRelationshipMapping.getName()}, mapsIdRelationshipMapping, this.textRangeResolver().getAttributeMappingTextRange(mapsIdRelationshipMapping.getName())));
            }
            if ((resolvedAttributeMapping = mapsIdRelationshipMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getResolvedAttributeMappingValue()) == null || ClassName.areAutoboxEquivalents((String)resolvedAttributeMapping.getPersistentAttribute().getTypeName(), (String)this.getTargetEntityPrimaryKeyTypeName(mapsIdRelationshipMapping))) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_MAPS_ID_ATTRIBUTE_TYPE_DOES_NOT_AGREE", new String[]{mapsIdRelationshipMapping.getName()}, mapsIdRelationshipMapping, this.textRangeResolver().getAttributeMappingTextRange(mapsIdRelationshipMapping.getName())));
        }
    }

    protected void validateIdClass(JavaPersistentType idClass, List<IMessage> messages, IReporter reporter) {
        if (idClass == null) {
            return;
        }
        if (this.hasDerivedIdMappingMatchingIdClass(idClass)) {
            this.validateIdClass_derivedIdMappingMatchingIdClass(idClass, messages, reporter);
            return;
        }
        for (JavaPersistentAttribute idClassAttribute : new SubIterableWrapper(CollectionTools.iterable(idClass.allAttributes()))) {
            boolean foundMatch = false;
            for (AttributeMapping attributeMapping : this.getAttributeMappings(this.typeMapping())) {
                if (!idClassAttribute.getName().equals(attributeMapping.getName())) continue;
                foundMatch = true;
                if (!this.definesPrimaryKey(attributeMapping)) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NOT_PRIMARY_KEY", new String[]{idClassAttribute.getName()}, this.typeMapping(), this.textRangeResolver().getIdClassTextRange()));
                }
                String idClassAttributeTypeName = idClassAttribute.getTypeName();
                String attributeMappingTypeName = this.getTypeNameForIdClass(attributeMapping);
                if (attributeMappingTypeName == null || ClassName.areAutoboxEquivalents((String)idClassAttributeTypeName, (String)attributeMappingTypeName)) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_TYPE_DOES_NOT_AGREE", new String[]{idClassAttribute.getName(), idClassAttributeTypeName}, this.typeMapping(), this.textRangeResolver().getIdClassTextRange()));
            }
            if (foundMatch) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NO_MATCH", new String[]{idClassAttribute.getName()}, this.typeMapping(), this.textRangeResolver().getIdClassTextRange()));
        }
    }

    protected void validateIdClass_derivedIdMappingMatchingIdClass(JavaPersistentType idClass, List<IMessage> messages, IReporter reporter) {
        HashBag errorMappings = new HashBag();
        for (AttributeMapping each : new CompositeIterable(new Iterable[]{this.getIdMappings(this.typeMapping()), this.getEmbeddedIdMappings(this.typeMapping())})) {
            errorMappings.add(each);
        }
        HashBag errorDerivedIdMappings = new HashBag();
        for (AttributeMapping each : this.getDerivedIdMappings(this.typeMapping())) {
            if (idClass.getName().equals(this.getTargetEntityPrimaryKeyTypeName((SingleRelationshipMapping2_0)each))) {
                errorDerivedIdMappings.add(each);
                continue;
            }
            errorMappings.add(each);
        }
        for (AttributeMapping each : errorMappings) {
            this.addNoIdClassAttributeMatchError(each, messages);
        }
        if (CollectionTools.size((Iterable)errorDerivedIdMappings) > 1) {
            for (AttributeMapping each : errorDerivedIdMappings) {
                this.addDuplicateIdClassAttributeMatchError(each, messages);
            }
        }
    }

    protected void addNoIdClassAttributeMatchError(AttributeMapping attributeMapping, List<IMessage> messages) {
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_NO_MATCH", new String[]{attributeMapping.getName()}, this.typeMapping(), this.textRangeResolver().getIdClassTextRange()));
    }

    protected void addDuplicateIdClassAttributeMatchError(AttributeMapping attributeMapping, List<IMessage> messages) {
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_DUPLICATE_MATCH", new String[]{attributeMapping.getName()}, this.typeMapping(), this.textRangeResolver().getIdClassTextRange()));
    }

    protected boolean definesPrimaryKeyOnAncestor(TypeMapping typeMapping) {
        for (TypeMapping each : CollectionTools.iterable(typeMapping.inheritanceHierarchy())) {
            if (each == typeMapping || !this.definesPrimaryKey(each)) continue;
            return true;
        }
        return false;
    }

    protected boolean definesPrimaryKey(TypeMapping typeMapping) {
        return this.getIdClass(typeMapping) != null || !CollectionTools.isEmpty(this.getPrimaryKeyMappings(typeMapping));
    }

    protected boolean definesComplexPrimaryKey(TypeMapping typeMapping) {
        return this.definesIdClass(typeMapping) || this.getEmbeddedIdMapping(typeMapping) != null;
    }

    protected String getPrimaryKeyTypeName(TypeMapping typeMapping) {
        JavaPersistentType idClass = this.getIdClass(typeMapping);
        if (idClass != null) {
            return idClass.getName();
        }
        EmbeddedIdMapping embeddedId = this.getEmbeddedIdMapping(typeMapping);
        if (embeddedId != null) {
            return embeddedId.getPersistentAttribute().getTypeName();
        }
        IdMapping id = this.getIdMapping(typeMapping);
        if (id != null) {
            return id.getPersistentAttribute().getTypeName();
        }
        return null;
    }

    protected boolean definesPrimaryKey(AttributeMapping attributeMapping) {
        String mappingKey = attributeMapping.getKey();
        if (StringTools.stringsAreEqual((String)mappingKey, (String)"id") || StringTools.stringsAreEqual((String)mappingKey, (String)"embedded")) {
            return true;
        }
        if (StringTools.stringsAreEqual((String)mappingKey, (String)"manyToOne") || StringTools.stringsAreEqual((String)mappingKey, (String)"oneToOne")) {
            SingleRelationshipMapping2_0 relationshipMapping = (SingleRelationshipMapping2_0)attributeMapping;
            return relationshipMapping.getDerivedIdentity().usesIdDerivedIdentityStrategy() || relationshipMapping.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
        }
        return false;
    }

    protected boolean specifiesIdClass() {
        return this.idClassReference().isSpecified();
    }

    protected boolean definesIdClass(TypeMapping typeMapping) {
        return this.getIdClass(typeMapping) != null;
    }

    protected boolean definesIdClassOnAncestor(TypeMapping typeMapping) {
        for (TypeMapping each : CollectionTools.iterable(typeMapping.inheritanceHierarchy())) {
            if (each == typeMapping || !this.definesIdClass(each)) continue;
            return true;
        }
        return false;
    }

    protected JavaPersistentType getIdClass(TypeMapping typeMapping) {
        Iterator<TypeMapping> stream = typeMapping.inheritanceHierarchy();
        while (stream.hasNext()) {
            TypeMapping next = stream.next();
            if (next.getIdClass() == null) continue;
            return next.getIdClass();
        }
        return null;
    }

    protected Iterable<AttributeMapping> getAttributeMappings(TypeMapping typeMapping) {
        return CollectionTools.collection(typeMapping.allAttributeMappings());
    }

    protected Iterable<AttributeMapping> getPrimaryKeyMappings(TypeMapping typeMapping) {
        return new CompositeIterable(new Iterable[]{this.getIdMappings(typeMapping), this.getEmbeddedIdMappings(typeMapping), this.getDerivedIdMappings(typeMapping), this.getMapsIdMappings(typeMapping)});
    }

    protected Iterable<AttributeMapping> getPrimaryKeyMappingsDefinedLocally(TypeMapping typeMapping) {
        return new CompositeIterable(new Iterable[]{this.getIdMappingsDefinedLocally(typeMapping), this.getEmbeddedIdMappingsDefinedLocally(typeMapping), this.getDerivedIdMappingsDefinedLocally(typeMapping), this.getMapsIdMappingsDefinedLocally(typeMapping)});
    }

    protected boolean hasAnyPrimaryKeyMappings(TypeMapping typeMapping) {
        return !CollectionTools.isEmpty(this.getPrimaryKeyMappings(typeMapping));
    }

    protected IdMapping getIdMapping(TypeMapping typeMapping) {
        Iterable<IdMapping> idMappings = this.getIdMappings(typeMapping);
        if (CollectionTools.size(idMappings) == 1) {
            return idMappings.iterator().next();
        }
        return null;
    }

    protected Iterable<IdMapping> getIdMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAllAttributeMappings("id"));
    }

    protected Iterable<IdMapping> getIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAttributeMappings("id"));
    }

    protected boolean definesEmbeddedIdMapping(TypeMapping typeMapping) {
        return !CollectionTools.isEmpty(this.getEmbeddedIdMappings(typeMapping));
    }

    protected EmbeddedIdMapping getEmbeddedIdMapping(TypeMapping typeMapping) {
        Iterable<EmbeddedIdMapping> embeddedIdMappings = this.getEmbeddedIdMappings(typeMapping);
        if (CollectionTools.size(embeddedIdMappings) == 1) {
            return embeddedIdMappings.iterator().next();
        }
        return null;
    }

    protected Iterable<EmbeddedIdMapping> getEmbeddedIdMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAllAttributeMappings("embeddedId"));
    }

    protected Iterable<EmbeddedIdMapping> getEmbeddedIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return new SubIterableWrapper(typeMapping.getAttributeMappings("embeddedId"));
    }

    protected Iterable<SingleRelationshipMapping2_0> getDerivedIdMappings(TypeMapping typeMapping) {
        return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{typeMapping.getAllAttributeMappings("oneToOne"), typeMapping.getAllAttributeMappings("manyToOne")}))){

            protected boolean accept(SingleRelationshipMapping2_0 o) {
                return o.getDerivedIdentity().usesIdDerivedIdentityStrategy();
            }
        };
    }

    protected Iterable<SingleRelationshipMapping2_0> getDerivedIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{typeMapping.getAttributeMappings("oneToOne"), typeMapping.getAttributeMappings("manyToOne")}))){

            protected boolean accept(SingleRelationshipMapping2_0 o) {
                return o.getDerivedIdentity().usesIdDerivedIdentityStrategy();
            }
        };
    }

    protected Iterable<SingleRelationshipMapping2_0> getMapsIdMappings(TypeMapping typeMapping) {
        return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{typeMapping.getAllAttributeMappings("oneToOne"), typeMapping.getAllAttributeMappings("manyToOne")}))){

            protected boolean accept(SingleRelationshipMapping2_0 o) {
                return o.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
            }
        };
    }

    protected Iterable<SingleRelationshipMapping2_0> getMapsIdMappingsDefinedLocally(TypeMapping typeMapping) {
        return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{typeMapping.getAttributeMappings("oneToOne"), typeMapping.getAttributeMappings("manyToOne")}))){

            protected boolean accept(SingleRelationshipMapping2_0 o) {
                return o.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
            }
        };
    }

    protected boolean idClassIsRequired() {
        int simplePrimaryKeyMappingCount = CollectionTools.size(this.getIdMappings(this.typeMapping()));
        if (simplePrimaryKeyMappingCount > 1) {
            return true;
        }
        for (SingleRelationshipMapping2_0 relationshipMapping : this.getDerivedIdMappings(this.typeMapping())) {
            Entity entity = relationshipMapping.getResolvedTargetEntity();
            if (entity == null) continue;
            if (this.definesComplexPrimaryKey(entity)) {
                return true;
            }
            if (++simplePrimaryKeyMappingCount <= 1) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDerivedIdMappingMatchingIdClass(JavaPersistentType idClass) {
        for (SingleRelationshipMapping2_0 each : this.getDerivedIdMappings(this.typeMapping())) {
            String primaryKeyTypeName = this.getTargetEntityPrimaryKeyTypeName(each);
            if (!idClass.getName().equals(primaryKeyTypeName)) continue;
            return true;
        }
        return false;
    }

    protected String getTargetEntityPrimaryKeyTypeName(SingleRelationshipMapping2_0 relationshipMapping) {
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity != null) {
            return this.getPrimaryKeyTypeName(targetEntity);
        }
        return null;
    }

    protected String getTypeNameForIdClass(AttributeMapping attributeMapping) {
        SingleRelationshipMapping2_0 relationshipMapping;
        Entity targetEntity;
        if (StringTools.stringsAreEqual((String)attributeMapping.getKey(), (String)"id") || StringTools.stringsAreEqual((String)attributeMapping.getKey(), (String)"embeddedId")) {
            return attributeMapping.getPersistentAttribute().getTypeName();
        }
        if ((StringTools.stringsAreEqual((String)attributeMapping.getKey(), (String)"manyToOne") || StringTools.stringsAreEqual((String)attributeMapping.getKey(), (String)"oneToOne")) && (targetEntity = (relationshipMapping = (SingleRelationshipMapping2_0)attributeMapping).getResolvedTargetEntity()) != null) {
            return this.getPrimaryKeyTypeName(targetEntity);
        }
        return null;
    }
}

