/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalCategory;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalComputerRegistry;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.osgi.framework.Bundle;

final class CompletionProposalComputerDescriptor {
    private static final String DEFAULT_CATEGORY_ID = "org.eclipse.wst.sse.ui.defaultProposalCategory";
    private static final String ATTR_CATEGORY_ID = "categoryId";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private static final String ATTRACTIVATE = "activate";
    private static final String ELEM_CONTENT_TYPE = "contentType";
    private static final String ELEM_PARTITION_TYPE = "partitionType";
    private static final String PERFORMANCE_EVENT = "org.eclipse.wst.sse.ui/perf/content_assist/extensions";
    private static final boolean MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)"org.eclipse.wst.sse.ui/perf/content_assist/extensions");
    private static final long MAX_DELAY = 500000L;
    private static final String COMPUTE_COMPLETION_PROPOSALS = "computeCompletionProposals()";
    private static final String COMPUTE_CONTEXT_INFORMATION = "computeContextInformation()";
    private static final String SESSION_STARTED = "sessionStarted()";
    private static final String SESSION_ENDED = "sessionEnded()";
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final IConfigurationElement fElement;
    private ICompletionProposalComputer fComputer;
    private final CompletionProposalCategory fCategory;
    private String fLastError;
    private boolean fIsReportingDelay = false;
    private long fStart;
    boolean fTriedLoadingComputer = false;

    CompletionProposalComputerDescriptor(IConfigurationElement element, List categories) throws InvalidRegistryObjectException, CoreException {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fElement = element;
        this.fId = this.fElement.getAttribute(ATTR_ID);
        ContentAssistUtils.checkExtensionAttributeNotNull(this.fId, ATTR_ID, this.fElement);
        String name = this.fElement.getAttribute(ATTR_NAME);
        this.fName = name == null ? this.fId : name;
        String activateAttribute = this.fElement.getAttribute(ATTRACTIVATE);
        this.fActivate = Boolean.valueOf(activateAttribute);
        this.fClass = this.fElement.getAttribute(ATTR_CLASS);
        ContentAssistUtils.checkExtensionAttributeNotNull(this.fClass, ATTR_CLASS, this.fElement);
        String categoryId = this.fElement.getAttribute(ATTR_CATEGORY_ID);
        if (categoryId == null) {
            categoryId = DEFAULT_CATEGORY_ID;
        }
        CompletionProposalCategory category = null;
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            if (!cat.getId().equals(categoryId)) continue;
            category = cat;
            break;
        }
        if (category == null) {
            this.fCategory = new CompletionProposalCategory(categoryId, this.fName);
            categories.add(this.fCategory);
        } else {
            this.fCategory = category;
        }
    }

    void addToRegistry() throws InvalidRegistryObjectException, CoreException {
        CompletionProposalComputerDescriptor.parseActivationAndAddToRegistry(this.fElement, this);
    }

    CompletionProposalCategory getCategory() {
        return this.fCategory;
    }

    IContributor getContributor() {
        try {
            return this.fElement.getContributor();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public ICompletionProposalComputer createComputer() throws CoreException, InvalidRegistryObjectException {
        return (ICompletionProposalComputer)this.fElement.createExecutableExtension(ATTR_CLASS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        List completionProposals = Collections.EMPTY_LIST;
        if (this.isEnabled()) {
            IStatus status = null;
            try {
                try {
                    ICompletionProposalComputer computer = this.getComputer(true);
                    if (computer != null) {
                        try {
                            PerformanceStats stats = this.startMeter(context, computer);
                            List proposals = computer.computeCompletionProposals(context, monitor);
                            this.stopMeter(stats, COMPUTE_COMPLETION_PROPOSALS);
                            if (proposals != null) {
                                this.fLastError = computer.getErrorMessage();
                                completionProposals = proposals;
                            } else {
                                status = this.createAPIViolationStatus(COMPUTE_COMPLETION_PROPOSALS);
                            }
                            Object var8_13 = null;
                            this.fIsReportingDelay = true;
                        }
                        catch (Throwable throwable) {
                            Object var8_12 = null;
                            this.fIsReportingDelay = true;
                            throw throwable;
                        }
                    }
                }
                catch (InvalidRegistryObjectException x) {
                    status = this.createExceptionStatus(x);
                }
                catch (CoreException x) {
                    status = this.createExceptionStatus(x);
                }
                catch (RuntimeException x) {
                    status = this.createExceptionStatus(x);
                }
                Object var10_16 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            if (status != null) {
                Logger.log(status);
            }
        }
        return completionProposals;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        List contextInformation = Collections.EMPTY_LIST;
        if (this.isEnabled()) {
            IStatus status = null;
            try {
                block10: {
                    try {
                        ICompletionProposalComputer computer = this.getComputer(true);
                        if (computer == null) break block10;
                        PerformanceStats stats = this.startMeter(context, computer);
                        List proposals = computer.computeContextInformation(context, monitor);
                        this.stopMeter(stats, COMPUTE_CONTEXT_INFORMATION);
                        if (proposals != null) {
                            this.fLastError = computer.getErrorMessage();
                            contextInformation = proposals;
                            break block10;
                        }
                        status = this.createAPIViolationStatus(COMPUTE_CONTEXT_INFORMATION);
                    }
                    catch (InvalidRegistryObjectException x) {
                        status = this.createExceptionStatus(x);
                    }
                    catch (CoreException x) {
                        status = this.createExceptionStatus(x);
                    }
                    catch (RuntimeException x) {
                        status = this.createExceptionStatus(x);
                    }
                }
                Object var8_13 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            if (status != null) {
                Logger.log(status);
            }
        }
        return contextInformation;
    }

    public void sessionStarted() {
        if (this.isEnabled()) {
            IStatus status = null;
            try {
                ICompletionProposalComputer computer = this.getComputer(true);
                if (computer != null) {
                    PerformanceStats stats = this.startMeter(SESSION_STARTED, computer);
                    computer.sessionStarted();
                    this.stopMeter(stats, SESSION_ENDED);
                }
            }
            catch (InvalidRegistryObjectException x) {
                status = this.createExceptionStatus(x);
            }
            catch (CoreException x) {
                status = this.createExceptionStatus(x);
            }
            catch (RuntimeException x) {
                status = this.createExceptionStatus(x);
            }
            if (status != null) {
                Logger.log(status);
            }
        }
    }

    public void sessionEnded() {
        if (this.isEnabled()) {
            IStatus status = null;
            try {
                ICompletionProposalComputer computer = this.getComputer(true);
                if (computer != null) {
                    PerformanceStats stats = this.startMeter(SESSION_ENDED, computer);
                    computer.sessionEnded();
                    this.stopMeter(stats, SESSION_ENDED);
                }
            }
            catch (InvalidRegistryObjectException x) {
                status = this.createExceptionStatus(x);
            }
            catch (CoreException x) {
                status = this.createExceptionStatus(x);
            }
            catch (RuntimeException x) {
                status = this.createExceptionStatus(x);
            }
            if (status != null) {
                Logger.log(status);
            }
        }
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    public String toString() {
        return String.valueOf(this.fId) + ": " + this.fName;
    }

    protected static void parseActivationAndAddToRegistry(IConfigurationElement element, CompletionProposalComputerDescriptor desc) throws InvalidRegistryObjectException, CoreException {
        IConfigurationElement[] contentTypes = element.getChildren(ELEM_CONTENT_TYPE);
        if (contentTypes.length > 0) {
            int contentTypeIndex = 0;
            while (contentTypeIndex < contentTypes.length) {
                String contentTypeID = contentTypes[contentTypeIndex].getAttribute(ATTR_ID);
                ContentAssistUtils.checkExtensionAttributeNotNull(contentTypeID, ATTR_ID, contentTypes[contentTypeIndex]);
                IConfigurationElement[] partitionTypes = contentTypes[contentTypeIndex].getChildren(ELEM_PARTITION_TYPE);
                if (partitionTypes.length > 0) {
                    int partitionTypeIndex = 0;
                    while (partitionTypeIndex < partitionTypes.length) {
                        String partitionTypeID = partitionTypes[partitionTypeIndex].getAttribute(ATTR_ID);
                        ContentAssistUtils.checkExtensionAttributeNotNull(partitionTypeID, ATTR_ID, partitionTypes[partitionTypeIndex]);
                        CompletionProposalComputerRegistry.getDefault().putDescription(contentTypeID, partitionTypeID, desc);
                        CompletionProposalComputerRegistry.getDefault().putAutoActivator(contentTypeID, partitionTypeID, partitionTypes[partitionTypeIndex]);
                        ++partitionTypeIndex;
                    }
                } else {
                    CompletionProposalComputerRegistry.getDefault().putDescription(contentTypeID, null, desc);
                }
                ++contentTypeIndex;
            }
        } else {
            Logger.log(2, "The configuration element: " + element + " does not contain any content types.");
        }
    }

    private boolean isPluginLoaded() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    private synchronized ICompletionProposalComputer getComputer(boolean canCreate) throws CoreException, InvalidRegistryObjectException {
        if (this.fComputer == null && canCreate && !this.fTriedLoadingComputer && (this.fActivate || this.isPluginLoaded())) {
            this.fTriedLoadingComputer = true;
            this.fComputer = this.createComputer();
        }
        return this.fComputer;
    }

    private boolean isEnabled() {
        return this.fCategory.isEnabled();
    }

    private PerformanceStats startMeter(Object context, ICompletionProposalComputer computer) {
        PerformanceStats stats;
        if (MEASURE_PERFORMANCE) {
            stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)computer);
            stats.startRun(context.toString());
        } else {
            stats = null;
        }
        if (this.fIsReportingDelay) {
            this.fStart = System.currentTimeMillis();
        }
        return stats;
    }

    private void stopMeter(PerformanceStats stats, String operation) {
        long current;
        if (MEASURE_PERFORMANCE) {
            stats.endRun();
            if (stats.isFailure()) {
                IStatus status = this.createPerformanceStatus(operation);
                Logger.log(status);
                return;
            }
        }
        if (this.fIsReportingDelay && (current = System.currentTimeMillis()) - this.fStart > 500000L) {
            IStatus status = this.createPerformanceStatus(operation);
            Logger.log(status);
        }
    }

    private String createBlameMessage() {
        return "The ''" + this.getName() + "'' proposal computer from the ''" + this.fElement.getDeclaringExtension().getContributor().getName() + "'' plug-in did not complete normally.";
    }

    private IStatus createExceptionStatus(InvalidRegistryObjectException x) {
        String blame = this.createBlameMessage();
        String reason = "The extension has become invalid.";
        return new Status(1, "org.eclipse.wst.sse.ui", 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createExceptionStatus(CoreException x) {
        String blame = this.createBlameMessage();
        String reason = "Unable to instantiate the extension.";
        return new Status(4, "org.eclipse.wst.sse.ui", 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createExceptionStatus(RuntimeException x) {
        String blame = this.createBlameMessage();
        String reason = "The extension has thrown a runtime exception.";
        return new Status(2, "org.eclipse.wst.sse.ui", 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createAPIViolationStatus(String operation) {
        String blame = this.createBlameMessage();
        String reason = "The extension violated the API contract of the ''" + operation + "'' operation.";
        return new Status(2, "org.eclipse.wst.sse.ui", 0, String.valueOf(blame) + " " + reason, null);
    }

    private IStatus createPerformanceStatus(String operation) {
        String blame = this.createBlameMessage();
        String reason = "The extension took too long to return from the ''" + operation + "'' operation.";
        return new Status(2, "org.eclipse.wst.sse.ui", 0, String.valueOf(blame) + " " + reason, null);
    }
}

