/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmGenerator;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmTableGenerator
extends AbstractOrmGenerator<XmlTableGenerator>
implements OrmTableGenerator,
UniqueConstraint.Owner {
    protected String specifiedTable;
    protected String defaultTable;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedPkColumnName;
    protected String defaultPkColumnName;
    protected String specifiedValueColumnName;
    protected String defaultValueColumnName;
    protected String specifiedPkColumnValue;
    protected String defaultPkColumnValue;
    protected final List<OrmUniqueConstraint> uniqueConstraints = new ArrayList<OrmUniqueConstraint>();

    public GenericOrmTableGenerator(XmlContextNode parent, XmlTableGenerator resourceTableGenerator) {
        super(parent);
        this.initialize(resourceTableGenerator);
    }

    @Override
    public int getDefaultInitialValue() {
        return 0;
    }

    @Override
    public String getTable() {
        return this.specifiedTable != null ? this.specifiedTable : this.defaultTable;
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String table) {
        String old = this.specifiedTable;
        this.specifiedTable = table;
        ((XmlTableGenerator)this.getResourceGenerator()).setTable(table);
        this.firePropertyChanged("specifiedTable", old, table);
    }

    protected void setSpecifiedTable_(String table) {
        String old = this.specifiedTable;
        this.specifiedTable = table;
        this.firePropertyChanged("specifiedTable", old, table);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String table) {
        String old = this.defaultTable;
        this.defaultTable = table;
        this.firePropertyChanged("defaultTable", old, table);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        ((XmlTableGenerator)this.getResourceGenerator()).setSchema(schema);
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        ((XmlTableGenerator)this.getResourceGenerator()).setCatalog(catalog);
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    @Override
    public String getPkColumnName() {
        return this.specifiedPkColumnName != null ? this.specifiedPkColumnName : this.defaultPkColumnName;
    }

    @Override
    public String getSpecifiedPkColumnName() {
        return this.specifiedPkColumnName;
    }

    @Override
    public void setSpecifiedPkColumnName(String name) {
        String old = this.specifiedPkColumnName;
        this.specifiedPkColumnName = name;
        ((XmlTableGenerator)this.getResourceGenerator()).setPkColumnName(name);
        this.firePropertyChanged("specifiedPkColumnName", old, name);
    }

    protected void setSpecifiedPkColumnName_(String name) {
        String old = this.specifiedPkColumnName;
        this.specifiedPkColumnName = name;
        this.firePropertyChanged("specifiedPkColumnName", old, name);
    }

    @Override
    public String getDefaultPkColumnName() {
        return this.defaultPkColumnName;
    }

    protected void setDefaultPkColumnName(String name) {
        String old = this.defaultPkColumnName;
        this.defaultPkColumnName = name;
        this.firePropertyChanged("defaultPkColumnName", old, name);
    }

    @Override
    public String getValueColumnName() {
        return this.specifiedValueColumnName != null ? this.specifiedValueColumnName : this.defaultValueColumnName;
    }

    @Override
    public String getSpecifiedValueColumnName() {
        return this.specifiedValueColumnName;
    }

    @Override
    public void setSpecifiedValueColumnName(String name) {
        String old = this.specifiedValueColumnName;
        this.specifiedValueColumnName = name;
        ((XmlTableGenerator)this.getResourceGenerator()).setValueColumnName(name);
        this.firePropertyChanged("specifiedValueColumnName", old, name);
    }

    protected void setSpecifiedValueColumnName_(String name) {
        String old = this.specifiedValueColumnName;
        this.specifiedValueColumnName = name;
        this.firePropertyChanged("specifiedValueColumnName", old, name);
    }

    @Override
    public String getDefaultValueColumnName() {
        return this.defaultValueColumnName;
    }

    protected void setDefaultValueColumnName(String name) {
        String old = this.defaultValueColumnName;
        this.defaultValueColumnName = name;
        this.firePropertyChanged("defaultValueColumnName", old, name);
    }

    @Override
    public String getPkColumnValue() {
        return this.specifiedPkColumnValue != null ? this.specifiedPkColumnValue : this.defaultPkColumnValue;
    }

    @Override
    public String getSpecifiedPkColumnValue() {
        return this.specifiedPkColumnValue;
    }

    @Override
    public void setSpecifiedPkColumnValue(String value) {
        String old = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = value;
        ((XmlTableGenerator)this.getResourceGenerator()).setPkColumnValue(value);
        this.firePropertyChanged("specifiedPkColummValue", old, value);
    }

    protected void setSpecifiedPkColumnValue_(String value) {
        String old = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = value;
        this.firePropertyChanged("specifiedPkColummValue", old, value);
    }

    @Override
    public String getDefaultPkColumnValue() {
        return this.defaultPkColumnValue;
    }

    public void setDefaultPkColumnValue(String value) {
        String old = this.defaultPkColumnValue;
        this.defaultPkColumnValue = value;
        this.firePropertyChanged("defaultPkColummValue", old, value);
    }

    @Override
    public ListIterator<OrmUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint(int index) {
        XmlUniqueConstraint resourceUC = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        OrmUniqueConstraint contextUC = this.buildUniqueConstraint(resourceUC);
        this.uniqueConstraints.add(index, contextUC);
        ((XmlTableGenerator)this.getResourceGenerator()).getUniqueConstraints().add(index, (Object)resourceUC);
        this.fireItemAdded("uniqueConstraints", index, contextUC);
        return contextUC;
    }

    protected void addUniqueConstraint(int index, OrmUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected void addUniqueConstraint(OrmUniqueConstraint uniqueConstraint) {
        this.addUniqueConstraint(this.uniqueConstraints.size(), uniqueConstraint);
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        OrmUniqueConstraint uniqueConstraint = this.uniqueConstraints.remove(index);
        ((XmlTableGenerator)this.getResourceGenerator()).getUniqueConstraints().remove(index);
        this.fireItemRemoved("uniqueConstraints", index, uniqueConstraint);
    }

    protected void removeUniqueConstraint_(OrmUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        ((XmlTableGenerator)this.getResourceGenerator()).getUniqueConstraints().move(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers().iterator() : EmptyIterator.instance();
    }

    @Override
    protected void initialize(XmlTableGenerator xmlTableGenerator) {
        super.initialize(xmlTableGenerator);
        this.specifiedTable = xmlTableGenerator.getTable();
        this.defaultSchema = this.buildDefaultSchema();
        this.specifiedSchema = xmlTableGenerator.getSchema();
        this.defaultCatalog = this.buildDefaultCatalog();
        this.specifiedCatalog = xmlTableGenerator.getCatalog();
        this.specifiedPkColumnName = xmlTableGenerator.getPkColumnName();
        this.specifiedValueColumnName = xmlTableGenerator.getValueColumnName();
        this.specifiedPkColumnValue = xmlTableGenerator.getPkColumnValue();
        this.initializeUniqueContraints();
    }

    protected void initializeUniqueContraints() {
        if (this.resourceGenerator == null) {
            return;
        }
        for (XmlUniqueConstraint uniqueConstraint : ((XmlTableGenerator)this.resourceGenerator).getUniqueConstraints()) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(uniqueConstraint));
        }
    }

    @Override
    public void update(XmlTableGenerator xmlTableGenerator) {
        super.update(xmlTableGenerator);
        this.setSpecifiedTable_(xmlTableGenerator.getTable());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setSpecifiedSchema_(xmlTableGenerator.getSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setSpecifiedCatalog_(xmlTableGenerator.getCatalog());
        this.setSpecifiedPkColumnName_(xmlTableGenerator.getPkColumnName());
        this.setSpecifiedValueColumnName_(xmlTableGenerator.getValueColumnName());
        this.setSpecifiedPkColumnValue_(xmlTableGenerator.getPkColumnValue());
        this.updateUniqueConstraints();
    }

    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    protected void updateUniqueConstraints() {
        Iterator<XmlUniqueConstraint> xmlConstraints = this.xmlUniqueConstraints();
        ListIterator<OrmUniqueConstraint> contextConstraints = this.uniqueConstraints();
        while (contextConstraints.hasNext()) {
            OrmUniqueConstraint contextConstraint = (OrmUniqueConstraint)contextConstraints.next();
            if (xmlConstraints.hasNext()) {
                contextConstraint.update(xmlConstraints.next());
                continue;
            }
            this.removeUniqueConstraint_(contextConstraint);
        }
        while (xmlConstraints.hasNext()) {
            this.addUniqueConstraint(this.buildUniqueConstraint(xmlConstraints.next()));
        }
    }

    protected Iterator<XmlUniqueConstraint> xmlUniqueConstraints() {
        return this.resourceGenerator == null ? EmptyIterator.instance() : new CloneIterator(((XmlTableGenerator)this.resourceGenerator).getUniqueConstraints());
    }

    protected OrmUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint resourceUniqueConstraint) {
        return this.getXmlContextNodeFactory().buildOrmUniqueConstraint(this, this, resourceUniqueConstraint);
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getTable());
    }
}

