/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesContainer;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesLibraryProviderInstallOperationConfig;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WtpOsgiBundlesLibraryProviderInstallOperationConfig
extends OsgiBundlesLibraryProviderInstallOperationConfig {
    private static final String CLASS_NAME = WtpOsgiBundlesLibraryProviderInstallOperationConfig.class.getName();
    public static final String PROP_INCLUDE_WITH_APPLICATION_ENABLED = String.valueOf(CLASS_NAME) + ".INCLUDE_WITH_APPLICATION_ENABLED";
    private static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    private boolean includeWithApplication = true;

    public boolean isIncludeWithApplicationEnabled() {
        return this.includeWithApplication;
    }

    public void setIncludeWithApplicationEnabled(boolean includeWithApplication) {
        boolean oldValue = this.includeWithApplication;
        this.includeWithApplication = includeWithApplication;
        this.notifyListeners(PROP_INCLUDE_WITH_APPLICATION_ENABLED, oldValue, this.includeWithApplication);
    }

    public synchronized void init(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        IProjectFacet f;
        ILibraryProvider currentProvider;
        super.init(fproj, fv, provider);
        this.includeWithApplication = true;
        IProject project = fproj.getProject();
        if (project != null && (currentProvider = LibraryProviderFramework.getCurrentProvider((IProject)project, (IProjectFacet)(f = fv.getProjectFacet()))) == provider) {
            IPath path = OsgiBundlesContainer.CONTAINER_PATH.append(f.getId());
            IJavaProject jproj = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry cpe = iClasspathEntryArray[n2];
                    if (path.equals((Object)cpe.getPath())) {
                        this.includeWithApplication = true;
                        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
                        int n3 = iClasspathAttributeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IClasspathAttribute attr = iClasspathAttributeArray[n4];
                            if (attr.getName().equals("org.eclipse.jst.component.nondependency")) {
                                this.includeWithApplication = false;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IClasspathAttribute[] getClasspathAttributes() {
        IFacetedProjectBase fproj = this.getFacetedProject();
        boolean isWebProject = fproj.hasProjectFacet(WEB_FACET);
        IClasspathAttribute attr = this.isIncludeWithApplicationEnabled() ? JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath(isWebProject).toString()) : JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.nondependency", (String)"");
        return new IClasspathAttribute[]{attr};
    }
}

