/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.sampleapp.codegen;

import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.StringUtils;
import org.eclipse.jst.ws.internal.consumption.codegen.bean.AttributeVisitor;
import org.eclipse.jst.ws.internal.consumption.codegen.bean.FieldVisitor;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.AttributeElementType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.DataType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.SimpleElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeFactory;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.InputFileAttributeGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.InputFileHelp2Generator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.LevelsDeepVisitorAction;

public class InputFileTypeGenerator
extends InputFileHelp2Generator {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    protected String fParentGetters;
    protected int fLevelsDeep;
    protected int fColspan;
    protected int fCurrentLevel;
    private boolean fIsSimple;
    private boolean fStateLessBean;
    private Vector fGetters;
    private Vector fTypes;
    private boolean fWrite = true;

    public InputFileTypeGenerator(StringBuffer buffer, int currentLevel) {
        super(buffer);
        this.fCurrentLevel = currentLevel;
        this.fLevelsDeep = -1;
        this.fParentGetters = "";
    }

    public InputFileTypeGenerator(StringBuffer buffer, int currentLevel, int levelsDeep) {
        super(buffer);
        this.fCurrentLevel = currentLevel;
        this.fLevelsDeep = levelsDeep;
        this.fParentGetters = "";
    }

    public void setParentGetters(Vector getter, Vector type) {
        if (this.fGetters != null) {
            this.fGetters.clear();
            this.fTypes.clear();
        }
        this.addParentGetter(getter, type);
    }

    public void addParentGetter(String getter, String type) {
        if (this.fGetters == null) {
            this.fGetters = new Vector();
        }
        if (this.fTypes == null) {
            this.fTypes = new Vector();
        }
        this.fGetters.addElement(getter);
        this.fTypes.addElement(type);
    }

    public void addParentGetter(Vector getters, Vector types) {
        if (this.fGetters == null) {
            this.fGetters = new Vector();
        }
        if (this.fTypes == null) {
            this.fTypes = new Vector();
        }
        int size = getters.size();
        int i = 0;
        while (i < size) {
            this.fGetters.addElement(getters.get(i));
            this.fTypes.addElement(types.get(i));
            ++i;
        }
    }

    protected String returnParentGetter(int count) {
        if (this.fGetters == null || count > this.fGetters.size()) {
            return null;
        }
        return (String)this.fGetters.get(count);
    }

    protected String returnParentGetterType(int count) {
        if (this.fTypes == null || count > this.fTypes.size()) {
            return null;
        }
        return (String)this.fTypes.get(count);
    }

    protected Vector returnParentGetter() {
        if (this.fGetters == null) {
            return new Vector();
        }
        return this.fGetters;
    }

    protected Vector returnParentGetterType() {
        if (this.fTypes == null) {
            return new Vector();
        }
        return this.fTypes;
    }

    protected int getterCount() {
        if (this.fGetters == null) {
            return 0;
        }
        return this.fGetters.size();
    }

    public String getParentGetters() {
        return this.fParentGetters;
    }

    public IStatus visit(Object object) {
        FieldVisitor fieldVisitor;
        TypeElement element = (TypeElement)((Object)object);
        if (Boolean.TRUE.equals(element.getPropertyAsObject("nonInstantiable"))) {
            return Status.OK_STATUS;
        }
        this.fIsSimple = element instanceof SimpleElement;
        if (element instanceof BeanElement) {
            BeanElement bean = (BeanElement)element;
            if (bean.isStateLess()) {
                this.fStateLessBean = true;
            }
            if (bean.getAttrib() == BeanElement.READONLY) {
                this.fWrite = false;
            }
        }
        if (this.fLevelsDeep == -1) {
            AttributeVisitor attributeVisitor = new AttributeVisitor();
            LevelsDeepVisitorAction ldva = new LevelsDeepVisitorAction();
            attributeVisitor.run((Object)element, ldva);
            this.fLevelsDeep = ldva.getLevelsDeep();
            fieldVisitor = new FieldVisitor();
            LevelsDeepVisitorAction ldva2 = new LevelsDeepVisitorAction();
            fieldVisitor.run((Object)element, ldva2);
            if (this.fLevelsDeep < ldva2.getLevelsDeep()) {
                this.fLevelsDeep = ldva2.getLevelsDeep();
            }
            ++this.fLevelsDeep;
        }
        this.fColspan = this.fLevelsDeep - this.fCurrentLevel;
        if (this.getReturnParam() && element.getOwningElement() instanceof AttributeElementType && ((AttributeElementType)element.getOwningElement()).getGetterMethod() == null) {
            return Status.OK_STATUS;
        }
        if (this.fWrite) {
            this.fbuffer.append("<TR>" + StringUtils.NEWLINE);
            int i = 0;
            while (i < this.fCurrentLevel) {
                this.fbuffer.append("<TD WIDTH=\"5%\"></TD>" + StringUtils.NEWLINE);
                ++i;
            }
            this.fbuffer.append("<TD COLSPAN=\"" + this.fColspan + "\" ALIGN=\"LEFT\">" + element.getOwningElement().getName() + ":</TD>" + StringUtils.NEWLINE);
        }
        if (this.fIsSimple || TypeFactory.recognizedBean(element.getName()) || this.getReturnParam() && this.fStateLessBean || this.getReturnParam() && TypeFactory.isRecognizedReturnType(element.getTypeName())) {
            if (this.getInstanceName().equals("")) {
                if (this.fWrite) {
                    DataType dataType = TypeFactory.createType(element.getName(), element.getOwningElement().getMUID());
                    this.fbuffer.append(dataType.inputForm(element.getOwningElement().getMUID()));
                }
            } else if (this.getReturnParam() && (TypeFactory.isRecognizedReturnType(element.getTypeName()) || this.fStateLessBean)) {
                DataType dataType = TypeFactory.createType(element.getTypeName(), element.getOwningElement().getMUID());
                String uniqueName = "type" + dataType.getUniqueName();
                this.fbuffer.append("<TD>" + StringUtils.NEWLINE);
                this.fbuffer.append("<%" + StringUtils.NEWLINE);
                this.fbuffer.append("if(" + this.getInstanceName() + " != null){" + StringUtils.NEWLINE);
                String afterString = this.getInstanceName();
                String tmpString = "tebece";
                String prevString = this.getInstanceName();
                String newTmpString = "";
                int i = 0;
                while (i < this.getterCount()) {
                    newTmpString = String.valueOf(tmpString) + i;
                    this.fbuffer.append(String.valueOf(this.returnParentGetterType(i)) + " " + newTmpString + "=" + prevString + "." + this.returnParentGetter(i) + ";" + StringUtils.NEWLINE);
                    prevString = newTmpString;
                    this.fbuffer.append("if(" + newTmpString + " != null){" + StringUtils.NEWLINE);
                    afterString = newTmpString;
                    ++i;
                }
                this.fbuffer.append(String.valueOf(element.getName()) + " " + uniqueName + " = " + afterString + "." + ((AttributeElementType)element.getOwningElement()).getGetterMethod() + ";" + StringUtils.NEWLINE);
                this.fbuffer.append(dataType.TypeConversion(uniqueName));
                i = 0;
                while (i < this.getterCount()) {
                    this.fbuffer.append("}");
                    ++i;
                }
                this.fbuffer.append("}%>" + StringUtils.NEWLINE);
                this.fbuffer.append("</TD>" + StringUtils.NEWLINE);
            } else {
                this.fbuffer.append("<TD>" + StringUtils.NEWLINE);
                this.fbuffer.append("<%" + StringUtils.NEWLINE);
                this.fbuffer.append("if(" + this.getInstanceName() + " != null){" + StringUtils.NEWLINE);
                String afterString = this.getInstanceName();
                String tmpString = "tebece";
                String prevString = this.getInstanceName();
                String newTmpString = "";
                int i = 0;
                while (i < this.getterCount()) {
                    newTmpString = String.valueOf(tmpString) + i;
                    this.fbuffer.append(String.valueOf(this.returnParentGetterType(i)) + " " + newTmpString + "=" + prevString + "." + this.returnParentGetter(i) + ";" + StringUtils.NEWLINE);
                    prevString = newTmpString;
                    this.fbuffer.append("if(" + newTmpString + " != null){" + StringUtils.NEWLINE);
                    afterString = newTmpString;
                    ++i;
                }
                this.fbuffer.append("%>" + StringUtils.NEWLINE);
                this.fbuffer.append("<%=");
                this.fbuffer.append(String.valueOf(afterString) + "." + ((AttributeElementType)element.getOwningElement()).getGetterMethod() + StringUtils.NEWLINE);
                this.fbuffer.append("%>");
                this.fbuffer.append("<%");
                i = 0;
                while (i < this.getterCount()) {
                    this.fbuffer.append("}");
                    ++i;
                }
                this.fbuffer.append("}%>" + StringUtils.NEWLINE);
                this.fbuffer.append("</TD>" + StringUtils.NEWLINE);
            }
        } else {
            AttributeVisitor attributeVisitor = new AttributeVisitor();
            attributeVisitor.setResidentVector1(this.returnParentGetter());
            attributeVisitor.setResidentVector2(this.returnParentGetterType());
            InputFileAttributeGenerator inputFileAttributeGenerator = new InputFileAttributeGenerator(this.fbuffer, this.fCurrentLevel + 1, this.fLevelsDeep);
            inputFileAttributeGenerator.setReturnParam(this.getReturnParam());
            inputFileAttributeGenerator.setInstanceName(this.fInstanceName);
            attributeVisitor.run((Object)element, inputFileAttributeGenerator);
            this.fbuffer = inputFileAttributeGenerator.getStringBuffer();
            fieldVisitor = new FieldVisitor();
            fieldVisitor.setResidentVector1(this.returnParentGetter());
            fieldVisitor.setResidentVector2(this.returnParentGetterType());
            InputFileAttributeGenerator inputFileAttributeGenerator2 = new InputFileAttributeGenerator(this.fbuffer, this.fCurrentLevel + 1, this.fLevelsDeep);
            inputFileAttributeGenerator2.setReturnParam(this.getReturnParam());
            inputFileAttributeGenerator2.setInstanceName(this.fInstanceName);
            fieldVisitor.run((Object)element, inputFileAttributeGenerator2);
            this.fbuffer = inputFileAttributeGenerator2.getStringBuffer();
        }
        return Status.OK_STATUS;
    }
}

