/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestOperation;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBClientManifestUtility;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class InvertClientJARDependencyCompoundOperation
extends AbstractDataModelOperation {
    protected IProject[] earProjects;
    protected IProject oldProject;
    protected IProject newProject;
    protected List childOperations = null;
    protected IProgressMonitor monitor;

    public InvertClientJARDependencyCompoundOperation(IProject[] referencingEARs, IProject anOldProject, IProject aNewProject) {
        this.earProjects = referencingEARs;
        this.oldProject = anOldProject;
        this.newProject = aNewProject;
    }

    public IStatus execute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.monitor = aMonitor;
        this.createChildOperations();
        this.executeChildOperations();
        return OK_STATUS;
    }

    private void createChildOperations() {
        this.childOperations = new ArrayList();
        int i = 0;
        while (i < this.earProjects.length) {
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)this.earProjects[i]);
            IVirtualReference[] refs = earComponent.getReferences();
            int j = 0;
            while (j < refs.length) {
                IProject project;
                IVirtualReference ref = refs[j];
                IVirtualComponent comp = ref.getReferencedComponent();
                if (!(comp == null || (project = comp.getProject()) == null || project.equals((Object)this.oldProject) || project.equals((Object)this.newProject) || JemProjectUtilities.isBinaryProject((IProject)project) || comp.isBinary())) {
                    UpdateManifestOperation invertOp = new EJBClientManifestUtility().getInvertOperation(project, this.earProjects[0], this.newProject, this.oldProject);
                    this.childOperations.add(invertOp);
                }
                ++j;
            }
            ++i;
        }
    }

    private void executeChildOperations() {
        this.monitor.beginTask("", this.childOperations.size());
        int i = 0;
        while (i < this.childOperations.size()) {
            AbstractDataModelOperation op = (AbstractDataModelOperation)this.childOperations.get(i);
            try {
                op.execute((IProgressMonitor)new SubProgressMonitor(this.monitor, 1), null);
            }
            catch (Exception e) {
                EjbPlugin.logError(e);
            }
            ++i;
        }
    }
}

