/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.FilterUtil;
import org.eclipse.wst.validation.internal.IProjectValidationHelper;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ReferencialFileValidatorRegistryReader;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.MessageInfo;
import org.eclipse.wst.validation.internal.operations.ReferencialFileValidator;
import org.eclipse.wst.validation.internal.operations.ReferencialFileValidatorHelper;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.operations.ValidatorJob;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationHelperRegistryReader;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidationOperation
implements IWorkspaceRunnable,
IHeadlessRunnableWithProgress {
    public static final int NO_DELTA_CHANGE = -1;
    private static final String DELTA_AS_STRING = "IFileDelta[{0}] '{'{1}'}'";
    private static final String COMMA = ", ";
    protected static final boolean DEFAULT_ASYNC = true;
    protected static final boolean DEFAULT_FORCE = true;
    private static ValidationLauncherJob launcherJob = new ValidationLauncherJob();
    private static final int jobsPerProcessor = 3;
    protected static final boolean DEFAULT_FORK = false;
    private IProject _project;
    private int _ruleGroup = 1;
    private boolean _fork = true;
    private Map<ValidatorMetaData, Set<IFileDelta>> _fileDeltas;
    private IResourceDelta _delta;
    private Set<ValidatorMetaData> _enabledValidators;
    private boolean _force = true;
    private boolean _isFullValidate;
    private Boolean _isAutoBuild;
    private Set<ValidatorMetaData> _launchedValidators;
    protected IWorkbenchContext context;

    private static final String getDeltaAsString(IFileDelta[] delta) {
        String args = "";
        int numArgs = 0;
        if (delta != null) {
            numArgs = delta.length;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < delta.length) {
                buffer.append(COMMA);
                buffer.append(delta[i].toString());
                ++i;
            }
            buffer.replace(0, 1, "");
            args = buffer.toString();
        }
        return MessageFormat.format(DELTA_AS_STRING, String.valueOf(numArgs), args);
    }

    protected static void checkCanceled(WorkbenchReporter reporter) throws OperationCanceledException {
        if (reporter == null) {
            return;
        }
        if (reporter.getProgressMonitor().isCanceled()) {
            throw new OperationCanceledException("");
        }
    }

    protected static boolean shouldForce(IResourceDelta delta) {
        return delta == null;
    }

    protected static boolean shouldForce(Object[] changedResources) {
        return changedResources == null || changedResources.length == 0;
    }

    public ValidationOperation(IProject project) {
        this(project, true, true);
    }

    public ValidationOperation(IProject project, boolean force, boolean async) {
        this(project, null, null, 1, force, async);
    }

    public ValidationOperation(IProject project, int ruleGroup) {
        this(project, null, null, ruleGroup, true, true);
    }

    public ValidationOperation(IProject project, IResourceDelta delta, boolean isAutoBuild, int ruleGroup, boolean force, boolean fork) {
        this(project, delta, isAutoBuild ? Boolean.TRUE : Boolean.FALSE, ruleGroup, fork, force);
    }

    protected ValidationOperation(IProject project, IResourceDelta delta, Boolean isAutoBuild, int ruleGroup, boolean force, boolean fork) {
        this._project = project;
        this._delta = delta;
        this._isAutoBuild = isAutoBuild;
        this._ruleGroup = ruleGroup;
        this._fork = fork;
        this._force = force;
        this._enabledValidators = new HashSet<ValidatorMetaData>();
    }

    protected ValidationOperation(IProject project, IWorkbenchContext aContext, IResourceDelta delta, Boolean isAutoBuild, int ruleGroup, boolean force, boolean fork) {
        this._project = project;
        this._delta = delta;
        this._isAutoBuild = isAutoBuild;
        this._ruleGroup = ruleGroup;
        this._fork = fork;
        this._force = force;
        this._enabledValidators = new HashSet<ValidatorMetaData>();
        this.context = aContext;
    }

    protected void terminateCleanup(WorkbenchReporter reporter) {
        for (ValidatorMetaData vmd : this.getEnabledValidators()) {
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_CLEANUP", new String[]{vmd.getValidatorDisplayName()}));
            try {
                reporter.removeAllMessages(vmd.getValidator());
            }
            catch (InstantiationException e) {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                ValidationPlugin.getPlugin().handleException(e);
                continue;
            }
            this.addCancelTask(vmd);
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()}));
        }
    }

    public boolean isFork() {
        return this._fork;
    }

    public boolean isForce() {
        return this._force;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public boolean isAutoBuild() {
        if (this._isAutoBuild == null) {
            return ValidatorManager.getManager().isGlobalAutoBuildEnabled();
        }
        return this._isAutoBuild;
    }

    protected void setAutoBuild(boolean autoOn) {
        this._isAutoBuild = autoOn ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean isFullValidate() {
        return this._isFullValidate;
    }

    private void setFullValidate(boolean b) {
        this._isFullValidate = b;
    }

    protected int getRuleGroup() {
        return this._ruleGroup;
    }

    private boolean isValidationNecessary(ValidatorMetaData vmd, IFileDelta[] delta) {
        return this.isFullValidate() || delta.length > 0;
    }

    public boolean isNecessary(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Set<ValidatorMetaData> enabledValidators = this.getEnabledValidators();
        if (enabledValidators == null || enabledValidators.size() == 0) {
            return false;
        }
        if (this.isFullValidate()) {
            return true;
        }
        for (ValidatorMetaData vmd : enabledValidators) {
            if (!this.isValidationNecessary(vmd, this.getFileDeltas(monitor, vmd))) continue;
            return true;
        }
        return false;
    }

    private Map<ValidatorMetaData, Set<IFileDelta>> getFileDeltas(IProgressMonitor monitor) throws CoreException {
        if (this._fileDeltas == null) {
            this.loadFileDeltas(monitor);
        }
        return this._fileDeltas;
    }

    private IFileDelta[] getFileDeltas(IProgressMonitor monitor, ValidatorMetaData vmd) throws CoreException {
        Set<IFileDelta> result = this.getFileDeltas(monitor).get(vmd);
        if (result == null) {
            return new IFileDelta[0];
        }
        IFileDelta[] temp = new IFileDelta[result.size()];
        result.toArray(temp);
        return temp;
    }

    private void loadFileDeltas(IProgressMonitor monitor) throws CoreException {
        this.setFullValidate(this.getDelta() == null && this._fileDeltas == null);
        this._fileDeltas = this.isFullValidate() ? FilterUtil.loadDeltas(monitor, this.getEnabledValidators(), this.getProject()) : FilterUtil.loadDeltas(monitor, this.getEnabledValidators(), this.getDelta());
    }

    protected void setFileDeltas(Map<ValidatorMetaData, Set<IFileDelta>> deltas) {
        this._fileDeltas = deltas;
    }

    protected IResourceDelta getDelta() {
        return this._delta;
    }

    protected void setDelta(IResourceDelta delta) {
        this._delta = delta;
    }

    protected boolean areValidatorsEnabled() {
        return this.getEnabledValidators().size() != 0;
    }

    public Set<ValidatorMetaData> getEnabledValidators() {
        return this._enabledValidators;
    }

    public Set<ValidatorMetaData> getLaunchedValidators() {
        if (this._launchedValidators == null) {
            this._launchedValidators = new HashSet<ValidatorMetaData>();
        }
        return this._launchedValidators;
    }

    protected void setEnabledValidators(Set<ValidatorMetaData> evmds) {
        this._enabledValidators.clear();
        for (ValidatorMetaData vmd : evmds) {
            if (!ValidationRegistryReader.getReader().isConfiguredOnProject(vmd, this.getProject())) continue;
            this._enabledValidators.add(vmd);
        }
    }

    public IProject getProject() {
        return this._project;
    }

    protected int getUnitsOfWork() {
        return -1;
    }

    protected void addCancelTask(ValidatorMetaData vmd) {
        InternalValidatorManager.getManager().addOperationTask(this.getProject(), vmd, "VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
    }

    public void run(IProgressMonitor progressMonitor) throws OperationCanceledException {
        if (progressMonitor == null) {
            return;
        }
        IProject project = this.getProject();
        if (ValidationFramework.getDefault().isSuspended(project)) {
            return;
        }
        if (ValManager.getDefault().isDisabled(project)) {
            return;
        }
        if (!this.areValidatorsEnabled()) {
            return;
        }
        WorkbenchReporter reporter = new WorkbenchReporter(this.getProject(), progressMonitor);
        try {
            ValidationOperation.checkCanceled(reporter);
            this.preValidate(reporter);
            this.validate(reporter);
            this.validateReferencialFiles(reporter);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private void validateReferencialFiles(WorkbenchReporter reporter) {
        ReferencialFileValidatorRegistryReader reader = ReferencialFileValidatorRegistryReader.getInstance();
        if (reader != null) {
            reader.readRegistry();
            ReferencialFileValidator refFileValidator = reader.getReferencialFileValidator();
            if (refFileValidator != null) {
                if (this._delta != null) {
                    this.refFileValidateFileDelta(reporter, refFileValidator);
                } else if (this._project != null) {
                    this.postValidateProject(reporter, refFileValidator);
                }
            }
        }
    }

    private void refFileValidateFileDelta(WorkbenchReporter reporter, ReferencialFileValidator refFileValidator) {
        IResourceDelta[] resourceDelta = this._delta.getAffectedChildren(7);
        ArrayList<IResource> inputFiles = new ArrayList<IResource>();
        ArrayList<IFile> referencingFiles = new ArrayList<IFile>();
        if (resourceDelta != null && resourceDelta.length > 0) {
            int i = 0;
            while (i < resourceDelta.length) {
                IResource resource = resourceDelta[i].getResource();
                if (resource instanceof IFolder) {
                    this.getFileResourceDeltaInFolder(resourceDelta[i], inputFiles);
                } else if (resource instanceof IFile) {
                    inputFiles.add(resource);
                }
                ++i;
            }
            List<IFile> rFilesToValidate = refFileValidator.getReferencedFile(inputFiles);
            if (rFilesToValidate != null && !rFilesToValidate.isEmpty()) {
                referencingFiles.addAll(rFilesToValidate);
            }
            try {
                if (!referencingFiles.isEmpty()) {
                    this.validateReferencingFiles(reporter, referencingFiles);
                }
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
    }

    private void getFileResourceDeltaInFolder(IResourceDelta delta, List<IResource> inputFiles) {
        IResourceDelta[] resourceDelta = delta.getAffectedChildren();
        int i = 0;
        while (i < resourceDelta.length) {
            IResource resource = resourceDelta[i].getResource();
            if (resource instanceof IFile) {
                inputFiles.add(resource);
            } else if (resource instanceof IFolder) {
                this.getFileResourceDeltaInFolder(resourceDelta[i], inputFiles);
            }
            ++i;
        }
    }

    private void postValidateProject(WorkbenchReporter reporter, ReferencialFileValidator refFileValidator) {
        Set<ValidatorMetaData> set = ValidationRegistryReader.getReader().getValidatorMetaData(this._project);
        for (ValidatorMetaData data : set) {
            List<String> filters = data.getNameFilters();
            List<IFile> files = this.getAllFilesForFilter(filters);
            if (files.isEmpty()) continue;
            List<IFile> fileForValidation = refFileValidator.getReferencedFile(files);
            try {
                this.validateReferencingFiles(reporter, fileForValidation);
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
    }

    private List<IFile> getAllFilesForFilter(List<String> filters) {
        if (!filters.isEmpty()) {
            List<IFile> allProjectFiles = ReferencialFileValidatorHelper.getAllProjectFiles(this._project);
            ArrayList<IFile> filterFiles = new ArrayList<IFile>();
            for (String fileName : filters) {
                if (fileName == null) continue;
                for (IFile projectFile : allProjectFiles) {
                    if (fileName.charAt(0) == '*') {
                        String extName = fileName.substring(2, fileName.length());
                        String ext = projectFile.getFileExtension();
                        if (ext == null || !ext.equals(extName)) continue;
                        filterFiles.add(projectFile);
                        continue;
                    }
                    if (!fileName.equals(projectFile.getName())) continue;
                    filterFiles.add(projectFile);
                }
            }
            return filterFiles;
        }
        return new LinkedList<IFile>();
    }

    private void validateReferencingFiles(IReporter reporter, List<IFile> referencingFiles) throws Exception {
        HashSet<IFile> validatedFiles = new HashSet<IFile>();
        for (IFile refFile : referencingFiles) {
            if (validatedFiles.contains(refFile)) continue;
            IContainer resource = refFile.getParent();
            IProject project = null;
            project = resource != null && !(resource instanceof IProject) ? this.getProjectContainer((IResource)resource) : (IProject)resource;
            if (project == null) continue;
            Set<ValidatorMetaData> set = ValidationRegistryReader.getReader().getValidatorMetaData(project);
            for (ValidatorMetaData data : set) {
                if (!data.isApplicableTo((IResource)refFile)) continue;
                IValidator validator = data.getValidator();
                validator.validate(data.getHelper(project), reporter);
                validatedFiles.add(refFile);
            }
        }
    }

    private IProject getProjectContainer(IResource resource) {
        IContainer pResource = resource.getParent();
        if (!(pResource instanceof IProject)) {
            return this.getProjectContainer((IResource)pResource);
        }
        return (IProject)pResource;
    }

    protected void preValidate(WorkbenchReporter reporter) throws CoreException, OperationCanceledException {
        this.getFileDeltas(reporter.getProgressMonitor());
    }

    protected void validate(WorkbenchReporter reporter) throws OperationCanceledException {
        if (reporter == null) {
            return;
        }
        ValidationOperation.checkCanceled(reporter);
        reporter.getProgressMonitor().beginTask(ResourceHandler.getExternalizedMessage("VBF_STATUS_PROGRESSMONITOR_TITLE"), this.getUnitsOfWork());
        IValidator validator = null;
        Iterator<ValidatorMetaData> iterator = null;
        IFileDelta[] delta = null;
        HashSet<ValidatorMetaData> jobValidators = new HashSet<ValidatorMetaData>();
        HashSet<ValidatorMetaData> validators = new HashSet<ValidatorMetaData>();
        for (ValidatorMetaData vmd : this.getEnabledValidators()) {
            IValidator valInstance;
            block24: {
                valInstance = null;
                try {
                    valInstance = vmd.getValidator();
                }
                catch (InstantiationException e1) {
                    if (ValidatorManager.getManager().getProblemValidators().contains(vmd)) break block24;
                    ValidatorManager.getManager().getProblemValidators().add(vmd);
                    System.out.println(e1.getMessage());
                }
            }
            if (this.isFork() && valInstance != null && valInstance instanceof IValidatorJob) {
                boolean willRun;
                try {
                    delta = this.getFileDeltas(reporter.getProgressMonitor(), vmd);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                boolean bl = willRun = this.isForce() || this.isValidationNecessary(vmd, delta);
                if (!willRun) continue;
                jobValidators.add(vmd);
                continue;
            }
            if (valInstance == null) continue;
            validators.add(vmd);
        }
        if (jobValidators.size() > 0) {
            this.launchJobs(jobValidators, reporter);
        }
        ValidatorMetaData currentVmd = null;
        try {
            try {
                Iterator iterator2 = validators.iterator();
                while (iterator2.hasNext()) {
                    ValidatorMetaData vmd;
                    block25: {
                        currentVmd = vmd = (ValidatorMetaData)iterator2.next();
                        try {
                            boolean willRun;
                            delta = this.getFileDeltas(reporter.getProgressMonitor(), vmd);
                            boolean bl = willRun = this.isForce() || this.isValidationNecessary(vmd, delta);
                            if (Tracing.isTraceV1()) {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("ValidationOperation-01: will run? ");
                                buffer.append(willRun);
                                buffer.append("  ");
                                buffer.append("is force? ");
                                buffer.append(this.isForce());
                                buffer.append("  ");
                                buffer.append("isAutoBuild? ");
                                buffer.append(this._isAutoBuild);
                                buffer.append("  ");
                                buffer.append("isAutoValidate? ");
                                buffer.append("  ");
                                buffer.append("isIncremental? ");
                                buffer.append(vmd.isIncremental());
                                buffer.append("  ");
                                if (this.isFullValidate()) {
                                    buffer.append("EVERYTHING");
                                } else if (delta.length == 0) {
                                    buffer.append("NOTHING");
                                } else {
                                    buffer.append(ValidationOperation.getDeltaAsString(delta));
                                }
                                Tracing.log(buffer);
                            }
                            if (!willRun) {
                            }
                            break block25;
                        }
                        catch (CoreException e) {
                            ValidationPlugin.getPlugin().handleException(e);
                            String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                            reporter.displaySubtask(mssg);
                        }
                        continue;
                    }
                    try {
                        this.context = vmd.getHelper(this.getProject());
                        this.initValidateContext(delta);
                        validator = vmd.getValidator();
                        ValidationOperation.checkCanceled(reporter);
                    }
                    catch (InstantiationException e) {
                        ValidationRegistryReader.getReader().disableValidator(vmd);
                        ValidationPlugin.getPlugin().handleException(e);
                        continue;
                    }
                    this.internalValidate(reporter, validator, vmd, this.context, delta);
                }
            }
            catch (OperationCanceledException exc) {
                this.handleOperationCancelledValidateException(reporter, validator, currentVmd, iterator, exc);
                this.releaseCachedMaps();
            }
        }
        finally {
            this.releaseCachedMaps();
        }
    }

    private void releaseCachedMaps() {
        ValidationRegistryReader.getReader().clearCachedMaps();
        IProjectValidationHelper helper = ValidationHelperRegistryReader.getInstance().getValidationHelper();
        if (helper != null) {
            helper.disposeInstance();
        }
    }

    private void initValidateContext(IFileDelta[] delta) {
        if (this.context instanceof WorkbenchContext) {
            ((WorkbenchContext)this.context).setValidationFileURIs(new ArrayList<String>());
            IFileDelta[] iFileDeltaArray = delta;
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                IFileDelta file = iFileDeltaArray[n2];
                if (file.getDeltaType() != 3) {
                    ((WorkbenchContext)this.context).getValidationFileURIs().add(file.getFileName());
                }
                ++n2;
            }
        }
    }

    private void handleOperationCancelledValidateException(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, Iterator<ValidatorMetaData> iterator, OperationCanceledException exc) {
        reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_CLEANUP", new String[]{vmd.getValidatorDisplayName()}));
        reporter.removeAllMessages(validator);
        this.addCancelTask(vmd);
        reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()}));
        while (iterator.hasNext()) {
            vmd = iterator.next();
            try {
                validator = vmd.getValidator();
            }
            catch (InstantiationException exc2) {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                ValidationPlugin.getPlugin().handleException(exc2);
                continue;
            }
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_CLEANUP", new String[]{vmd.getValidatorDisplayName()}));
            reporter.removeAllMessages(validator);
            this.addCancelTask(vmd);
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()}));
        }
        throw exc;
    }

    void internalValidate(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IWorkbenchContext aContext, IFileDelta[] delta) throws OperationCanceledException {
        try {
            try {
                ValidationOperation.checkCanceled(reporter);
                this.removeOldMessages(reporter, validator, vmd, delta);
                this.launchValidator(reporter, validator, vmd, aContext, delta);
            }
            catch (OperationCanceledException exc) {
                throw exc;
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
                String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(mssg);
                reporter.getProgressMonitor().done();
            }
        }
        finally {
            reporter.getProgressMonitor().done();
        }
    }

    private final void removeOldMessages(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IFileDelta[] delta) {
        if (reporter == null) {
            return;
        }
        InternalValidatorManager.getManager().removeOperationTasks(this.getProject(), vmd);
        ValidationOperation.checkCanceled(reporter);
        try {
            if (this.isFullValidate()) {
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_START_REMOVING_OLD_MESSAGES", new String[]{vmd.getValidatorDisplayName(), this.getProject().getName()});
                reporter.displaySubtask(message);
                reporter.removeAllMessages(validator);
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_FINISH_REMOVING_OLD_MESSAGES", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
            } else {
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_START_REMOVING_OLD_MESSAGES", new String[]{vmd.getValidatorDisplayName(), this.getProject().getName()});
                reporter.displaySubtask(message);
                int i = 0;
                while (i < delta.length) {
                    WorkbenchFileDelta fd = (WorkbenchFileDelta)delta[i];
                    if (fd.getDeltaType() != 3) {
                        IResource resource = reporter.getMessageResource(validator, fd);
                        if (fd.getObject().equals(fd.getResource())) {
                            WorkbenchReporter.removeAllMessages(resource, validator);
                        } else {
                            reporter.removeAllMessages(validator, fd.getObject());
                        }
                    }
                    ++i;
                }
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_FINISH_REMOVING_OLD_MESSAGES", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
            }
        }
        catch (OperationCanceledException exc) {
            throw exc;
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
            reporter.displaySubtask(mssg);
            return;
        }
    }

    private final void launchValidator(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IWorkbenchContext helper, IFileDelta[] delta) {
        block49: {
            if (reporter == null) {
                return;
            }
            ValidationOperation.checkCanceled(reporter);
            try {
                if (helper instanceof WorkbenchContext) {
                    ((WorkbenchContext)helper).setRuleGroup(this.getRuleGroup());
                }
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_STARTING_VALIDATION", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
                if (Tracing.isLogging()) {
                    this.getLaunchedValidators().add(vmd);
                }
                ValidatorLauncher.getLauncher().start(helper, validator, reporter);
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
            }
            catch (OperationCanceledException exc) {
                throw exc;
            }
            catch (ValidationException exc) {
                if (exc.getAssociatedException() != null && exc.getAssociatedException() instanceof ValidationException) {
                    ValidationException vexc = (ValidationException)exc.getAssociatedException();
                    vexc.setClassLoader(validator.getClass().getClassLoader());
                }
                exc.setClassLoader(validator.getClass().getClassLoader());
                ValidationPlugin.getPlugin().handleException(exc);
                ValidationPlugin.getPlugin().handleException(exc.getAssociatedException());
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
                if (exc.getAssociatedMessage() != null) {
                    reporter.addMessage(validator, exc.getAssociatedMessage());
                }
                try {
                    validator.cleanup(reporter);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    return;
                }
                try {
                    try {
                        helper.cleanup(reporter);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        ValidationPlugin.getPlugin().handleException(e);
                        helper.setProject(null);
                        return;
                    }
                }
                finally {
                    helper.setProject(null);
                }
                reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
                break block49;
            }
            catch (Exception e) {
                try {
                    ValidationPlugin.getPlugin().handleException(e);
                    String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                    reporter.displaySubtask(mssg);
                }
                catch (Throwable throwable) {
                    try {
                        validator.cleanup(reporter);
                    }
                    catch (OperationCanceledException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        ValidationPlugin.getPlugin().handleException(e3);
                        return;
                    }
                    try {
                        try {
                            helper.cleanup(reporter);
                        }
                        catch (OperationCanceledException e4) {
                            throw e4;
                        }
                        catch (Exception e5) {
                            ValidationPlugin.getPlugin().handleException(e5);
                            helper.setProject(null);
                            return;
                        }
                    }
                    finally {
                        helper.setProject(null);
                    }
                    reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
                    throw throwable;
                }
                try {
                    validator.cleanup(reporter);
                }
                catch (OperationCanceledException e6) {
                    throw e6;
                }
                catch (Exception e7) {
                    ValidationPlugin.getPlugin().handleException(e7);
                    return;
                }
                try {
                    try {
                        helper.cleanup(reporter);
                    }
                    catch (OperationCanceledException e8) {
                        throw e8;
                    }
                    catch (Exception e9) {
                        ValidationPlugin.getPlugin().handleException(e9);
                        helper.setProject(null);
                        return;
                    }
                }
                finally {
                    helper.setProject(null);
                }
                reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
                break block49;
            }
            try {
                validator.cleanup(reporter);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
                return;
            }
            try {
                try {
                    helper.cleanup(reporter);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    helper.setProject(null);
                    return;
                }
            }
            finally {
                helper.setProject(null);
            }
            reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
        }
    }

    public IValidationContext getContext() {
        return this.context;
    }

    public void setContext(IWorkbenchContext context) {
        this.context = context;
    }

    void launchJobs(Set<ValidatorMetaData> validators, WorkbenchReporter reporter) throws OperationCanceledException {
        IValidator validator = null;
        IFileDelta[] delta = null;
        IWorkbenchContext workbenchcontext = null;
        for (ValidatorMetaData vmd : validators) {
            String mssg;
            block14: {
                ValidationOperation.checkCanceled(reporter);
                try {
                    boolean willRun;
                    delta = this.getFileDeltas(reporter.getProgressMonitor(), vmd);
                    boolean bl = willRun = this.isForce() || this.isValidationNecessary(vmd, delta);
                    if (!willRun) {
                    }
                    break block14;
                }
                catch (CoreException e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                    reporter.displaySubtask(mssg);
                }
                continue;
            }
            try {
                validator = vmd.createValidator();
                workbenchcontext = vmd.createHelper(this.getProject());
                this.initValidateContext(delta, workbenchcontext);
                vmd.addHelper((IValidatorJob)validator, workbenchcontext);
                ValidationOperation.checkCanceled(reporter);
            }
            catch (InstantiationException e) {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                ValidationPlugin.getPlugin().handleException(e);
                continue;
            }
            try {
                ValidationOperation.checkCanceled(reporter);
                this.removeOldMessages(reporter, validator, vmd, delta);
                if (validator instanceof IValidatorJob) {
                    this.launchValidatorJob(reporter, (IValidatorJob)validator, vmd, workbenchcontext, delta);
                }
            }
            catch (OperationCanceledException exc) {
                throw exc;
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
                mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(mssg);
                reporter.getProgressMonitor().done();
                continue;
            }
            catch (Error e) {
                try {
                    ValidationPlugin.getPlugin().handleException(e);
                    mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                    reporter.displaySubtask(mssg);
                    throw e;
                }
                catch (Throwable throwable) {
                    reporter.getProgressMonitor().done();
                    throw throwable;
                }
            }
            reporter.getProgressMonitor().done();
        }
    }

    private void initValidateContext(IFileDelta[] delta, IWorkbenchContext context) {
        if (context instanceof WorkbenchContext) {
            ((WorkbenchContext)context).setValidationFileURIs(new ArrayList<String>());
            IFileDelta[] iFileDeltaArray = delta;
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                IFileDelta file = iFileDeltaArray[n2];
                if (file.getDeltaType() != 3) {
                    ((WorkbenchContext)context).getValidationFileURIs().add(file.getFileName());
                }
                ++n2;
            }
        }
    }

    private final void launchValidatorJob(WorkbenchReporter reporter, IValidatorJob validator, ValidatorMetaData vmd, IWorkbenchContext helper, IFileDelta[] delta) {
        if (reporter == null) {
            return;
        }
        ValidationOperation.checkCanceled(reporter);
        if (helper instanceof WorkbenchContext) {
            ((WorkbenchContext)helper).setRuleGroup(this.getRuleGroup());
        }
        if (Tracing.isLogging()) {
            this.getLaunchedValidators().add(vmd);
        }
        ValidatorJob validatorjob = new ValidatorJob(validator, vmd.getValidatorDisplayName(), vmd.getValidatorUniqueName(), helper.getProject(), helper);
        ISchedulingRule schedulingRule = validator.getSchedulingRule(helper);
        validatorjob.setRule(schedulingRule);
        QualifiedName validatorKey = new QualifiedName(null, "Validator");
        validatorjob.setProperty(validatorKey, validator);
        validatorjob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Job job = event.getJob();
                QualifiedName validatorKey = new QualifiedName(null, "Validator");
                IValidatorJob validator = (IValidatorJob)job.getProperty(validatorKey);
                ValidatorManager mgr = ValidatorManager.getManager();
                final List<MessageInfo> list = mgr.getMessages(validator);
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        for (MessageInfo info : list) {
                            try {
                                TaskListUtility.addTask(info.getMessageOwnerId(), info.getResource(), info.getLocation(), info.getMsg().getId(), info.getText(), info.getMsg().getSeverity(), info.getMarkerId(), info.getTargetObjectName(), info.getMsg().getGroupName(), info.getMsg().getOffset(), info.getMsg().getLength());
                            }
                            catch (CoreException e) {
                                ValidationPlugin.getPlugin().handleException(e);
                            }
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, null, 1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                mgr.clearMessages(validator);
                validator = null;
            }
        });
        validatorjob.setPriority(50);
        launcherJob.addValidationJob(validatorjob);
    }

    public class ProjectRunnable
    implements Runnable {
        private WorkbenchReporter _reporter;
        private IValidator _validator;
        private ValidatorMetaData _vmd;
        private IFileDelta[] _delta;

        public ProjectRunnable(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IWorkbenchContext helper, IFileDelta[] delta, Iterator iterator) {
            this._reporter = reporter;
            this._validator = validator;
            this._vmd = vmd;
            this._delta = delta;
        }

        public void run() {
            try {
                ValidationOperation.this.internalValidate(this._reporter, this._validator, this._vmd, ValidationOperation.this.context, this._delta);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }

        public IProject getProject() {
            return this._reporter.getProject();
        }
    }

    private static final class ValidationLauncherJob
    extends Job {
        private Queue<Job> _validationJobs = new LinkedList<Job>();

        public ValidationLauncherJob() {
            super(ResourceHandler.getExternalizedMessage("VBF_VALIDATION_JOB_MSG"));
            this.setSystem(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            int processors = Runtime.getRuntime().availableProcessors();
            int totalInitialJobs = processors * 3;
            Queue<Job> queue = this._validationJobs;
            synchronized (queue) {
                int i = 0;
                while (i < totalInitialJobs) {
                    Job validationJob = this._validationJobs.poll();
                    if (validationJob == null) break;
                    this.addJobChangeAdapter(validationJob);
                    validationJob.schedule();
                    ++i;
                }
            }
            return Status.OK_STATUS;
        }

        private void addJobChangeAdapter(Job job) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    Queue queue = ValidationLauncherJob.this._validationJobs;
                    synchronized (queue) {
                        Job validationJob = (Job)ValidationLauncherJob.this._validationJobs.poll();
                        if (validationJob != null) {
                            ValidationLauncherJob.this.addJobChangeAdapter(validationJob);
                            validationJob.schedule();
                        }
                    }
                }
            });
        }

        public boolean belongsTo(Object family) {
            if (family == ResourcesPlugin.FAMILY_MANUAL_BUILD) {
                return true;
            }
            if (family == ValidationBuilder.FAMILY_VALIDATION_JOB) {
                return true;
            }
            return super.belongsTo(family);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValidationJob(Job validationJob) {
            Queue<Job> queue = this._validationJobs;
            synchronized (queue) {
                this._validationJobs.add(validationJob);
                if (this._validationJobs.size() == 1) {
                    this.schedule();
                }
            }
        }
    }
}

