/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;

public class PreClientAssembleCommand
extends AbstractDataModelOperation {
    private IWebServiceClient webServiceClient_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;
    private IContext context_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        if (this.context_ != null && this.context_.getAssemble()) {
            IEnvironment environment = this.getEnvironment();
            if (this.earProject_ == null) {
                return Status.OK_STATUS;
            }
            CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
            command.setProjectName(this.earProject_);
            command.setTemplateId("template.jst.ear");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project_);
            command.setRequiredFacetVersions(FacetUtils.getRequiredEARFacetVersions((IProject)project));
            command.setServerFactoryId(this.webServiceClient_.getWebServiceClientInfo().getServerFactoryId());
            command.setServerInstanceId(this.webServiceClient_.getWebServiceClientInfo().getServerInstanceId());
            status = command.execute(monitor, adaptable);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
            associateCommand.setProject(this.project_);
            associateCommand.setModule(this.module_);
            associateCommand.setEARProject(this.earProject_);
            associateCommand.setEar(this.ear_);
            associateCommand.setEnvironment(environment);
            status = associateCommand.execute(monitor, adaptable);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
            }
        }
        return status;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setWebService(IWebServiceClient webServiceClient) {
        this.webServiceClient_ = webServiceClient;
    }

    public void setContext(IContext context) {
        this.context_ = context;
    }
}

