/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.internal.impl.ApplicationImpl;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.jee.application.ICommonApplication;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarUtilities
extends JavaEEProjectUtilities {
    public static IVirtualComponent getModule(IVirtualComponent earComponent, String moduleName) {
        if (earComponent == null || moduleName == null) {
            return null;
        }
        String innerModuleName = moduleName;
        if (innerModuleName.endsWith(".jar") || innerModuleName.endsWith(".war") || innerModuleName.endsWith(".rar")) {
            innerModuleName = innerModuleName.substring(0, innerModuleName.length() - ".jar".length());
        }
        IVirtualReference[] references = EarUtilities.getComponentReferences(earComponent);
        int i = 0;
        while (i < references.length) {
            IVirtualComponent component = references[i].getReferencedComponent();
            if (component.getName().equals(innerModuleName)) {
                return component;
            }
            ++i;
        }
        return null;
    }

    public static IVirtualReference[] getJ2EEModuleReferences(IVirtualComponent earComponent) {
        if (earComponent == null) {
            return NO_REFERENCES;
        }
        ArrayList<String> j2eeTypes = new ArrayList<String>();
        j2eeTypes.add("jst.appclient");
        j2eeTypes.add("jst.connector");
        j2eeTypes.add("jst.ejb");
        j2eeTypes.add("jst.web");
        IVirtualReference[] refs = EarUtilities.getComponentReferences(earComponent, j2eeTypes);
        String earLib = EarUtilities.getEARLibDir(earComponent);
        if (earLib == null) {
            return refs;
        }
        ArrayList<IVirtualReference> moduleRefs = new ArrayList<IVirtualReference>();
        IPath earLibPath = new Path(earLib).makeRelative();
        int i = 0;
        while (i < refs.length) {
            if (earLibPath.isEmpty() || !refs[i].getRuntimePath().makeRelative().equals((Object)earLibPath)) {
                moduleRefs.add(refs[i]);
            }
            ++i;
        }
        return moduleRefs.toArray(new IVirtualReference[moduleRefs.size()]);
    }

    public static IVirtualReference[] getComponentReferences(IVirtualComponent earComponent) {
        if (earComponent == null) {
            return NO_REFERENCES;
        }
        return EarUtilities.getComponentReferences(earComponent, Collections.EMPTY_LIST);
    }

    public static IVirtualReference getComponentReference(IVirtualComponent earComponent, String componentName) {
        if (earComponent == null || componentName == null) {
            return null;
        }
        IVirtualReference[] refs = EarUtilities.getComponentReferences(earComponent, Collections.EMPTY_LIST);
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            if (reference.getReferencedComponent().getName().equals(componentName)) {
                return reference;
            }
            ++i;
        }
        return null;
    }

    private static IVirtualReference[] getComponentReferences(IVirtualComponent earComponent, List componentTypes) {
        List components = EarUtilities.getComponentReferencesAsList(earComponent, componentTypes);
        if (components.size() > 0) {
            return components.toArray(new IVirtualReference[components.size()]);
        }
        return NO_REFERENCES;
    }

    private static List getComponentReferencesAsList(IVirtualComponent earComponent, List componentTypes) {
        return EarUtilities.getComponentReferencesAsList(earComponent, componentTypes, false);
    }

    private static List getComponentReferencesAsList(IVirtualComponent earComponent, List componentTypes, boolean expandLibraries) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        if (earComponent != null && EarUtilities.isEARProject(earComponent.getProject())) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            if (expandLibraries) {
                options.put(J2EEModuleVirtualComponent.GET_EXPANDED_LIB_REFS, Boolean.TRUE);
            }
            IVirtualReference[] refComponents = earComponent.getReferences(options);
            int i = 0;
            while (i < refComponents.length) {
                IVirtualReference reference = refComponents[i];
                IVirtualComponent module = reference.getReferencedComponent();
                if (module != null) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(reference);
                    } else if (componentTypes.contains(EarUtilities.getJ2EEComponentType(module))) {
                        components.add(reference);
                    }
                }
                ++i;
            }
        }
        return components;
    }

    public static boolean uriExists(String currentURI, IProject earProject) {
        if (currentURI == null || earProject == null) {
            return false;
        }
        StructureEdit edit = null;
        try {
            edit = StructureEdit.getStructureEditForRead((IProject)earProject);
            if (edit != null && edit.getComponent() != null) {
                EList referencedComps = edit.getComponent().getReferencedComponents();
                int i = 0;
                while (i < referencedComps.size()) {
                    String existingURI;
                    ReferencedComponent ref = (ReferencedComponent)referencedComps.get(i);
                    EObject module = ref.getDependentObject();
                    if (module != null && module instanceof org.eclipse.jst.j2ee.application.Module && (existingURI = ((org.eclipse.jst.j2ee.application.Module)module).getUri()) != null && existingURI.equals(currentURI)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return false;
    }

    public static IProject[] getReferencingEARProjects(IProject project) {
        if (project == null) {
            return new IProject[0];
        }
        if (EarUtilities.isEARProject(project)) {
            return new IProject[]{project};
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualComponent[] refComponents = component.getReferencingComponents();
            int i = 0;
            while (i < refComponents.length) {
                if (EarUtilities.isEARProject(refComponents[i].getProject())) {
                    result.add(refComponents[i].getProject());
                }
                ++i;
            }
        }
        IProject[] earProjects = result.toArray(new IProject[result.size()]);
        Arrays.sort(earProjects, new Comparator<IProject>(){

            @Override
            public int compare(IProject p0, IProject p1) {
                return p0.getName().compareTo(p1.getName());
            }
        });
        return earProjects;
    }

    public static boolean isStandaloneProject(IProject project) {
        return EarUtilities.getReferencingEARProjects(project).length == 0;
    }

    public static IVirtualReference[] getUtilityModuleReferences(IVirtualComponent earComponent) {
        return EarUtilities.getUtilityModuleReferences(earComponent, false);
    }

    public static IVirtualReference[] getUtilityModuleReferences(IVirtualComponent earComponent, boolean expandLibraries) {
        if (earComponent != null && EarUtilities.isEARProject(earComponent.getProject())) {
            List explicitUtilityReferences = EarUtilities.getComponentReferencesAsList(earComponent, Collections.singletonList("jst.utility"), expandLibraries);
            List<String> implicitUtilityReferenceTypes = Arrays.asList("jst.appclient", "jst.web", "jst.ejb");
            List implicitUtilityReferences = EarUtilities.getComponentReferencesAsList(earComponent, implicitUtilityReferenceTypes, expandLibraries);
            IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider(earComponent.getProject());
            ICommonApplication application = (ICommonApplication)earModel.getModelObject();
            Module module = null;
            IVirtualReference reference = null;
            Iterator referenceItr = implicitUtilityReferences.iterator();
            while (referenceItr.hasNext()) {
                module = null;
                reference = (IVirtualReference)referenceItr.next();
                if (application instanceof org.eclipse.jst.javaee.application.internal.impl.ApplicationImpl) {
                    module = ((org.eclipse.jst.javaee.application.internal.impl.ApplicationImpl)application).getFirstModule(reference.getArchiveName());
                } else if (application instanceof ApplicationImpl) {
                    module = ((ApplicationImpl)application).getFirstModule(reference.getArchiveName());
                }
                if (module == null) continue;
                referenceItr.remove();
            }
            ArrayList allUtilityModuleReferences = new ArrayList();
            allUtilityModuleReferences.addAll(explicitUtilityReferences);
            allUtilityModuleReferences.addAll(implicitUtilityReferences);
            if (allUtilityModuleReferences.size() > 0) {
                return allUtilityModuleReferences.toArray(new IVirtualReference[allUtilityModuleReferences.size()]);
            }
        }
        return NO_REFERENCES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<IProjectFacetVersion> getSupportedFacets(IProjectFacetVersion earProjectFacetVersion, IProjectFacet moduleProjectFacet) {
        ArrayList<IProjectFacetVersion> retVal = new ArrayList<IProjectFacetVersion>();
        if (earProjectFacetVersion != null && "jst.ear".equals(earProjectFacetVersion.getProjectFacet().getId())) {
            String moduleProjectFacetId = moduleProjectFacet.getId();
            int earVersion = J2EEVersionUtil.convertVersionStringToInt(earProjectFacetVersion.getVersionString());
            if ("jst.web".equals(moduleProjectFacetId)) {
                switch (earVersion) {
                    case 60: {
                        retVal.add(DYNAMIC_WEB_30);
                    }
                    case 50: {
                        retVal.add(DYNAMIC_WEB_25);
                    }
                    case 14: {
                        retVal.add(DYNAMIC_WEB_24);
                    }
                    case 13: {
                        retVal.add(DYNAMIC_WEB_23);
                    }
                    case 12: {
                        retVal.add(DYNAMIC_WEB_22);
                    }
                }
                return retVal;
            } else if ("jst.ejb".equals(moduleProjectFacetId)) {
                switch (earVersion) {
                    case 60: {
                        retVal.add(EJB_31);
                    }
                    case 50: {
                        retVal.add(EJB_30);
                    }
                    case 14: {
                        retVal.add(EJB_21);
                    }
                    case 13: {
                        retVal.add(EJB_20);
                    }
                    case 12: {
                        retVal.add(EJB_11);
                    }
                }
                return retVal;
            } else if ("jst.connector".equals(moduleProjectFacetId)) {
                switch (earVersion) {
                    case 60: {
                        retVal.add(JCA_16);
                    }
                    case 14: 
                    case 50: {
                        retVal.add(JCA_15);
                    }
                    case 13: {
                        retVal.add(JCA_10);
                    }
                }
                return retVal;
            } else if ("jst.appclient".equals(moduleProjectFacetId)) {
                switch (earVersion) {
                    case 60: {
                        retVal.add(APPLICATION_CLIENT_60);
                    }
                    case 50: {
                        retVal.add(APPLICATION_CLIENT_50);
                    }
                    case 14: {
                        retVal.add(APPLICATION_CLIENT_14);
                    }
                    case 13: {
                        retVal.add(APPLICATION_CLIENT_13);
                    }
                    case 12: {
                        retVal.add(APPLICATION_CLIENT_12);
                    }
                }
                return retVal;
            } else {
                if (!"jst.utility".equals(moduleProjectFacetId)) throw new IllegalArgumentException("The moduleProjectFacet parameter must be a valid Java EE module type.");
                retVal.add(UTILITY_FACET_10);
            }
            return retVal;
        } else {
            if (earProjectFacetVersion != null) throw new IllegalArgumentException("The earProjectFacetVersion parameter must be an ENTERPRISE_APPLICATION facet.");
            throw new IllegalArgumentException("The earProjectFacetVersion parameter cannot be null");
        }
    }

    public static String getEARLibDir(IVirtualComponent earComponent) {
        if (earComponent == null) {
            return null;
        }
        IProject earProject = earComponent.getProject();
        if (!JavaEEProjectUtilities.isJEEComponent(earComponent, 1) || !JavaEEProjectUtilities.isJEEComponent(earComponent, 0)) {
            return null;
        }
        String libDir = new Path("/lib").makeRelative().toString();
        IModelProvider modelProvider = ModelProviderManager.getModelProvider(earProject);
        if (modelProvider == null) {
            return libDir;
        }
        Object o = modelProvider.getModelObject((IPath)new Path("META-INF/application.xml"));
        Application app = null;
        if (o instanceof Application) {
            app = (Application)o;
        }
        if (app == null) {
            return libDir;
        }
        String ddLibDir = app.getLibraryDirectory();
        if (ddLibDir != null) {
            libDir = ddLibDir;
        }
        return libDir;
    }
}

