/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.jpa2.context.IdMapping2_0;
import org.eclipse.jpt.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.core.resource.java.IdAnnotation;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaIdMapping
extends AbstractJavaAttributeMapping<IdAnnotation>
implements JavaIdMapping,
IdMapping2_0 {
    protected final JavaColumn column = this.getJpaFactory().buildJavaColumn(this, this);
    protected boolean mappedByRelationship;
    protected JavaGeneratedValue generatedValue;
    protected final JavaGeneratorContainer generatorContainer = this.buildGeneratorContainer();
    protected JavaConverter converter = this.nullConverter = this.getJpaFactory().buildJavaNullConverter(this);
    protected final JavaConverter nullConverter;

    protected AbstractJavaIdMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.column.initialize(this.getResourceColumn());
        this.mappedByRelationship = this.calculateMappedByRelationship();
        this.generatorContainer.initialize(this.getResourcePersistentAttribute());
        this.initializeGeneratedValue();
        this.converter = this.buildConverter(this.getResourceConverterType());
    }

    protected void initializeGeneratedValue() {
        GeneratedValueAnnotation resourceGeneratedValue = this.getResourceGeneratedValue();
        if (resourceGeneratedValue != null) {
            this.generatedValue = this.buildGeneratedValue(resourceGeneratedValue);
        }
    }

    public ColumnAnnotation getResourceColumn() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    protected boolean isColumnSpecified() {
        return this.getResourcePersistentAttribute().getAnnotation("javax.persistence.Column") != null;
    }

    private JavaGeneratorContainer buildGeneratorContainer() {
        return this.getJpaFactory().buildJavaGeneratorContainer(this);
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Id";
    }

    @Override
    protected void addSupportingAnnotationNamesTo(Vector<String> names) {
        super.addSupportingAnnotationNamesTo(names);
        names.add("javax.persistence.Column");
        names.add("javax.persistence.GeneratedValue");
        names.add("javax.persistence.Temporal");
        names.add("javax.persistence.TableGenerator");
        names.add("javax.persistence.SequenceGenerator");
    }

    @Override
    public String getDefaultColumnName() {
        return this.isMappedByRelationship() && !this.isColumnSpecified() ? null : this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.isMappedByRelationship() && !this.isColumnSpecified() ? null : this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getTypeMapping().associatedTableNamesIncludingInherited();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public JavaGeneratedValue addGeneratedValue() {
        if (this.getGeneratedValue() != null) {
            throw new IllegalStateException("gemeratedValue already exists");
        }
        this.generatedValue = this.getJpaFactory().buildJavaGeneratedValue(this);
        GeneratedValueAnnotation generatedValueResource = (GeneratedValueAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.GeneratedValue");
        this.generatedValue.initialize(generatedValueResource);
        this.firePropertyChanged("generatedValue", null, this.generatedValue);
        return this.generatedValue;
    }

    @Override
    public void removeGeneratedValue() {
        if (this.getGeneratedValue() == null) {
            throw new IllegalStateException("gemeratedValue does not exist, cannot be removed");
        }
        JavaGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = null;
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.GeneratedValue");
        this.firePropertyChanged("generatedValue", oldGeneratedValue, null);
    }

    @Override
    public JavaGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    protected void setGeneratedValue(JavaGeneratedValue newGeneratedValue) {
        JavaGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = newGeneratedValue;
        this.firePropertyChanged("generatedValue", oldGeneratedValue, newGeneratedValue);
    }

    @Override
    public JavaGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    @Override
    public JavaConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.valuesAreEqual(this.getConverterType(), converterType)) {
            return;
        }
        JavaConverter oldConverter = this.converter;
        JavaConverter newConverter = this.buildConverter(converterType);
        this.converter = this.nullConverter;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.converter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(JavaConverter newConverter) {
        JavaConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    @Override
    protected void update() {
        super.update();
        this.column.update(this.getResourceColumn());
        this.setMappedByRelationship(this.calculateMappedByRelationship());
        this.generatorContainer.update(this.getResourcePersistentAttribute());
        this.updateGeneratedValue();
        if (this.valuesAreEqual(this.getResourceConverterType(), this.getConverterType())) {
            this.getConverter().update(this.getResourcePersistentAttribute());
        } else {
            JavaConverter javaConverter = this.buildConverter(this.getResourceConverterType());
            this.setConverter(javaConverter);
        }
    }

    protected void updateGeneratedValue() {
        GeneratedValueAnnotation resourceGeneratedValue = this.getResourceGeneratedValue();
        if (resourceGeneratedValue == null) {
            if (this.getGeneratedValue() != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.getGeneratedValue() == null) {
            this.setGeneratedValue(this.buildGeneratedValue(resourceGeneratedValue));
        } else {
            this.getGeneratedValue().update(resourceGeneratedValue);
        }
    }

    protected JavaGeneratedValue buildGeneratedValue(GeneratedValueAnnotation resourceGeneratedValue) {
        JavaGeneratedValue gv = this.getJpaFactory().buildJavaGeneratedValue(this);
        gv.initialize(resourceGeneratedValue);
        return gv;
    }

    protected TableGeneratorAnnotation getResourceTableGenerator() {
        return (TableGeneratorAnnotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.TableGenerator");
    }

    protected SequenceGeneratorAnnotation getResourceSequenceGenerator() {
        return (SequenceGeneratorAnnotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.SequenceGenerator");
    }

    protected GeneratedValueAnnotation getResourceGeneratedValue() {
        return (GeneratedValueAnnotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.GeneratedValue");
    }

    protected JavaConverter buildConverter(String converterType) {
        if (this.valuesAreEqual(converterType, "noConverter")) {
            return this.nullConverter;
        }
        if (this.valuesAreEqual(converterType, "temporalConverter")) {
            return this.getJpaFactory().buildJavaTemporalConverter(this, this.getResourcePersistentAttribute());
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (this.getResourcePersistentAttribute().getAnnotation("javax.persistence.Temporal") != null) {
            return "temporalConverter";
        }
        return "noConverter";
    }

    @Override
    public boolean isMappedByRelationship() {
        return this.mappedByRelationship;
    }

    protected void setMappedByRelationship(boolean newValue) {
        boolean oldValue = this.mappedByRelationship;
        this.mappedByRelationship = newValue;
        this.firePropertyChanged("mappedByRelationship", oldValue, newValue);
    }

    protected boolean calculateMappedByRelationship() {
        for (SingleRelationshipMapping2_0 each : this.getMapsIdRelationships()) {
            if (!this.getName().equals(each.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getValue())) continue;
            return true;
        }
        return false;
    }

    protected Iterable<SingleRelationshipMapping2_0> getMapsIdRelationships() {
        return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{this.getTypeMapping().getAllAttributeMappings("oneToOne"), this.getTypeMapping().getAllAttributeMappings("manyToOne")}))){

            protected boolean accept(SingleRelationshipMapping2_0 o) {
                return o.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
            }
        };
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.generatorTouches(pos, astRoot) && (result = this.persistenceGeneratorNames(filter)) != null) {
            return result;
        }
        result = this.getGeneratorContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getConverter().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    protected boolean generatorTouches(int pos, CompilationUnit astRoot) {
        if (this.getResourceGeneratedValue() != null) {
            return this.getResourceGeneratedValue().generatorTouches(pos, astRoot);
        }
        return false;
    }

    protected Iterator<String> persistenceGeneratorNames() {
        if (this.getPersistenceUnit().generatorsSize() == 0) {
            return EmptyIterator.instance();
        }
        return CollectionTools.iterator((Object[])this.getPersistenceUnit().uniqueGeneratorNames());
    }

    private Iterator<String> generatorNames(Filter<String> filter) {
        return new FilteringIterator(this.persistenceGeneratorNames(), filter);
    }

    protected Iterator<String> persistenceGeneratorNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.generatorNames(filter));
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getColumn().getName();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.isColumnSpecified() || !this.isMappedByRelationship()) {
            this.getColumn().validate(messages, reporter, astRoot);
        }
        if (this.isColumnSpecified() && this.isMappedByRelationship()) {
            messages.add(this.buildMessage("ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_COLUMN_SPECIFIED", new String[0], this.getColumn().getValidationTextRange(astRoot)));
        }
        if (this.getGeneratedValue() != null) {
            this.getGeneratedValue().validate(messages, reporter, astRoot);
        }
        this.getGeneratorContainer().validate(messages, reporter, astRoot);
        this.getConverter().validate(messages, reporter, astRoot);
    }

    @Override
    public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }

    @Override
    public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
    }

    protected IMessage buildMessage(String msgID, String[] params, TextRange textRange) {
        JavaPersistentAttribute attribute = this.getPersistentAttribute();
        String attributeDesc = NLS.bind((String)JpaValidationDescriptionMessages.ATTRIBUTE_DESC, (Object)attribute.getName());
        return DefaultJpaValidationMessages.buildMessage(1, msgID, (String[])ArrayTools.add((Object[])params, (int)0, (Object)attributeDesc), this, textRange);
    }
}

