/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaGeneratorContainer
extends AbstractJavaJpaContextNode
implements JavaGeneratorContainer {
    protected JavaResourcePersistentMember javaResourcePersistentMember;
    protected JavaSequenceGenerator sequenceGenerator;
    protected JavaTableGenerator tableGenerator;

    public GenericJavaGeneratorContainer(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    @Override
    public JavaTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        this.tableGenerator = this.getJpaFactory().buildJavaTableGenerator(this);
        TableGeneratorAnnotation tableGeneratorResource = (TableGeneratorAnnotation)this.javaResourcePersistentMember.addAnnotation("javax.persistence.TableGenerator");
        this.tableGenerator.initialize(tableGeneratorResource);
        this.firePropertyChanged("tableGenerator", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        this.javaResourcePersistentMember.removeAnnotation("javax.persistence.TableGenerator");
        this.firePropertyChanged("tableGenerator", oldTableGenerator, null);
    }

    @Override
    public JavaTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(JavaTableGenerator newTableGenerator) {
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGenerator", oldTableGenerator, newTableGenerator);
    }

    @Override
    public JavaSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        this.sequenceGenerator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        SequenceGeneratorAnnotation sequenceGeneratorResource = (SequenceGeneratorAnnotation)this.javaResourcePersistentMember.addAnnotation("javax.persistence.SequenceGenerator");
        this.sequenceGenerator.initialize(sequenceGeneratorResource);
        this.firePropertyChanged("sequenceGenerator", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        this.javaResourcePersistentMember.removeAnnotation("javax.persistence.SequenceGenerator");
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, null);
    }

    @Override
    public JavaSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(JavaSequenceGenerator newSequenceGenerator) {
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public void initialize(JavaResourcePersistentMember jrpm) {
        this.javaResourcePersistentMember = jrpm;
        this.initializeTableGenerator();
        this.initializeSequenceGenerator();
    }

    protected void initializeTableGenerator() {
        TableGeneratorAnnotation tableGeneratorResource = this.getResourceTableGenerator();
        if (tableGeneratorResource != null) {
            this.tableGenerator = this.buildTableGenerator(tableGeneratorResource);
        }
    }

    protected void initializeSequenceGenerator() {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.getResourceSequenceGenerator();
        if (sequenceGeneratorResource != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(sequenceGeneratorResource);
        }
    }

    @Override
    public void update(JavaResourcePersistentMember jrpm) {
        this.javaResourcePersistentMember = jrpm;
        this.updateTableGenerator();
        this.updateSequenceGenerator();
    }

    protected void updateTableGenerator() {
        TableGeneratorAnnotation tableGeneratorResource = this.getResourceTableGenerator();
        if (tableGeneratorResource == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(tableGeneratorResource));
        } else {
            this.getTableGenerator().update(tableGeneratorResource);
        }
    }

    protected JavaTableGenerator buildTableGenerator(TableGeneratorAnnotation tableGeneratorResource) {
        JavaTableGenerator generator = this.getJpaFactory().buildJavaTableGenerator(this);
        generator.initialize(tableGeneratorResource);
        return generator;
    }

    protected TableGeneratorAnnotation getResourceTableGenerator() {
        return (TableGeneratorAnnotation)this.javaResourcePersistentMember.getAnnotation("javax.persistence.TableGenerator");
    }

    protected void updateSequenceGenerator() {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.getResourceSequenceGenerator();
        if (sequenceGeneratorResource == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(sequenceGeneratorResource));
        } else {
            this.getSequenceGenerator().update(sequenceGeneratorResource);
        }
    }

    protected JavaSequenceGenerator buildSequenceGenerator(SequenceGeneratorAnnotation sequenceGeneratorResource) {
        JavaSequenceGenerator generator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        generator.initialize(sequenceGeneratorResource);
        return generator;
    }

    protected SequenceGeneratorAnnotation getResourceSequenceGenerator() {
        return (SequenceGeneratorAnnotation)this.javaResourcePersistentMember.getAnnotation("javax.persistence.SequenceGenerator");
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.getTableGenerator() != null && (result = this.getTableGenerator().javaCompletionProposals(pos, filter, astRoot)) != null) {
            return result;
        }
        if (this.getSequenceGenerator() != null && (result = this.getSequenceGenerator().javaCompletionProposals(pos, filter, astRoot)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateGenerators(messages, astRoot);
    }

    protected void validateGenerators(List<IMessage> messages, CompilationUnit astRoot) {
        Iterator<JavaGenerator> localGenerators = this.generators();
        while (localGenerators.hasNext()) {
            JavaGenerator localGenerator = localGenerators.next();
            ListIterator<Generator> globalGenerators = this.getPersistenceUnit().generators();
            while (globalGenerators.hasNext()) {
                if (!localGenerator.duplicates((Generator)globalGenerators.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{localGenerator.getName()}, localGenerator, localGenerator.getNameTextRange(astRoot)));
            }
        }
    }

    protected final Iterator<JavaGenerator> generators() {
        ArrayList<JavaGenerator> generators = new ArrayList<JavaGenerator>();
        this.addGeneratorsTo(generators);
        return generators.iterator();
    }

    protected void addGeneratorsTo(ArrayList<JavaGenerator> generators) {
        if (this.sequenceGenerator != null) {
            generators.add(this.sequenceGenerator);
        }
        if (this.tableGenerator != null) {
            generators.add(this.tableGenerator);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.javaResourcePersistentMember.getTextRange(astRoot);
    }
}

