/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.gen.internal.Association;
import org.eclipse.jpt.gen.internal.AssociationRole;
import org.eclipse.jpt.gen.internal.ORMGenColumn;
import org.eclipse.jpt.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.ui.internal.ImageRepository;
import org.eclipse.jpt.ui.internal.wizards.gen.AssociationsListComposite;
import org.eclipse.jpt.ui.internal.wizards.gen.CascadeDialog;
import org.eclipse.jpt.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.ui.internal.wizards.gen.NewAssociationWizard;
import org.eclipse.jpt.ui.internal.wizards.gen.SWTUtil;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class TableAssociationsWizardPage
extends WizardPage {
    private JpaProject jpaProject;
    private ORMGenCustomizer customizer;
    private AssociationsListComposite associationList;
    private Association selectedAssociation;
    private Button deleteAssociationLink;
    private Button createAssociationLink;
    private Composite associationsEditPanel;
    private Button generateAssociationCheckBox;
    private Label cardinalityLabel;
    private Combo cardinalityCombo;
    private Button referrerRoleCheckBox;
    private Label referrerRolePropertyLabel;
    private Text referrerRolePropertyField;
    private StringButtonDialogField referrerRoleCascadeField;
    private Button referencedRoleCheckBox;
    private Label referencedRolePropertyLabel;
    private Text referencedRolePropertyField;
    private StringButtonDialogField referencedRoleCascadeField;
    private Label joinConditionLabel;
    private Text joinConditionText;
    private Composite detailPanel;
    private StackLayout detailPanelStatckLayout;
    private Composite emptyPanel;
    protected final ResourceManager resourceManager;

    protected TableAssociationsWizardPage(JpaProject jpaProject, ResourceManager resourceManager) {
        super("Table Associations");
        this.jpaProject = jpaProject;
        this.resourceManager = resourceManager;
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_assocPage_title);
        this.setMessage(JptUiEntityGenMessages.GenerateEntitiesWizard_assocPage_desc);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 2;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.dialog_tableAssociationsPage");
        Label label = new Label(composite, 0);
        label.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_assocPage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createAssociationsListPanel(composite);
        this.createAddDeleteButtons(composite, nColumns);
        SWTUtil.createSeparator(composite, nColumns);
        this.createDetailPanel(composite);
        this.setControl((Control)composite);
        composite.layout(true);
        this.setPageComplete(true);
    }

    private void createAddDeleteButtons(Composite composite, int columns) {
        Composite c = new Composite(composite, 0);
        SWTUtil.fillColumns((Control)c, 1);
        c.setLayout((Layout)new GridLayout(1, true));
        this.createAssociationLink = new Button(c, 0);
        this.createAssociationLink.setToolTipText(JptUiEntityGenMessages.GenerateEntitiesWizard_assocPage_newAssoc);
        this.createAssociationLink.setImage(ImageRepository.getAddButtonImage(this.resourceManager));
        this.createAssociationLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableAssociationsWizardPage.this.launchNewAssociationsWizard();
            }
        });
        this.deleteAssociationLink = new Button(c, 0);
        Color foreground = new Color((Device)Display.getDefault(), 0, 0, 255);
        this.deleteAssociationLink.setForeground(foreground);
        foreground.dispose();
        this.deleteAssociationLink.setImage(ImageRepository.getDeleteButtonImage(this.resourceManager));
        this.deleteAssociationLink.setToolTipText(JptUiEntityGenMessages.GenerateEntitiesWizard_assocPage_delAssoc);
        this.deleteAssociationLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Association association = TableAssociationsWizardPage.this.associationList.getSelectedAssociation();
                if (association != null) {
                    ORMGenCustomizer customizer = TableAssociationsWizardPage.this.getCustomizer();
                    customizer.deleteAssociation(association);
                    List associations = customizer.getAssociations();
                    TableAssociationsWizardPage.this.associationList.updateAssociations(associations);
                    if (associations.size() == 0) {
                        TableAssociationsWizardPage.this.hideAssociationDetail();
                    }
                }
            }
        });
        this.deleteAssociationLink.setEnabled(false);
    }

    private void createGenerateAssociationCheckbox(Composite composite, int columns) {
        this.generateAssociationCheckBox = new Button(composite, 32);
        this.generateAssociationCheckBox.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_genAssoc);
        this.generateAssociationCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Association association = TableAssociationsWizardPage.this.associationList.getSelectedAssociation();
                if (association == null) {
                    return;
                }
                association.setGenerated(TableAssociationsWizardPage.this.generateAssociationCheckBox.getSelection());
                TableAssociationsWizardPage.this.updateAssociationEditPanel(association);
                TableAssociationsWizardPage.this.associationList.updateSelectedAssociation();
            }
        });
        SWTUtil.fillColumns((Control)this.generateAssociationCheckBox, columns - 1);
        SWTUtil.newLabel(composite, "");
    }

    private void createGenerateReferrerRoleControls(Composite parent, int columns) {
        this.referrerRoleCheckBox = new Button(parent, 32);
        this.referrerRoleCheckBox.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_entityRef);
        this.referrerRoleCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean generate = TableAssociationsWizardPage.this.referrerRoleCheckBox.getSelection();
                TableAssociationsWizardPage.this.referrerRolePropertyLabel.setEnabled(generate);
                TableAssociationsWizardPage.this.referrerRolePropertyField.setEnabled(generate);
                TableAssociationsWizardPage.this.referrerRoleCascadeField.setEnabled(generate);
                if (!generate && !TableAssociationsWizardPage.this.referencedRoleCheckBox.getSelection()) {
                    TableAssociationsWizardPage.this.generateAssociationCheckBox.setSelection(false);
                    TableAssociationsWizardPage.this.cardinalityLabel.setEnabled(false);
                    TableAssociationsWizardPage.this.cardinalityCombo.setEnabled(false);
                    TableAssociationsWizardPage.this.referrerRoleCheckBox.setEnabled(false);
                    TableAssociationsWizardPage.this.referencedRoleCheckBox.setEnabled(false);
                }
                TableAssociationsWizardPage.this.directionalityCheckBoxChanged();
                if (generate) {
                    AssociationRole role = TableAssociationsWizardPage.this.selectedAssociation.getReferrerRole();
                    TableAssociationsWizardPage.this.referrerRolePropertyField.setText(role.getPropertyName());
                }
            }
        });
        SWTUtil.fillColumnsWithIndent((Control)this.referrerRoleCheckBox, columns - 1, 20);
        SWTUtil.newLabel(parent, "");
        this.referrerRolePropertyLabel = SWTUtil.newLabelWithIndent(parent, JptUiEntityGenMessages.property, 40);
        this.referrerRolePropertyField = new Text(parent, 2048);
        SWTUtil.fillColumns((Control)this.referrerRolePropertyField, 2);
        this.referrerRolePropertyField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableAssociationsWizardPage.this.selectedAssociation.getReferrerRole() == null) {
                    return;
                }
                String fieldName = TableAssociationsWizardPage.this.referrerRolePropertyField.getText();
                IStatus status = JavaConventions.validateFieldName((String)fieldName);
                if (!status.matches(4)) {
                    TableAssociationsWizardPage.this.selectedAssociation.getReferrerRole().setPropertyName(fieldName);
                }
                TableAssociationsWizardPage.this.updateStatus(status);
            }
        });
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(512));
        this.referrerRoleCascadeField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                if (TableAssociationsWizardPage.this.editCascade(TableAssociationsWizardPage.this.selectedAssociation.getReferrerRole())) {
                    TableAssociationsWizardPage.this.referrerRoleCascadeField.setText(TableAssociationsWizardPage.this.selectedAssociation.getReferrerRole().getCascade());
                }
            }
        });
        this.referrerRoleCascadeField.setLabelText(JptUiEntityGenMessages.cascade);
        this.referrerRoleCascadeField.setButtonLabel("");
        this.referrerRoleCascadeField.doFillIntoGrid(parent, 3);
        this.referrerRoleCascadeField.getTextControl(parent).setEditable(false);
        int maxFieldWidth = this.convertWidthInCharsToPixels(40);
        LayoutUtil.setWidthHint((Control)this.referrerRoleCascadeField.getTextControl(null), (int)maxFieldWidth);
        Button btn = this.referrerRoleCascadeField.getChangeControl(null);
        GridData data = (GridData)btn.getLayoutData();
        btn.setImage(ImageRepository.getBrowseButtonImage(this.resourceManager));
        data.horizontalAlignment = 1;
        data.widthHint = 30;
        btn.setLayoutData((Object)data);
        Label labelCtrl = this.referrerRoleCascadeField.getLabelControl(parent);
        data = (GridData)labelCtrl.getLayoutData();
        data.horizontalIndent = 40;
        labelCtrl.setLayoutData((Object)data);
        label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(512));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.hideAssociationDetail();
            this.updateAssociationsListPanel();
        }
    }

    private void hideAssociationDetail() {
        this.detailPanelStatckLayout.topControl = this.emptyPanel;
        this.detailPanel.layout();
        this.detailPanel.getParent().layout();
    }

    protected void updateStatus(IStatus status) {
        this.setPageComplete(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
        if (status.getCode() == 0) {
            this.setMessage(JptUiEntityGenMessages.GenerateEntitiesWizard_assocPage_desc);
        }
    }

    private void createGenerateReferencedRoleControls(Composite parent, int columns) {
        this.referencedRoleCheckBox = new Button(parent, 32);
        this.referencedRoleCheckBox.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_setRef);
        this.referencedRoleCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean generate = TableAssociationsWizardPage.this.referencedRoleCheckBox.getSelection();
                TableAssociationsWizardPage.this.referencedRolePropertyLabel.setEnabled(generate);
                TableAssociationsWizardPage.this.referencedRolePropertyField.setEnabled(generate);
                TableAssociationsWizardPage.this.referencedRoleCascadeField.setEnabled(generate);
                if (!generate && !TableAssociationsWizardPage.this.referrerRoleCheckBox.getSelection()) {
                    TableAssociationsWizardPage.this.generateAssociationCheckBox.setSelection(false);
                    TableAssociationsWizardPage.this.cardinalityCombo.setEnabled(false);
                    TableAssociationsWizardPage.this.referrerRoleCheckBox.setEnabled(false);
                    TableAssociationsWizardPage.this.referencedRoleCheckBox.setEnabled(false);
                }
                TableAssociationsWizardPage.this.directionalityCheckBoxChanged();
                if (generate) {
                    AssociationRole role = TableAssociationsWizardPage.this.selectedAssociation.getReferencedRole();
                    TableAssociationsWizardPage.this.referencedRolePropertyField.setText(role.getPropertyName());
                }
            }
        });
        SWTUtil.fillColumnsWithIndent((Control)this.referencedRoleCheckBox, columns - 1, 20);
        SWTUtil.newLabel(parent, "");
        this.referencedRolePropertyLabel = SWTUtil.newLabelWithIndent(parent, JptUiEntityGenMessages.property, 40);
        this.referencedRolePropertyField = new Text(parent, 2048);
        SWTUtil.fillColumns((Control)this.referencedRolePropertyField, 2);
        this.referencedRolePropertyField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableAssociationsWizardPage.this.selectedAssociation.getReferencedRole() == null) {
                    return;
                }
                String fieldName = TableAssociationsWizardPage.this.referencedRolePropertyField.getText();
                IStatus status = JavaConventions.validateIdentifier((String)fieldName, (String)"1.3", (String)"1.3");
                if (!status.matches(4) && !fieldName.equals(TableAssociationsWizardPage.this.selectedAssociation.getReferencedRole().getPropertyName())) {
                    TableAssociationsWizardPage.this.selectedAssociation.getReferencedRole().setPropertyName(fieldName);
                }
                TableAssociationsWizardPage.this.updateStatus(status);
            }
        });
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(512));
        this.referencedRoleCascadeField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                if (TableAssociationsWizardPage.this.editCascade(TableAssociationsWizardPage.this.selectedAssociation.getReferencedRole())) {
                    TableAssociationsWizardPage.this.referencedRoleCascadeField.setText(TableAssociationsWizardPage.this.selectedAssociation.getReferencedRole().getCascade());
                }
            }
        });
        this.referencedRoleCascadeField.setLabelText(JptUiEntityGenMessages.cascade);
        this.referencedRoleCascadeField.setButtonLabel("");
        this.referencedRoleCascadeField.doFillIntoGrid(parent, 3);
        this.referencedRoleCascadeField.getTextControl(parent).setEditable(false);
        int maxFieldWidth = this.convertWidthInCharsToPixels(40);
        LayoutUtil.setWidthHint((Control)this.referencedRoleCascadeField.getTextControl(null), (int)maxFieldWidth);
        Button btn = this.referencedRoleCascadeField.getChangeControl(null);
        btn.setImage(ImageRepository.getBrowseButtonImage(this.resourceManager));
        GridData data = (GridData)btn.getLayoutData();
        data.horizontalAlignment = 1;
        data.widthHint = 30;
        btn.setLayoutData((Object)data);
        Label labelCtrl = this.referencedRoleCascadeField.getLabelControl(parent);
        data = (GridData)labelCtrl.getLayoutData();
        data.horizontalIndent = 40;
        labelCtrl.setLayoutData((Object)data);
        label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(512));
    }

    private void createDetailPanel(Composite composite) {
        this.detailPanel = new Composite(composite, 0);
        GridData gd = new GridData(768);
        gd.grabExcessVerticalSpace = false;
        this.detailPanel.setLayoutData((Object)gd);
        this.detailPanelStatckLayout = new StackLayout();
        this.detailPanel.setLayout((Layout)this.detailPanelStatckLayout);
        this.emptyPanel = new Composite(this.detailPanel, 0);
        this.emptyPanel.setLayoutData((Object)new GridData());
        this.detailPanelStatckLayout.topControl = this.emptyPanel;
        this.detailPanel.layout();
        composite.layout();
    }

    private Composite createAssociationsEditPanel(Composite composite, int columns) {
        Composite parent = new Composite(composite, 0);
        SWTUtil.fillColumns((Control)parent, 4);
        this.createGenerateAssociationCheckbox(parent, columns);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        parent.setLayout((Layout)layout);
        this.cardinalityLabel = new Label(parent, 0);
        this.cardinalityLabel.setText(JptUiEntityGenMessages.cardinality);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.cardinalityLabel.setLayoutData((Object)gd);
        this.cardinalityCombo = new Combo(parent, 12);
        SWTUtil.fillColumns((Control)this.cardinalityCombo, 1);
        this.cardinalityCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableAssociationsWizardPage.this.selectedAssociation.setCardinality(TableAssociationsWizardPage.this.cardinalityCombo.getText());
                TableAssociationsWizardPage.this.associationList.updateSelectedAssociation();
            }
        });
        Label label = new Label(parent, 0);
        label.setText("");
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)layoutData);
        this.joinConditionLabel = SWTUtil.newLabelWithIndent(parent, JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_tableJoin, 20);
        this.joinConditionText = new Text(parent, 2050);
        this.joinConditionText.setEditable(false);
        this.joinConditionText.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_joinedWhen);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.verticalAlignment = 128;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.heightHint = 50;
        this.joinConditionText.setLayoutData((Object)layoutData);
        SWTUtil.newLabel(parent, "");
        this.createGenerateReferrerRoleControls(parent, columns);
        this.createGenerateReferencedRoleControls(parent, columns);
        return parent;
    }

    public boolean editCascade(AssociationRole role) {
        CascadeDialog dlg = CascadeDialog.create(role);
        return dlg.open() != 1;
    }

    private void createAssociationsListPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Color backgroundColor = new Color((Device)Display.getDefault(), 255, 0, 0);
        composite.setBackground(backgroundColor);
        backgroundColor.dispose();
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 1;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = false;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.widthHint = 400;
        layoutData.heightHint = 400;
        composite.setLayoutData((Object)layoutData);
        this.associationList = new AssociationsListComposite(composite, this, this.resourceManager);
    }

    private void launchNewAssociationsWizard() {
        Association association;
        ORMGenCustomizer customizer = this.getCustomizer();
        NewAssociationWizard wizard = new NewAssociationWizard(this.jpaProject, customizer, this.resourceManager);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode == 0 && (association = wizard.getNewAssociation()) != null) {
            customizer.addAssociation(association);
            this.updateForeignKeyColumnGenProperty(association);
            this.updateAssociationsListPanel();
        }
    }

    private void updateForeignKeyColumnGenProperty(Association association) {
        if (association.isCustom() && association.getCardinality().equals("many-to-one")) {
            boolean generateColumn = !association.isGenerated();
            List list1 = association.getReferrerColumns();
            for (ORMGenColumn c : list1) {
                if (c.isGenerated() == generateColumn || !generateColumn && c.getDbColumn().isPartOfPrimaryKey()) continue;
                c.setGenerated(generateColumn);
                c.setInsertable(generateColumn);
                c.setUpdateable(generateColumn);
            }
        }
    }

    private void updateAssociationsListPanel() {
        ORMGenCustomizer customizer = this.getCustomizer();
        if (this.customizer != customizer) {
            this.customizer = customizer;
        }
        List associations = customizer.getAssociations();
        this.associationList.updateAssociations(associations);
    }

    public void updateAssociationEditPanel(Association association) {
        AssociationRole referencedRole;
        this.selectedAssociation = association;
        boolean enabled = association.isCustom();
        this.deleteAssociationLink.setEnabled(enabled);
        if (this.associationsEditPanel == null) {
            this.associationsEditPanel = this.createAssociationsEditPanel(this.detailPanel, 4);
        }
        this.detailPanelStatckLayout.topControl = this.associationsEditPanel;
        this.detailPanel.layout();
        this.detailPanel.getParent().layout();
        String table1Name = association.getReferrerTableName();
        String table2Name = association.getReferencedTableName();
        String joinTableName = association.getJoinTableName();
        boolean isGenerated = association.isGenerated();
        this.generateAssociationCheckBox.setSelection(isGenerated);
        this.referrerRolePropertyLabel.setEnabled(isGenerated);
        this.referrerRolePropertyField.setEnabled(isGenerated);
        this.referrerRoleCheckBox.setEnabled(isGenerated);
        this.referencedRolePropertyLabel.setEnabled(isGenerated);
        this.referencedRolePropertyField.setEnabled(isGenerated);
        this.referencedRoleCheckBox.setEnabled(isGenerated);
        this.cardinalityLabel.setEnabled(isGenerated);
        this.cardinalityCombo.setEnabled(isGenerated);
        this.joinConditionLabel.setEnabled(isGenerated);
        this.joinConditionText.setEnabled(isGenerated);
        String cardinality = association.getCardinality();
        if ("many-to-many".equals(cardinality)) {
            this.cardinalityCombo.removeAll();
            this.cardinalityCombo.add("many-to-many");
        } else {
            this.cardinalityCombo.removeAll();
            this.cardinalityCombo.add("many-to-one");
            this.cardinalityCombo.add("one-to-one");
        }
        this.cardinalityCombo.setText(cardinality);
        this.cardinalityCombo.setEnabled(enabled);
        String text = null;
        text = "many-to-many".equals(cardinality) ? String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_setRef, table2Name, table1Name) : String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_entityRef, table2Name, table1Name);
        this.referrerRoleCheckBox.setText(text);
        text = "one-to-one".equals(cardinality) ? String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_entityRef, table1Name, table2Name) : String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_assocEditor_setRef, table1Name, table2Name);
        this.referencedRoleCheckBox.setText(text);
        AssociationRole referrerRole = association.getReferrerRole();
        if (referrerRole != null) {
            this.referrerRoleCheckBox.setSelection(true);
            this.referrerRolePropertyField.setEditable(true);
            this.referrerRolePropertyField.setText(referrerRole.getPropertyName());
            this.referrerRoleCascadeField.setEnabled(true);
            String cascade = referrerRole.getCascade();
            if (cascade != null) {
                this.referrerRoleCascadeField.setText(cascade);
            }
            if ("many-to-one".equals(cardinality)) {
                this.referrerRoleCheckBox.setEnabled(false);
            }
        } else {
            this.referrerRoleCheckBox.setSelection(false);
            this.referrerRolePropertyLabel.setEnabled(false);
            this.referrerRolePropertyField.setEditable(false);
            this.referrerRolePropertyField.setText("");
            this.referrerRoleCascadeField.setEnabled(false);
        }
        if ((referencedRole = association.getReferencedRole()) != null) {
            this.referencedRoleCheckBox.setSelection(true);
            this.referencedRolePropertyLabel.setEnabled(true);
            this.referencedRolePropertyField.setEditable(true);
            this.referencedRolePropertyField.setText(referencedRole.getPropertyName());
            this.referencedRoleCascadeField.setEnabled(true);
            String cascade = referencedRole.getCascade();
            if (cascade != null) {
                this.referencedRoleCascadeField.setText(cascade);
            }
        } else {
            this.referencedRoleCheckBox.setSelection(false);
            this.referencedRolePropertyLabel.setEnabled(false);
            this.referencedRolePropertyField.setEditable(false);
            this.referencedRolePropertyField.setText("");
            this.referencedRoleCascadeField.setEnabled(false);
        }
        this.updateJoinConditions(association, table1Name, table2Name, joinTableName);
    }

    private void updateJoinConditions(Association association, String table1Name, String table2Name, String joinTableName) {
        String text = "%s";
        if (joinTableName == null) {
            StringBuilder strText = new StringBuilder();
            List columnList1 = association.getReferrerColumnNames();
            List columnList2 = association.getReferencedColumnNames();
            int i = 0;
            while (i < columnList1.size()) {
                strText.append(String.valueOf(table1Name) + "." + (String)columnList1.get(i));
                strText.append("=");
                strText.append(String.valueOf(table2Name) + "." + (String)columnList2.get(i));
                if (i < columnList1.size() - 1) {
                    strText.append("\n AND ");
                }
                ++i;
            }
            this.joinConditionText.setText(String.format(text, strText.toString()));
        } else {
            StringBuilder strText = new StringBuilder();
            List columnList1 = association.getReferrerColumnNames();
            List joinColumnList1 = association.getReferrerJoinColumnNames();
            int i = 0;
            while (i < columnList1.size()) {
                strText.append(String.valueOf(table1Name) + "." + (String)columnList1.get(i));
                strText.append("=");
                strText.append(String.valueOf(joinTableName) + "." + (String)joinColumnList1.get(i));
                strText.append("\n AND ");
                ++i;
            }
            List joinTableColumnList2 = association.getReferencedJoinColumnNames();
            List columnList2 = association.getReferencedColumnNames();
            int i2 = 0;
            while (i2 < joinTableColumnList2.size()) {
                strText.append(String.valueOf(joinTableName) + "." + (String)joinTableColumnList2.get(i2));
                strText.append("=");
                strText.append(String.valueOf(table2Name) + "." + (String)columnList2.get(i2));
                if (i2 < joinTableColumnList2.size() - 1) {
                    strText.append("\n AND ");
                }
                ++i2;
            }
            this.joinConditionText.setText(String.format(text, strText.toString()));
        }
    }

    private void directionalityCheckBoxChanged() {
        String dir = this.referrerRoleCheckBox.getSelection() ? (this.referencedRoleCheckBox.getSelection() ? "bi-di" : "normal-di") : (this.referencedRoleCheckBox.getSelection() ? "opposite-di" : null);
        if (dir != null) {
            this.selectedAssociation.setDirectionality(dir);
        } else {
            this.selectedAssociation.setGenerated(false);
        }
        this.associationList.updateSelectedAssociation();
    }

    private ORMGenCustomizer getCustomizer() {
        GenerateEntitiesFromSchemaWizard wizard = (GenerateEntitiesFromSchemaWizard)this.getWizard();
        return wizard.getCustomizer();
    }

    public final void performHelp() {
        this.getHelpSystem().displayHelp("org.eclipse.jpt.ui.GenerateEntitiesFromSchemaWizard");
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    public void dispose() {
        if (this.associationList != null) {
            this.associationList.dispose();
        }
        super.dispose();
    }
}

