/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.sse.ui.contentassist.StructuredContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationPresenter;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;

public class XMLStructuredContentAssistProcessor
extends StructuredContentAssistProcessor {
    private char[] fCompletionProposalAutoActivationCharacters;
    private IContextInformationValidator fContextInformationValidator;

    public XMLStructuredContentAssistProcessor(ContentAssistant assistant, String partitionTypeID, ITextViewer viewer) {
        super(assistant, partitionTypeID, viewer, XMLUIPlugin.getDefault().getPreferenceStore());
        this.getAutoActivationCharacterPreferences();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fContextInformationValidator == null) {
            this.fContextInformationValidator = new AttributeContextInformationPresenter();
        }
        return this.fContextInformationValidator;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return super.getCompletionProposalAutoActivationCharacters() != null ? super.getCompletionProposalAutoActivationCharacters() : this.fCompletionProposalAutoActivationCharacters;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(XMLUIPreferenceNames.AUTO_PROPOSE) || event.getProperty().equals(XMLUIPreferenceNames.AUTO_PROPOSE_CODE)) {
            this.getAutoActivationCharacterPreferences();
        }
    }

    protected void getAutoActivationCharacterPreferences() {
        String key = XMLUIPreferenceNames.AUTO_PROPOSE;
        boolean doAuto = this.getPreferenceStore().getBoolean(key);
        if (doAuto) {
            key = XMLUIPreferenceNames.AUTO_PROPOSE_CODE;
            this.fCompletionProposalAutoActivationCharacters = this.getPreferenceStore().getString(key).toCharArray();
        } else {
            this.fCompletionProposalAutoActivationCharacters = null;
        }
    }
}

