/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EJBClientManifestUtility {
    public static final String NESTED_MODEL_UPDATE_MAINFEST = "AbstractJARDependencyDataModel.NESTED_MODEL_UPDATE_MAINFEST";
    public static final int JAR_MANIPULATION_ADD = 0;
    public static final int JAR_MANIPULATION_REMOVE = 1;
    public static final int JAR_MANIPULATION_INVERT = 2;
    private ClassPathSelection classPathSelection;
    private ArchiveManifest manifest;
    private IProject project;
    private IProject earProject;
    private IProject referencedProject;
    private IProject oppositeProject;
    private List jarList;

    public UpdateManifestOperation getAddOperation(IProject project, IProject ear, List jars) {
        return this.handle(0, project, ear, jars);
    }

    public UpdateManifestOperation getRemoveOperation(IProject project, IProject ear, List jars, IProject referenced) {
        return this.handle(1, project, ear, jars, null, referenced);
    }

    public UpdateManifestOperation getInvertOperation(IProject project, IProject ear, IProject opposite, IProject referenced) {
        return this.handle(2, project, ear, null, opposite, referenced);
    }

    private UpdateManifestOperation handle(int type, IProject project, IProject ear, List jars) {
        return this.handle(type, project, ear, jars, null, null);
    }

    private UpdateManifestOperation handle(int type, IProject project, IProject ear, List jars, IProject opposite, IProject referenced) {
        this.project = project;
        this.earProject = ear;
        this.jarList = jars;
        this.oppositeProject = opposite;
        this.referencedProject = referenced;
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)this.earProject);
        if (!earComponent.exists()) {
            return null;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        this.manifest = ManifestUtilities.getNonBinaryComponentManifest((IVirtualComponent)component, (IPath)new Path("META-INF/MANIFEST.MF"));
        this.classPathSelection = new ClassPathSelection(component, earComponent, this.manifest);
        switch (type) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleInvert();
            }
        }
        try {
            this.validateEdit();
            UpdateManifestOperation mfOperation = this.createManifestOperation();
            return mfOperation;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void validateEdit() throws CoreException {
        Set affectedFiles = this.getAffectedFiles(this.project);
        IFile[] files = affectedFiles.toArray(new IFile[affectedFiles.size()]);
        IStatus result = J2EEPlugin.getWorkspace().validateEdit(files, null);
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    public Set getAffectedFiles(IProject project) {
        HashSet<IFile> result = new HashSet<IFile>();
        IFile aFile = J2EEProjectUtilities.getManifestFile((IProject)project);
        if (aFile != null && aFile.exists()) {
            result.add(aFile);
        }
        result.addAll(ProjectUtilities.getFilesAffectedByClasspathChange((IProject)project));
        return result;
    }

    private UpdateManifestOperation createManifestOperation() {
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)this.project.getName());
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)UpdateManifestDataModelProvider.convertClasspathStringToList((String)this.classPathSelection.toString()));
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)J2EEProjectUtilities.getManifestFile((IProject)this.project));
        return new UpdateManifestOperation(updateManifestDataModel);
    }

    protected void handleAdd() {
        if (!this.jarList.isEmpty()) {
            int i = 0;
            while (i < this.jarList.size()) {
                String jarName = (String)this.jarList.get(i);
                this.selectDependencyIfNecessary(jarName);
                ++i;
            }
        }
    }

    protected void handleRemove() {
        if (!this.jarList.isEmpty()) {
            int i = 0;
            while (i < this.jarList.size()) {
                String jarName = (String)this.jarList.get(i);
                this.removeDependency(jarName);
                ++i;
            }
        }
    }

    protected void handleInvert() {
        this.classPathSelection.invertClientJARSelection(this.referencedProject, this.oppositeProject);
    }

    protected void setSelection(ClasspathElement element, boolean val) {
        element.setSelected(val);
        this.manifest.setClassPath(this.classPathSelection.toString());
    }

    public boolean selectDependencyIfNecessary(IProject referencedProject) {
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(referencedProject)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public boolean selectDependencyIfNecessary(String jarName) {
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(jarName)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public void removeDependency(String jarName) {
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }

    public void removeDependency(IProject referencedProject) {
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }
}

