/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.jpa.core.resource.orm.XmlIdClassContainer;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmIdClassReference
extends AbstractXmlContextNode
implements OrmIdClassReference {
    protected final OrmIdClassReference.Owner owner;
    protected String specifiedIdClassName;
    protected String defaultIdClassName;
    protected JavaPersistentType idClass;

    public GenericOrmIdClassReference(OrmTypeMapping parent, OrmIdClassReference.Owner owner) {
        super(parent);
        this.owner = owner;
        this.specifiedIdClassName = this.buildSpecifiedIdClassName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedIdClassName_(this.buildSpecifiedIdClassName());
        this.syncIdClass();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultIdClassName(this.buildDefaultIdClassName());
        this.updateIdClass();
    }

    @Override
    public String getIdClassName() {
        return this.specifiedIdClassName != null ? this.specifiedIdClassName : this.defaultIdClassName;
    }

    @Override
    public String getSpecifiedIdClassName() {
        return this.specifiedIdClassName;
    }

    @Override
    public void setSpecifiedIdClassName(String name) {
        if (this.valuesAreDifferent(this.specifiedIdClassName, name)) {
            XmlClassReference xmlClassRef = this.getXmlIdClassRefForUpdate();
            this.setSpecifiedIdClassName_(name);
            xmlClassRef.setClassName(name);
            this.removeXmlIdClassRefIfUnset();
        }
    }

    protected void setSpecifiedIdClassName_(String name) {
        String old = this.specifiedIdClassName;
        this.specifiedIdClassName = name;
        if (this.firePropertyChanged("specifiedIdClassName", old, name) && this.idClass != null) {
            this.idClass.dispose();
            this.setIdClass(null);
        }
    }

    protected String buildSpecifiedIdClassName() {
        XmlClassReference xmlIdClassRef = this.getXmlIdClassRef();
        return xmlIdClassRef == null ? null : xmlIdClassRef.getClassName();
    }

    @Override
    public String getDefaultIdClassName() {
        return this.defaultIdClassName;
    }

    protected void setDefaultIdClassName(String name) {
        String old = this.defaultIdClassName;
        this.defaultIdClassName = name;
        this.firePropertyChanged("defaultIdClassName", old, name);
    }

    protected String buildDefaultIdClassName() {
        JavaIdClassReference javaRef = this.owner.getJavaIdClassReferenceForDefaults();
        return javaRef == null ? null : javaRef.getFullyQualifiedIdClassName();
    }

    @Override
    public boolean isSpecified() {
        return this.getIdClassName() != null;
    }

    protected XmlClassReference getXmlIdClassRef() {
        return this.getXmlIdClassContainer().getIdClass();
    }

    protected XmlClassReference getXmlIdClassRefForUpdate() {
        XmlClassReference xmlClassRef = this.getXmlIdClassRef();
        return xmlClassRef != null ? xmlClassRef : this.buildXmlIdClassRef();
    }

    protected XmlClassReference buildXmlIdClassRef() {
        XmlClassReference ref = OrmFactory.eINSTANCE.createXmlClassReference();
        this.getXmlIdClassContainer().setIdClass(ref);
        return ref;
    }

    protected void removeXmlIdClassRefIfUnset() {
        if (this.getXmlIdClassRef().isUnset()) {
            this.removeXmlIdClassRef();
        }
    }

    protected void removeXmlIdClassRef() {
        this.getXmlIdClassContainer().setIdClass(null);
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClass;
    }

    protected void setIdClass(JavaPersistentType idClass) {
        JavaPersistentType old = this.idClass;
        this.idClass = idClass;
        this.firePropertyChanged("idClass", old, idClass);
    }

    protected void syncIdClass() {
        if (this.idClass != null) {
            this.idClass.synchronizeWithResourceModel();
        }
    }

    protected void updateIdClass() {
        JavaResourcePersistentType resourceIdClass = this.resolveJavaResourceIdClass();
        if (resourceIdClass == null) {
            if (this.idClass != null) {
                this.idClass.dispose();
                this.setIdClass(null);
            }
        } else if (this.idClass == null) {
            this.setIdClass(this.buildIdClass(resourceIdClass));
        } else if (this.idClass.getResourcePersistentType() == resourceIdClass) {
            this.idClass.update();
        } else {
            this.idClass.dispose();
            this.setIdClass(this.buildIdClass(resourceIdClass));
        }
    }

    protected JavaResourcePersistentType resolveJavaResourceIdClass() {
        String idClassName = this.getIdClassName();
        if (idClassName == null) {
            return null;
        }
        JavaResourcePersistentType jrpt = this.getEntityMappings().resolveJavaResourcePersistentType(idClassName);
        return jrpt == null ? null : (jrpt.isMapped() ? null : jrpt);
    }

    protected JavaPersistentType buildIdClass(JavaResourcePersistentType resourceIdClass) {
        return this.getJpaFactory().buildJavaPersistentType(this, resourceIdClass);
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public OrmTypeMapping getParent() {
        return (OrmTypeMapping)super.getParent();
    }

    protected OrmTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected OrmPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected XmlIdClassContainer getXmlIdClassContainer() {
        return this.owner.getXmlIdClassContainer();
    }

    protected EntityMappings getEntityMappings() {
        return (EntityMappings)this.getMappingFileRoot();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameEdit(IType originalType, String newName) {
        return this.getXmlIdClassRef().createRenameEdit(originalType, newName);
    }

    protected boolean isFor(String typeName) {
        return this.idClass != null && this.idClass.isFor(typeName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.isIn(originalPackage) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.getXmlIdClassRef().createRenamePackageEdit(newName);
    }

    protected boolean isIn(IPackageFragment originalPackage) {
        return this.idClass != null && this.idClass.isIn(originalPackage);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateIdClass(messages, reporter);
    }

    protected void validateIdClass(List<IMessage> messages, IReporter reporter) {
        if (this.isSpecified()) {
            JavaResourcePersistentType jrpt = this.getEntityMappings().resolveJavaResourcePersistentType(this.getIdClassName());
            if (jrpt != null && jrpt.isMapped()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_NOT_VALID", EMPTY_STRING_ARRAY, this, this.getValidationTextRange()));
            } else if (StringTools.stringIsEmpty((String)this.getIdClassName())) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_NAME_EMPTY", EMPTY_STRING_ARRAY, this, this.getValidationTextRange()));
            } else if (!this.idClassExists()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_NOT_EXIST", EMPTY_STRING_ARRAY, this, this.getValidationTextRange()));
            }
        }
    }

    protected boolean idClassExists() {
        boolean idClassExists;
        IJavaProject javaProject = this.getJpaProject().getJavaProject();
        boolean bl = idClassExists = JDTTools.findType((IJavaProject)javaProject, (String)this.getIdClassName()) != null;
        if (idClassExists) {
            return true;
        }
        if (this.getEntityMappings().getPackage() != null) {
            String fullyQualifiedIdClassName = String.valueOf(this.getEntityMappings().getPackage()) + '.' + this.getIdClassName();
            idClassExists = JDTTools.findType((IJavaProject)javaProject, (String)fullyQualifiedIdClassName) != null;
        }
        return idClassExists;
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        XmlClassReference xmlIdClassRef = this.getXmlIdClassRef();
        return xmlIdClassRef == null ? null : xmlIdClassRef.getClassNameTextRange();
    }
}

