/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.jpa.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceAnnotation<A extends AnnotatedElement>
extends SourceNode
implements org.eclipse.jpt.jpa.core.resource.java.Annotation {
    protected final A annotatedElement;
    protected DeclarationAnnotationAdapter daa;
    protected AnnotationAdapter annotationAdapter;

    protected SourceAnnotation(JavaResourceNode parent, A annotatedElement, DeclarationAnnotationAdapter daa) {
        this(parent, annotatedElement, daa, (AnnotationAdapter)new ElementAnnotationAdapter(annotatedElement, daa));
    }

    protected SourceAnnotation(JavaResourceNode parent, A annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent);
        this.annotatedElement = annotatedElement;
        this.daa = daa;
        this.annotationAdapter = annotationAdapter;
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.getAnnotationTextRange(astRoot);
    }

    @Override
    public Annotation getAstAnnotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    public void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    @Override
    public void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    @Override
    public boolean isUnset() {
        return true;
    }

    @Override
    public JavaResourceAnnotatedElement getParent() {
        return (JavaResourceAnnotatedElement)super.getParent();
    }

    protected IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    protected DeclarationAnnotationElementAdapter<String> buildStringElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)elementName);
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildBooleanElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)this.daa, (String)elementName);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildIntegerElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)this.daa, (String)elementName);
    }

    protected AnnotationElementAdapter<String> buildStringElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Boolean> buildBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Integer> buildIntegerElementAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return astRoot == null ? null : this.getTextRange((ASTNode)this.getAstAnnotation(astRoot));
    }

    protected TextRange getElementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.getElementTextRange(this.getAnnotationElementTextRange(elementAdapter, astRoot), astRoot);
    }

    protected TextRange getElementTextRange(TextRange elementTextRange, CompilationUnit astRoot) {
        return elementTextRange != null ? elementTextRange : this.getAnnotationTextRange(astRoot);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.textRangeTouches(this.getAnnotationElementTextRange(elementAdapter, astRoot), pos);
    }

    protected boolean textRangeTouches(TextRange textRange, int pos) {
        return textRange != null && textRange.touches(pos);
    }

    protected TextRange getAnnotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return astRoot == null ? null : this.getTextRange((ASTNode)this.getAnnotationElementExpression(adapter, astRoot));
    }

    protected Expression getAnnotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.getExpression(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    protected TextRange getTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    public void convertToNested(ContainerAnnotation<? extends NestableAnnotation> containerAnnotation, DeclarationAnnotationAdapter containerAnnotationAdapter, int index) {
        Map<String, Object> map = this.buildState();
        this.removeAnnotation();
        IndexedDeclarationAnnotationAdapter idaa = this.buildNestedDeclarationAnnotationAdapter(containerAnnotationAdapter, index);
        this.daa = idaa;
        this.annotationAdapter = new ElementIndexedAnnotationAdapter(this.annotatedElement, idaa);
        this.rebuildAdapters();
        containerAnnotation.addNestedAnnotation(index, (NestableAnnotation)((Object)this));
        this.newAnnotation();
        this.restoreFrom(map);
    }

    public void convertToStandAlone() {
        Map<String, Object> map = this.buildState();
        this.removeAnnotation();
        this.daa = new SimpleDeclarationAnnotationAdapter(this.getAnnotationName());
        this.annotationAdapter = new ElementAnnotationAdapter(this.annotatedElement, this.daa);
        this.rebuildAdapters();
        this.getParent().addStandAloneAnnotation((NestableAnnotation)((Object)this));
        this.newAnnotation();
        this.restoreFrom(map);
    }

    private Map<String, Object> buildState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.storeOn(map);
        return map;
    }

    protected void rebuildAdapters() {
    }

    @Override
    public void storeOn(Map<String, Object> map) {
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
    }

    protected List<Map<String, Object>> buildStateList(int initialCapacity) {
        return initialCapacity == 0 ? Collections.emptyList() : new ArrayList(initialCapacity);
    }

    protected IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(DeclarationAnnotationAdapter containerAnnotationAdapter, int index) {
        return SourceAnnotation.buildNestedDeclarationAnnotationAdapter(index, containerAnnotationAdapter, this.getAnnotationName());
    }

    protected static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter containerAnnotationAdapter, String annotationName) {
        return new NestedIndexedDeclarationAnnotationAdapter(containerAnnotationAdapter, index, annotationName);
    }
}

