/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmTemporalConverter;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.AbstractOrmConverter;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.AbstractOrmElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmTemporalConverter
extends AbstractOrmConverter
implements OrmTemporalConverter {
    protected TemporalType temporalType = this.buildTemporalType();

    public GenericOrmTemporalConverter(OrmAttributeMapping parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setTemporalType_(this.buildTemporalType());
    }

    @Override
    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    @Override
    public void setTemporalType(TemporalType temporalType) {
        this.setTemporalType_(temporalType);
        this.setXmlTemporal(temporalType);
    }

    protected void setTemporalType_(TemporalType temporalType) {
        TemporalType old = this.temporalType;
        this.temporalType = temporalType;
        this.firePropertyChanged("temporalType", (Object)old, (Object)temporalType);
    }

    protected void setXmlTemporal(TemporalType temporalType) {
        this.getXmlConvertibleMapping().setTemporal(TemporalType.toOrmResourceModel(temporalType));
    }

    protected TemporalType buildTemporalType() {
        return TemporalType.fromOrmResourceModel(this.getXmlConvertibleMapping().getTemporal());
    }

    @Override
    public Class<? extends Converter> getType() {
        return TemporalConverter.class;
    }

    @Override
    public void initialize() {
        this.temporalType = TemporalType.DATE;
        this.setXmlTemporal(this.temporalType);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttributeTypeWithTemporal(messages);
    }

    protected void validateAttributeTypeWithTemporal(List<IMessage> messages) {
        if (this.getAttributeMapping().getKey() == "elementCollection") {
            String typeName = ((AbstractOrmElementCollectionMapping2_0)this.getAttributeMapping()).getTargetClass();
            if (!ArrayTools.contains((Object[])TEMPORAL_MAPPING_SUPPORTED_TYPES, (Object)typeName)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_ELEMENT_COLLECTION_INVALID_VALUE_TYPE", EMPTY_STRING_ARRAY, this, this.getValidationTextRange()));
            }
        } else {
            String typeName = this.getAttributeMapping().getPersistentAttribute().getTypeName();
            if (!ArrayTools.contains((Object[])TEMPORAL_MAPPING_SUPPORTED_TYPES, (Object)typeName)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_TEMPORAL_MAPPING_TYPE", EMPTY_STRING_ARRAY, this, this.getValidationTextRange()));
            }
        }
    }

    @Override
    protected TextRange getXmlValidationTextRange() {
        return this.getXmlConvertibleMapping().getTemporalTextRange();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return EmptyIterable.instance();
    }
}

