/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.Persistence2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceXml2_0;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceXml
extends AbstractPersistenceXmlContextNode
implements PersistenceXml2_0 {
    protected final JpaXmlResource xmlResource;
    protected JptResourceType resourceType;
    protected Persistence persistence;

    public GenericPersistenceXml(JpaRootContextNode parent, JpaXmlResource xmlResource) {
        super(parent);
        this.checkXmlResource(xmlResource);
        this.xmlResource = xmlResource;
        this.resourceType = xmlResource.getResourceType();
        XmlPersistence xmlPersistence = (XmlPersistence)xmlResource.getRootObject();
        if (xmlPersistence != null) {
            this.persistence = this.buildPersistence(xmlPersistence);
        }
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        XmlPersistence oldXmlPersistence = this.persistence == null ? null : this.persistence.getXmlPersistence();
        XmlPersistence newXmlPersistence = (XmlPersistence)this.xmlResource.getRootObject();
        JptResourceType newResourceType = this.xmlResource.getResourceType();
        if ((oldXmlPersistence != newXmlPersistence || newXmlPersistence == null || this.valuesAreDifferent(this.resourceType, newResourceType)) && this.persistence != null) {
            this.unregisterRootStructureNode();
            this.persistence.dispose();
            this.setPersistence(null);
        }
        this.resourceType = newResourceType;
        if (newXmlPersistence != null) {
            if (this.persistence == null) {
                this.setPersistence(this.buildPersistence(newXmlPersistence));
            } else {
                this.persistence.synchronizeWithResourceModel();
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.persistence != null) {
            this.persistence.update();
            this.registerRootStructureNode();
        }
    }

    @Override
    public Persistence getPersistence() {
        return this.persistence;
    }

    protected void setPersistence(Persistence persistence) {
        Persistence old = this.persistence;
        this.persistence = persistence;
        this.firePropertyChanged("persistence", old, persistence);
    }

    protected Persistence buildPersistence(XmlPersistence xmlPersistence) {
        return this.getContextNodeFactory().buildPersistence(this, xmlPersistence);
    }

    protected void checkXmlResource(JpaXmlResource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        if (!resource.getContentType().isKindOf(JptJpaCorePlugin.PERSISTENCE_XML_CONTENT_TYPE)) {
            throw new IllegalArgumentException("Content type is not 'persistence': " + (Object)((Object)resource));
        }
    }

    @Override
    public JpaXmlResource getXmlResource() {
        return this.xmlResource;
    }

    @Override
    public IResource getResource() {
        return this.xmlResource.getFile();
    }

    @Override
    public JptResourceType getResourceType() {
        return this.xmlResource.getResourceType();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.xmlResource.getFile());
    }

    @Override
    public void initializeMetamodel() {
        if (this.persistence != null) {
            ((Persistence2_0)this.persistence).initializeMetamodel();
        }
    }

    @Override
    public void synchronizeMetamodel() {
        if (this.persistence != null) {
            ((Persistence2_0)this.persistence).synchronizeMetamodel();
        }
    }

    @Override
    public void disposeMetamodel() {
        if (this.persistence != null) {
            ((Persistence2_0)this.persistence).disposeMetamodel();
        }
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.persistence.containsOffset(textOffset)) {
            return this.persistence.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void dispose() {
        if (this.persistence != null) {
            JpaFile jpaFile = this.getJpaFile();
            if (jpaFile != null) {
                this.unregisterRootStructureNode();
            }
            this.persistence.dispose();
        }
    }

    protected void registerRootStructureNode() {
        this.getJpaFile().addRootStructureNode((Object)this.xmlResource, this.persistence);
    }

    protected void unregisterRootStructureNode() {
        this.getJpaFile().removeRootStructureNode((Object)this.xmlResource, this.persistence);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.persistence == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_XML_INVALID_CONTENT", this));
            return;
        }
        this.persistence.validate(messages, reporter);
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }
}

