/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.jpa.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceAnnotatedElement<A extends AnnotatedElement>
extends SourceNode
implements JavaResourceAnnotatedElement {
    final A annotatedElement;
    final Vector<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotations = new Vector();
    private final HashMap<String, org.eclipse.jpt.jpa.core.resource.java.Annotation> nullAnnotationCache = new HashMap();

    SourceAnnotatedElement(JavaResourceNode parent, A annotatedElement) {
        super(parent);
        this.annotatedElement = annotatedElement;
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.annotatedElement.getBodyDeclaration(astRoot).accept(this.buildInitialAnnotationVisitor(astRoot));
    }

    private ASTVisitor buildInitialAnnotationVisitor(CompilationUnit astRoot) {
        return new InitialAnnotationVisitor(astRoot, this.annotatedElement.getBodyDeclaration(astRoot));
    }

    void addInitialAnnotation(Annotation node, CompilationUnit astRoot) {
        String astAnnotationName = ASTTools.resolveAnnotation((Annotation)node);
        if (astAnnotationName != null) {
            this.addInitialAnnotation(astAnnotationName, astRoot);
        }
    }

    void addInitialAnnotation(String astAnnotationName, CompilationUnit astRoot) {
        if (this.annotationIsValid(astAnnotationName) && this.selectAnnotationNamed(this.annotations, astAnnotationName) == null) {
            org.eclipse.jpt.jpa.core.resource.java.Annotation annotation = this.buildAnnotation(astAnnotationName);
            annotation.initialize(astRoot);
            this.annotations.add(annotation);
        }
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncAnnotations(astRoot);
    }

    @Override
    public Iterator<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotations() {
        return this.getAnnotations().iterator();
    }

    Iterable<org.eclipse.jpt.jpa.core.resource.java.Annotation> getAnnotations() {
        return new LiveCloneIterable(this.annotations);
    }

    @Override
    public int annotationsSize() {
        return this.annotations.size();
    }

    @Override
    public org.eclipse.jpt.jpa.core.resource.java.Annotation getAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getAnnotations(), annotationName);
    }

    @Override
    public org.eclipse.jpt.jpa.core.resource.java.Annotation getNonNullAnnotation(String annotationName) {
        org.eclipse.jpt.jpa.core.resource.java.Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.getNullAnnotation(annotationName);
    }

    private synchronized org.eclipse.jpt.jpa.core.resource.java.Annotation getNullAnnotation(String annotationName) {
        org.eclipse.jpt.jpa.core.resource.java.Annotation annotation = this.nullAnnotationCache.get(annotationName);
        if (annotation == null) {
            annotation = this.buildNullAnnotation(annotationName);
            this.nullAnnotationCache.put(annotationName, annotation);
        }
        return annotation;
    }

    @Override
    public Iterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.getNestedAnnotations().iterator();
        }
        NestableAnnotation nestableAnnotation = this.getNestableAnnotation(nestableAnnotationName);
        if (nestableAnnotation != null) {
            return new SingleElementIterator((Object)nestableAnnotation);
        }
        return EmptyIterator.instance();
    }

    private ContainerAnnotation<NestableAnnotation> getContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.getAnnotation(annotationName);
    }

    private NestableAnnotation getNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.getAnnotation(annotationName);
    }

    @Override
    public org.eclipse.jpt.jpa.core.resource.java.Annotation addAnnotation(String annotationName) {
        org.eclipse.jpt.jpa.core.resource.java.Annotation annotation = this.buildAnnotation(annotationName);
        this.annotations.add(annotation);
        annotation.newAnnotation();
        return annotation;
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return AnnotationContainerTools.addNestedAnnotation(index, containerAnnotation);
        }
        NestableAnnotation standAloneAnnotation = this.getNestableAnnotation(nestableAnnotationName);
        if (standAloneAnnotation == null) {
            return (NestableAnnotation)this.addAnnotation(nestableAnnotationName);
        }
        return this.addSecondNestedAnnotation(index, containerAnnotationName, standAloneAnnotation);
    }

    private NestableAnnotation addSecondNestedAnnotation(int index, String containerAnnotationName, NestableAnnotation standAloneAnnotation) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.buildContainerAnnotation(containerAnnotationName);
        this.annotations.add(containerAnnotation);
        containerAnnotation.newAnnotation();
        NestableAnnotation nestedAnnotation = null;
        switch (index) {
            case 0: {
                nestedAnnotation = containerAnnotation.addNestedAnnotation();
                nestedAnnotation.newAnnotation();
                this.annotations.remove(standAloneAnnotation);
                containerAnnotation.nestStandAloneAnnotation(standAloneAnnotation);
                break;
            }
            case 1: {
                this.annotations.remove(standAloneAnnotation);
                containerAnnotation.nestStandAloneAnnotation(standAloneAnnotation);
                nestedAnnotation = containerAnnotation.addNestedAnnotation();
                nestedAnnotation.newAnnotation();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + index);
            }
        }
        return nestedAnnotation;
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        this.moveAnnotation(targetIndex, sourceIndex, this.getContainerAnnotation(containerAnnotationName));
    }

    private void moveAnnotation(int targetIndex, int sourceIndex, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, containerAnnotation);
    }

    @Override
    public void removeAnnotation(String annotationName) {
        org.eclipse.jpt.jpa.core.resource.java.Annotation annotation = this.getAnnotation(annotationName);
        if (annotation != null) {
            this.removeAnnotation(annotation);
        }
    }

    private void removeAnnotation(org.eclipse.jpt.jpa.core.resource.java.Annotation annotation) {
        this.annotations.remove(annotation);
        annotation.removeAnnotation();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation == null) {
            if (index != 0) {
                throw new IllegalArgumentException("invalid index: " + index);
            }
            this.removeAnnotation(this.getAnnotation(nestableAnnotationName));
        } else {
            this.removeAnnotation(index, containerAnnotation);
        }
    }

    private void removeAnnotation(int index, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        AnnotationContainerTools.removeNestedAnnotation(index, containerAnnotation);
        switch (containerAnnotation.getNestedAnnotationsSize()) {
            case 0: {
                this.removeAnnotation(containerAnnotation);
                break;
            }
            case 1: {
                this.convertLastNestedAnnotation(containerAnnotation);
                break;
            }
        }
    }

    private void convertLastNestedAnnotation(ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        containerAnnotation.convertLastNestedAnnotationToStandAlone();
        this.annotations.remove(containerAnnotation);
        containerAnnotation.removeAnnotation();
    }

    @Override
    public void addStandAloneAnnotation(NestableAnnotation standAloneAnnotation) {
        this.annotations.add(standAloneAnnotation);
    }

    private boolean annotationIsValid(String annotationName) {
        return CollectionTools.contains(this.validAnnotationNames(), (Object)annotationName);
    }

    abstract Iterator<String> validAnnotationNames();

    abstract org.eclipse.jpt.jpa.core.resource.java.Annotation buildAnnotation(String var1);

    abstract org.eclipse.jpt.jpa.core.resource.java.Annotation buildNullAnnotation(String var1);

    private ContainerAnnotation<NestableAnnotation> buildContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.buildAnnotation(annotationName);
    }

    private void syncAnnotations(CompilationUnit astRoot) {
        HashSet<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotationsToRemove = new HashSet<org.eclipse.jpt.jpa.core.resource.java.Annotation>(this.annotations);
        this.annotatedElement.getBodyDeclaration(astRoot).accept(this.buildSynchronizeAnnotationVisitor(astRoot, annotationsToRemove));
        this.removeItemsFromCollection(annotationsToRemove, this.annotations, "annotations");
    }

    private ASTVisitor buildSynchronizeAnnotationVisitor(CompilationUnit astRoot, Set<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotationsToRemove) {
        return new SynchronizeAnnotationVisitor(astRoot, this.annotatedElement.getBodyDeclaration(astRoot), annotationsToRemove);
    }

    void addOrSyncAnnotation(Annotation astAnnotation, CompilationUnit astRoot, Set<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotationsToRemove) {
        String astAnnotationName = ASTTools.resolveAnnotation((Annotation)astAnnotation);
        if (astAnnotationName != null) {
            this.addOrSyncAnnotation(astAnnotationName, astRoot, annotationsToRemove);
        }
    }

    void addOrSyncAnnotation(String astAnnotationName, CompilationUnit astRoot, Set<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotationsToRemove) {
        if (this.annotationIsValid(astAnnotationName)) {
            this.addOrSyncAnnotation_(astAnnotationName, astRoot, annotationsToRemove);
        }
    }

    private void addOrSyncAnnotation_(String astAnnotationName, CompilationUnit astRoot, Set<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotationsToRemove) {
        org.eclipse.jpt.jpa.core.resource.java.Annotation annotation = this.selectAnnotationNamed(annotationsToRemove, astAnnotationName);
        if (annotation != null) {
            annotation.synchronizeWith(astRoot);
            annotationsToRemove.remove(annotation);
        } else {
            annotation = this.buildAnnotation(astAnnotationName);
            annotation.initialize(astRoot);
            this.addItemToCollection(annotation, this.annotations, "annotations");
        }
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return astRoot == null ? null : this.buildTextRange(this.annotatedElement.getBodyDeclaration(astRoot));
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return astRoot == null ? null : this.annotatedElement.getNameTextRange(astRoot);
    }

    private org.eclipse.jpt.jpa.core.resource.java.Annotation selectAnnotationNamed(Iterable<org.eclipse.jpt.jpa.core.resource.java.Annotation> list, String annotationName) {
        for (org.eclipse.jpt.jpa.core.resource.java.Annotation annotation : list) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    private TextRange buildTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    static abstract class AnnotationVisitor
    extends ASTVisitor {
        final CompilationUnit astRoot;
        final ASTNode node;

        protected AnnotationVisitor(CompilationUnit astRoot, ASTNode node) {
            this.astRoot = astRoot;
            this.node = node;
        }

        public boolean visit(SingleMemberAnnotation annotation) {
            return this.visit_((Annotation)annotation);
        }

        public boolean visit(NormalAnnotation annotation) {
            return this.visit_((Annotation)annotation);
        }

        public boolean visit(MarkerAnnotation annotation) {
            return this.visit_((Annotation)annotation);
        }

        protected boolean visit_(Annotation annotation) {
            if (annotation.getParent() == this.node) {
                this.visitChildAnnotation(annotation);
            }
            return false;
        }

        protected abstract void visitChildAnnotation(Annotation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InitialAnnotationVisitor
    extends AnnotationVisitor {
        protected InitialAnnotationVisitor(CompilationUnit astRoot, ASTNode node) {
            super(astRoot, node);
        }

        @Override
        protected void visitChildAnnotation(Annotation annotation) {
            SourceAnnotatedElement.this.addInitialAnnotation(annotation, this.astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SynchronizeAnnotationVisitor
    extends AnnotationVisitor {
        protected final Set<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotationsToRemove;

        protected SynchronizeAnnotationVisitor(CompilationUnit astRoot, ASTNode node, Set<org.eclipse.jpt.jpa.core.resource.java.Annotation> annotationsToRemove) {
            super(astRoot, node);
            this.annotationsToRemove = annotationsToRemove;
        }

        @Override
        protected void visitChildAnnotation(Annotation annotation) {
            SourceAnnotatedElement.this.addOrSyncAnnotation(annotation, this.astRoot, this.annotationsToRemove);
        }
    }
}

