/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deployables;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.common.internal.modulecore.SingleRootUtil;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.internal.common.exportmodel.JavaEESingleRootCallback;
import org.eclipse.jst.j2ee.internal.deployables.J2EEDeployableFactory;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.server.core.IApplicationClientModule;
import org.eclipse.jst.server.core.IConnectorModule;
import org.eclipse.jst.server.core.IEJBModule;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IUtilityModule;
import org.eclipse.jst.server.core.IWebFragmentModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.web.internal.deployables.FlatComponentDeployable;

public class J2EEFlexProjDeployable
extends FlatComponentDeployable
implements IEnterpriseApplication,
IApplicationClientModule,
IConnectorModule,
IEJBModule,
IWebModule,
IUtilityModule,
IWebFragmentModule {
    public J2EEFlexProjDeployable(IProject project, IVirtualComponent aComponent) {
        super(project, aComponent);
    }

    public J2EEFlexProjDeployable(IProject project) {
        super(project);
    }

    public boolean shouldCache() {
        return true;
    }

    public boolean isSingleRootStructure() {
        return new SingleRootUtil(this.getComponent(), (SingleRootUtil.SingleRootCallback)new JavaEESingleRootCallback()).isSingleRoot();
    }

    public String[] getDefaultFlattenParticipantIDs() {
        String[] defaultParticipants = new String[]{"JEESingleRootParticipant", "JEEHeirarchyExportParticipant", "AddClasspathLibReferencesParticipant", "AddClasspathFoldersParticipant", "AddMappedOutputFoldersParticipant", "IgnoreJavaInSourceFolderParticipant", "FilterResourceParticipant"};
        ArrayList<String> vals = new ArrayList<String>();
        vals.addAll(Arrays.asList(defaultParticipants));
        if (ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            vals.add("JEEReplaceManifestExportParticipant");
        }
        return vals.toArray(new String[vals.size()]);
    }

    protected IModule gatherModuleReference(IVirtualComponent component, IChildModuleReference child) {
        if (!child.isBinary()) {
            return super.gatherModuleReference(component, child);
        }
        return J2EEDeployableFactory.j2eeInstance().createChildModule(this, child);
    }

    protected IModule filterModuleDelegates(IModule[] modules) {
        int i = 0;
        while (i < modules.length) {
            ModuleDelegate md = (ModuleDelegate)modules[i].loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            if (md instanceof J2EEFlexProjDeployable) {
                return modules[i];
            }
            ++i;
        }
        return super.filterModuleDelegates(modules);
    }

    public String getJNDIName(String ejbName) {
        if (!JavaEEProjectUtilities.isEJBProject(this.component.getProject())) {
            return null;
        }
        EjbModuleExtensionHelper modHelper = null;
        EJBJar jar = null;
        ArtifactEdit ejbEdit = null;
        try {
            ejbEdit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)this.component);
            if (ejbEdit != null) {
                jar = (EJBJar)ejbEdit.getContentModelRoot();
                modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
                String string = modHelper == null ? null : modHelper.getJNDIName(jar, jar.getEnterpriseBeanNamed(ejbName));
                return string;
            }
        }
        catch (Exception e) {
            J2EEPlugin.logError(e);
        }
        finally {
            if (ejbEdit != null) {
                ejbEdit.dispose();
            }
        }
        return null;
    }

    public String getContextRoot() {
        Properties props = this.component.getMetaProperties();
        if (props.containsKey("context-root")) {
            return props.getProperty("context-root");
        }
        return this.component.getName();
    }

    public String getContextRoot(IModule earModule) {
        IProject deployProject = this.component.getProject();
        String contextRoot = null;
        if (earModule == null) {
            return this.getContextRoot();
        }
        if (JavaEEProjectUtilities.isEARProject(earModule.getProject()) && JavaEEProjectUtilities.isDynamicWebProject(deployProject)) {
            EARArtifactEdit edit = null;
            try {
                edit = EARArtifactEdit.getEARArtifactEditForRead(earModule.getProject());
                contextRoot = edit.getWebContextRoot(deployProject);
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return contextRoot;
    }

    public IContainer[] getResourceFolders() {
        IVirtualFolder vFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null && (vFolder = vc.getRootFolder()) != null) {
            return vFolder.getUnderlyingFolders();
        }
        return new IContainer[0];
    }

    public IContainer[] getJavaOutputFolders() {
        return this.getJavaOutputFolders(this.component);
    }

    public IContainer[] getJavaOutputFolders(IVirtualComponent component) {
        if (component == null) {
            return new IContainer[0];
        }
        List l = JavaLiteUtilities.getJavaOutputContainers((IVirtualComponent)component);
        return l.toArray(new IContainer[l.size()]);
    }

    public IPath[] getClasspath() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IJavaProject proj = JemProjectUtilities.getJavaProject((IProject)this.getProject());
        URL[] urls = JemProjectUtilities.getClasspathAsURLArray((IJavaProject)proj);
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            paths.add(Path.fromOSString((String)url.getPath()));
            ++i;
        }
        return paths.toArray(new IPath[paths.size()]);
    }
}

