/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.ArrayList;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.internal.driver.AbstractDTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapterFactory;
import org.eclipse.jpt.jpa.db.internal.driver.FauxCatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.FoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.UpperCaseFoldingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Derby
extends AbstractDTPDriverAdapter {
    private static final String DEFAULT_USER_NAME = "APP";

    Derby(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new FauxCatalogStrategy(this.database.getDTPDatabase());
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return UpperCaseFoldingStrategy.instance();
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        names.add(this.getDefaultSchemaName());
    }

    private String getDefaultSchemaName() {
        String userName = this.getUserName();
        return userName != null && userName.length() != 0 ? userName : DEFAULT_USER_NAME;
    }

    static class Factory
    implements DTPDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"Derby"};

        Factory() {
        }

        public String[] getSupportedVendors() {
            return VENDORS;
        }

        public DTPDriverAdapter buildAdapter(Database database) {
            return new Derby(database);
        }
    }
}

