/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactoringProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class UpdateDependentProjectOp
extends AbstractDataModelOperation
implements ProjectRefactoringProperties {
    public UpdateDependentProjectOp(IDataModel model) {
        super(model);
    }

    protected static IVirtualReference hadReference(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata refactoredMetadata) {
        IVirtualComponent refactoredComp = refactoredMetadata.getVirtualComponent();
        if (refactoredComp == null) {
            return null;
        }
        IVirtualReference[] refs = dependentMetadata.getVirtualComponent().getReferences();
        IVirtualReference ref = null;
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getReferencedComponent().equals(refactoredComp)) {
                ref = refs[i];
                break;
            }
            ++i;
        }
        return ref;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean hadProjectReference(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata refactoredMetadata) {
        try {
            IProject[] refs = dependentMetadata.getProject().getDescription().getReferencedProjects();
            IProject refactoredProject = refactoredMetadata.getProject();
            int i = 0;
            while (true) {
                if (i >= refs.length) {
                    return false;
                }
                if (refs[i].equals((Object)refactoredProject)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            J2EEPlugin.logError(ce);
        }
        return false;
    }

    protected static boolean hasWebLibDependency(IVirtualReference ref) {
        if (ref == null) {
            return false;
        }
        return ref.getRuntimePath().equals((Object)new Path("/WEB-INF/lib"));
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }
}

