/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.jfaces.extension;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURL;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURLExtension;
import org.eclipse.wst.common.core.util.RegistryReader;

public class FileURLExtensionReader
extends RegistryReader {
    static FileURLExtensionReader instance = null;
    protected List fileURLExtensions;

    public FileURLExtensionReader() {
        super("org.eclipse.jst.j2ee.web", "fileURL");
    }

    public boolean readElement(IConfigurationElement element) {
        if ("fileURL".equals(element.getName())) {
            this.addExtension(element);
            return true;
        }
        return false;
    }

    protected void addExtension(IConfigurationElement newExtension) {
        this.getFileURLExtensions().add(new FileURLExtension(newExtension));
    }

    protected void addExtensionPoint(FileURLExtensionReader newExtension) {
        if (this.fileURLExtensions == null) {
            this.fileURLExtensions = new ArrayList();
        }
        this.fileURLExtensions.add(newExtension);
    }

    public FileURL getFilesURL() {
        ArrayList<FileURL> fileUrlList = new ArrayList<FileURL>();
        FileURL currentURL = null;
        for (FileURLExtension fileURLExt : this.getFileURLExtensions()) {
            currentURL = fileURLExt.getInstance();
            if (currentURL == null) continue;
            fileUrlList.add(currentURL);
        }
        if (fileUrlList.size() == 1) {
            return (FileURL)fileUrlList.get(0);
        }
        return new FileURLWrapper(fileUrlList);
    }

    public static FileURLExtensionReader getInstance() {
        if (instance == null) {
            instance = new FileURLExtensionReader();
            instance.readRegistry();
        }
        return instance;
    }

    protected List getFileURLExtensions() {
        if (this.fileURLExtensions == null) {
            this.fileURLExtensions = new ArrayList();
        }
        return this.fileURLExtensions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileURLWrapper
    implements FileURL {
        ArrayList<FileURL> myUrlList = new ArrayList();

        public FileURLWrapper(ArrayList<FileURL> newUrlList) {
            this.myUrlList = newUrlList;
        }

        @Override
        public IPath getFileURL(IResource resource, IPath existingURL) {
            IPath retVal = existingURL;
            for (FileURL fileUrl : this.myUrlList) {
                retVal = fileUrl.getFileURL(resource, existingURL);
                if (retVal == existingURL || retVal == null) continue;
                return retVal;
            }
            return retVal;
        }
    }
}

