/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveSaveAdapter;
import org.eclipse.jst.j2ee.internal.archive.EARComponentArchiveSaveAdapter;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactImportOperation;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EARComponentImportOperation
extends J2EEArtifactImportOperation {
    protected EnterpriseArtifactEdit artifactEdit = null;
    protected final int LINK_COMPONENTS_WORK = 10;
    protected final int WEB_LIB_WORK = 10;
    protected final int DISPOSE_WORK = 10;

    public EARComponentImportOperation(IDataModel model) {
        super(model);
    }

    protected ComponentArchiveSaveAdapter getArchiveSaveAdapter(IVirtualComponent virtualComponent) {
        return new EARComponentArchiveSaveAdapter(virtualComponent);
    }

    protected int computeTotalWork() {
        int baseWork = super.computeTotalWork() + 10 + 10;
        List modelsToImport = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
        IDataModel importModel = null;
        int i = 0;
        while (i < modelsToImport.size()) {
            importModel = (IDataModel)modelsToImport.get(i);
            ArchiveWrapper nestedArchive = (ArchiveWrapper)importModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
            baseWork += 40 + nestedArchive.getSize();
            ++i;
        }
        return baseWork;
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        ExecutionException firstNestedException = null;
        try {
            if (UIContextDetermination.getCurrentContext() == 102) {
                J2EEComponentClasspathUpdater.getInstance().setSuspendPostChangeEvents(true);
            }
            super.doExecute(monitor);
            List modelsToImport = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
            IDataModel importModel = null;
            int i = modelsToImport.size() - 1;
            while (i > 0) {
                importModel = (IDataModel)modelsToImport.get(i);
                ArchiveWrapper nestedArchive = (ArchiveWrapper)importModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
                if (nestedArchive.getPath().toString().startsWith("WEB-INF/lib/")) {
                    ArchiveWrapper owningWar = nestedArchive.getParent();
                    modelsToImport.remove(importModel);
                    int j = 0;
                    while (j < modelsToImport.size()) {
                        IDataModel warModel = (IDataModel)modelsToImport.get(j);
                        if (((ArchiveWrapper)warModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")).getUnderLyingArchive() == owningWar.getUnderLyingArchive()) {
                            String archivesSelected = "WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED";
                            String libModels = "WARImportDataModel.WEB_LIB_MODELS";
                            ArrayList<ArchiveWrapper> warHandledArchives = (ArrayList<ArchiveWrapper>)warModel.getProperty(archivesSelected);
                            if (warHandledArchives == Collections.EMPTY_LIST) {
                                warHandledArchives = new ArrayList<ArchiveWrapper>();
                                warModel.setProperty(archivesSelected, warHandledArchives);
                            }
                            warHandledArchives.add(nestedArchive);
                            List warLibModels = (List)warModel.getProperty(libModels);
                            int k = 0;
                            while (k < warLibModels.size()) {
                                IDataModel libModel = (IDataModel)warLibModels.get(k);
                                if (((ArchiveWrapper)libModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")).getUnderLyingArchive() == nestedArchive.getUnderLyingArchive()) {
                                    libModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", importModel.getProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME"));
                                    libModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", importModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"));
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                --i;
            }
            monitor.worked(10);
            List<String> ddSpecifiedURIs = ((ArchiveWrapper)this.model.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")).getDDMappedModuleURIs();
            ArrayList<IVirtualComponent> componentToAddAsModules = new ArrayList<IVirtualComponent>();
            HashMap<IVirtualComponent, String> componentToURIMapAsModules = new HashMap<IVirtualComponent, String>();
            ArrayList<IVirtualComponent> componentToAddAsComponents = new ArrayList<IVirtualComponent>();
            HashMap<IVirtualComponent, String> componentToURIMapAsComponents = new HashMap<IVirtualComponent, String>();
            HashMap<IVirtualComponent, String> moduleDeployPathMap = new HashMap<IVirtualComponent, String>();
            HashMap<IVirtualComponent, String> componentDeployPathMap = new HashMap<IVirtualComponent, String>();
            int i2 = 0;
            while (i2 < modelsToImport.size()) {
                importModel = (IDataModel)modelsToImport.get(i2);
                ArchiveWrapper nestedArchive = (ArchiveWrapper)importModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
                importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)Boolean.FALSE);
                IDataModel compCreationModel = importModel.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
                if (compCreationModel.isProperty("IJ2EEFacetProjectCreationDataModelProperties.MODULE_URI")) {
                    compCreationModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.MODULE_URI", (Object)nestedArchive.getPath().toString());
                }
                compCreationModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", false);
                try {
                    IStatus nestedImportStatus = importModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(monitor, 30 + nestedArchive.getSize()), this.info);
                    if (!nestedImportStatus.isOK() && nestedImportStatus.getSeverity() == 4) {
                        throw new ExecutionException(nestedImportStatus.getMessage(), nestedImportStatus.getException());
                    }
                }
                catch (ExecutionException e) {
                    if (firstNestedException == null) {
                        firstNestedException = e;
                    }
                    J2EEPlugin.logError(e);
                }
                IVirtualComponent component = (IVirtualComponent)importModel.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT");
                String uri = nestedArchive.getPath().toString();
                String absoluteUri = nestedArchive.getPath().makeAbsolute().toString();
                String archiveName = nestedArchive.getPath().lastSegment().toString();
                String deployPath = nestedArchive.getPath().removeLastSegments(1).makeAbsolute().toString();
                if (ddSpecifiedURIs.contains(uri) || ddSpecifiedURIs.contains(absoluteUri)) {
                    componentToAddAsModules.add(component);
                    componentToURIMapAsModules.put(component, archiveName);
                    moduleDeployPathMap.put(component, deployPath);
                } else {
                    componentToAddAsComponents.add(component);
                    componentToURIMapAsComponents.put(component, archiveName);
                    componentDeployPathMap.put(component, deployPath);
                }
                ++i2;
            }
            if (componentToAddAsModules.size() > 0) {
                IDataModel addComponentsDM = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.virtualComponent);
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", componentToAddAsModules);
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", componentToURIMapAsModules);
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH_MAP", moduleDeployPathMap);
                addComponentsDM.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(monitor, 5), this.info);
            }
            if (componentToAddAsComponents.size() > 0) {
                IDataModel addComponentsDM = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.virtualComponent);
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", componentToAddAsComponents);
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", componentToURIMapAsComponents);
                addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH_MAP", componentDeployPathMap);
                addComponentsDM.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(monitor, 5), this.info);
            }
        }
        finally {
            if (this.artifactEdit != null) {
                this.artifactEdit.dispose();
                this.artifactEdit = null;
            }
            this.resetDisposeImportModels();
            monitor.worked(10);
            if (UIContextDetermination.getCurrentContext() == 102) {
                J2EEComponentClasspathUpdater.getInstance().setSuspendPostChangeEvents(false);
            }
        }
        if (firstNestedException != null) {
            throw firstNestedException;
        }
    }

    private void resetDisposeImportModels() {
        this.resetDisposeImportModels((List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST"));
    }

    private void resetDisposeImportModels(List models) {
        int i = 0;
        while (i < models.size()) {
            IDataModel model = (IDataModel)models.get(i);
            model.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)Boolean.TRUE);
            ++i;
        }
    }
}

